/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.util;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.atlas.atlascore.AtlasCore;
import net.atlas.atlascore.command.argument.Argument;
import net.minecraft.class_5699;

public class Codecs {
    public static Codec<Double> doubleRangeMinInclusiveWithMessage(double d, double e, Function<Double, String> function) {
        return class_5699.method_48112((Codec)Codec.DOUBLE, double_ -> double_.compareTo(d) >= 0 && double_.compareTo(e) <= 0 ? DataResult.success((Object)double_) : DataResult.error(() -> (String)function.apply((Double)double_)));
    }

    public static Codec<Double> doubleRangeMinExclusiveWithMessage(double d, double e, Function<Double, String> function) {
        return class_5699.method_48112((Codec)Codec.DOUBLE, double_ -> double_.compareTo(d) > 0 && double_.compareTo(e) <= 0 ? DataResult.success((Object)double_) : DataResult.error(() -> (String)function.apply((Double)double_)));
    }

    public static Codec<Double> doubleRange(double d, double e) {
        return Codecs.doubleRangeMinInclusiveWithMessage(d, e, double_ -> "Value must be within range [" + d + ";" + e + "]: " + double_);
    }

    public static <S, V> List<V> getArguments(CommandContext<S> context, Class<V> clazz) {
        return Codecs.getArguments(context).values().stream().map(ParsedArgument::getResult).filter(argument -> Argument.Arguments.PRIMITIVE_TO_WRAPPER.getOrDefault(clazz, clazz).isAssignableFrom(argument.getClass())).map(argument -> argument).toList();
    }

    public static <S> boolean hasArgument(CommandContext<S> context, String name) {
        return Codecs.getArguments(context).containsKey(name);
    }

    private static <S> Map<String, ParsedArgument<S, ?>> getArguments(CommandContext<S> context) {
        Map<String, Object> argumentMap;
        try {
            Field arguments = CommandContext.class.getDeclaredField("arguments");
            arguments.setAccessible(true);
            argumentMap = (Map)arguments.get(context);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            argumentMap = new HashMap();
            AtlasCore.LOGGER.error("Failed to get command arguments! Exception: {}", e);
        }
        return argumentMap;
    }
}

