/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.client.gui;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TextFieldListEntry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class CodecBackedListEntry<T>
extends TextFieldListEntry<Tag> {
    private final Codec<T> codec;

    @Deprecated
    @ApiStatus.Internal
    public CodecBackedListEntry(Component fieldName, Codec<T> codec, Tag value, Component resetButtonKey, Supplier<Tag> defaultValue, Consumer<Tag> saveConsumer) {
        super(fieldName, (Object)value, resetButtonKey, defaultValue);
        this.saveCallback = saveConsumer;
        this.codec = codec;
    }

    @Deprecated
    @ApiStatus.Internal
    public CodecBackedListEntry(Component fieldName, Codec<T> codec, Tag value, Component resetButtonKey, Supplier<Tag> defaultValue, Consumer<Tag> saveConsumer, Supplier<Optional<Component[]>> tooltipSupplier) {
        this(fieldName, codec, value, resetButtonKey, defaultValue, saveConsumer, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public CodecBackedListEntry(Component fieldName, Codec<T> codec, Tag value, Component resetButtonKey, Supplier<Tag> defaultValue, Consumer<Tag> saveConsumer, Supplier<Optional<Component[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, (Object)value, resetButtonKey, defaultValue, tooltipSupplier, requiresRestart);
        this.saveCallback = saveConsumer;
        this.codec = codec;
    }

    protected boolean isChanged(Tag original, String s) {
        return !original.getAsString().equals(s);
    }

    public Tag getValue() {
        StringReader reader = new StringReader(this.textFieldWidget.getValue());
        try {
            return new TagParser(reader).readValue();
        }
        catch (CommandSyntaxException e) {
            return new CompoundTag();
        }
    }

    public Optional<Component> getError() {
        StringReader reader = new StringReader(this.textFieldWidget.getValue());
        AtomicReference optional = new AtomicReference(Optional.empty());
        try {
            Tag tag = new TagParser(reader).readValue();
            DataResult dataResult = this.codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag);
            dataResult.ifError(error -> optional.set(Optional.of(Component.literal((String)error.toString()))));
        }
        catch (CommandSyntaxException e) {
            return Optional.of(Component.literal((String)e.toString()));
        }
        return optional.get();
    }
}

