/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.config;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListEntry;
import net.atlas.atlascore.AtlasCore;
import net.atlas.atlascore.config.AtlasConfig;
import net.atlas.atlascore.util.ConfigRepresentable;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class AtlasCoreConfig
extends AtlasConfig {
    public AtlasConfig.TagHolder<ItemStack> testItem;
    public AtlasConfig.ObjectHolder<TestClass> testObject;
    public AtlasConfig.EnumHolder<TestEnum> testEnum;
    public AtlasConfig.StringHolder testString;
    public AtlasConfig.BooleanHolder testBool;
    public AtlasConfig.IntegerHolder testInt;
    public AtlasConfig.DoubleHolder testDouble;
    public AtlasConfig.ColorHolder configNameDisplayColour;
    public AtlasConfig.ColorHolder grayFormattingColour;
    public AtlasConfig.BooleanHolder listClientModsOnJoin;
    private AtlasConfig.Category test;
    private AtlasConfig.Category formatting;
    private AtlasConfig.Category debug;

    public AtlasCoreConfig() {
        super(AtlasCore.id("atlas-core-config"));
    }

    @Override
    public void defineConfigHolders() {
        this.testItem = this.createCodecBacked("testItem", new ItemStack((ItemLike)Items.APPLE, 18), ItemStack.STRICT_CODEC);
        this.testItem.tieToCategory(this.test);
        this.testObject = this.createObject("testObject", new TestClass(this.testObject, "bar", true, 3, 7.0), TestClass.class, TestClass.STREAM_CODEC);
        this.testObject.tieToCategory(this.test);
        this.testEnum = this.createEnum("testEnum", TestEnum.FOO, TestEnum.class, TestEnum.values(), e -> Component.translatable((String)("text.config.atlas-core-config.option.testEnum." + e.name().toLowerCase(Locale.ROOT))));
        this.testEnum.tieToCategory(this.test);
        this.testString = this.createString("testString", "foo");
        this.testString.tieToCategory(this.test);
        this.testBool = this.createBoolean("testBool", true);
        this.testBool.tieToCategory(this.test);
        this.testInt = this.createInRestrictedValues("testInt", (Integer)1, 1, 3, 5, 7, 9);
        this.testInt.tieToCategory(this.test);
        this.testDouble = this.createDoubleUnbound("testDouble", 0.0);
        this.testDouble.tieToCategory(this.test);
        this.configNameDisplayColour = this.createColor("configNameDisplayColour", 57343, false);
        this.configNameDisplayColour.tieToCategory(this.formatting);
        this.grayFormattingColour = this.createColor("grayFormattingColour", 12502994, false);
        this.grayFormattingColour.tieToCategory(this.formatting);
        this.listClientModsOnJoin = this.createBoolean("listClientModsOnJoin", false);
        this.listClientModsOnJoin.tieToCategory(this.debug);
    }

    @Override
    @NotNull
    public List<AtlasConfig.Category> createCategories() {
        List<AtlasConfig.Category> categoryList = super.createCategories();
        this.test = new AtlasConfig.Category(this, "test_options", new ArrayList());
        this.formatting = new AtlasConfig.Category(this, "text_formatting", new ArrayList());
        this.debug = new AtlasConfig.Category(this, "debug_options", new ArrayList());
        categoryList.add(this.formatting);
        categoryList.add(this.debug);
        categoryList.add(this.test);
        return categoryList;
    }

    @Override
    public Component getFormattedName() {
        return Component.translatableWithFallback((String)("text.config." + this.name.getPath() + ".title"), (String)"Atlas Core").withStyle(Style.EMPTY.withColor(((Integer)this.configNameDisplayColour.get()).intValue()));
    }

    @Override
    public void resetExtraHolders() {
    }

    @Override
    public <T> void alertChange(AtlasConfig.ConfigValue<T> tConfigValue, T newValue) {
    }

    @Override
    public <T> void alertClientValue(AtlasConfig.ConfigValue<T> tConfigValue, T serverValue, T clientValue) {
    }

    @Override
    protected void loadExtra(JsonObject jsonObject) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleExtraSync(AtlasCore.AtlasConfigPacket packet, ClientPlayNetworking.Context context) {
    }

    @Override
    public void handleConfigInformation(AtlasCore.ClientInformPacket packet, ServerPlayer player, PacketSender sender) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Screen createScreen(Screen prevScreen) {
        return null;
    }

    public static class TestClass
    implements ConfigRepresentable<TestClass> {
        public static final StreamCodec<RegistryFriendlyByteBuf, TestClass> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, TestClass>(){

            public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, TestClass testClass) {
                registryFriendlyByteBuf.writeResourceLocation(testClass.owner.heldValue.owner().name);
                registryFriendlyByteBuf.writeUtf(testClass.owner.heldValue.name());
                registryFriendlyByteBuf.writeUtf(testClass.innerString);
                registryFriendlyByteBuf.writeBoolean(testClass.innerBool.booleanValue());
                registryFriendlyByteBuf.writeVarInt(testClass.innerInt.intValue());
                registryFriendlyByteBuf.writeDouble(testClass.innerDouble.doubleValue());
            }

            @NotNull
            public TestClass decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
                AtlasConfig config = AtlasConfig.configs.get(registryFriendlyByteBuf.readResourceLocation());
                return new TestClass(config.valueNameToConfigHolderMap.get(registryFriendlyByteBuf.readUtf()), registryFriendlyByteBuf.readUtf(), registryFriendlyByteBuf.readBoolean(), registryFriendlyByteBuf.readVarInt(), registryFriendlyByteBuf.readDouble());
            }
        };
        public AtlasConfig.ConfigHolder<TestClass> owner;
        public String innerString;
        public Boolean innerBool;
        public Integer innerInt;
        public Double innerDouble;
        public static final Map<String, Field> fields = (Map)Util.make(new HashMap(), hashMap -> {
            try {
                hashMap.put("inner_string", TestClass.class.getDeclaredField("innerString"));
                hashMap.put("inner_bool", TestClass.class.getDeclaredField("innerBool"));
                hashMap.put("inner_int", TestClass.class.getDeclaredField("innerInt"));
                hashMap.put("inner_double", TestClass.class.getDeclaredField("innerDouble"));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        });
        public static final BiFunction<TestClass, String, Component> convertFieldToComponent = (testClass, string) -> {
            try {
                return Component.translatable((String)(testClass.owner.getTranslationKey() + "." + string)).append((Component)Component.literal((String)": ")).append((Component)Component.literal((String)String.valueOf(testClass.fieldRepresentingHolder((String)string).get(testClass))));
            }
            catch (IllegalAccessException illegalAccessException) {
                return Component.translatable((String)(testClass.owner.getTranslationKey() + "." + string));
            }
        };
        public static final BiFunction<TestClass, String, Component> convertFieldToNameComponent = (testClass, string) -> Component.translatable((String)(testClass.owner.getTranslationKey() + "." + string));
        public static final BiFunction<TestClass, String, Component> convertFieldToValueComponent = (testClass, string) -> {
            try {
                return Component.literal((String)String.valueOf(testClass.fieldRepresentingHolder((String)string).get(testClass)));
            }
            catch (IllegalAccessException illegalAccessException) {
                return Component.translatable((String)(testClass.owner.getTranslationKey() + "." + string));
            }
        };
        public Supplier<Component> resetTranslation = null;

        public String innerString() {
            return this.innerString;
        }

        public Boolean innerBool() {
            return this.innerBool;
        }

        public Integer innerInt() {
            return this.innerInt;
        }

        public Double innerDouble() {
            return this.innerDouble;
        }

        public TestClass(AtlasConfig.ConfigHolder<TestClass> owner, String innerString, Boolean innerBool, Integer innerInt, Double innerDouble) {
            this.owner = owner;
            this.innerString = innerString;
            this.innerBool = innerBool;
            this.innerInt = innerInt;
            this.innerDouble = innerDouble;
        }

        @Override
        public Codec<TestClass> getCodec(AtlasConfig.ConfigHolder<TestClass> owner) {
            return RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("inner_string", (Object)"bar").forGetter(TestClass::innerString), (App)Codec.BOOL.optionalFieldOf("inner_bool", (Object)true).forGetter(TestClass::innerBool), (App)Codec.INT.optionalFieldOf("inner_int", (Object)3).forGetter(TestClass::innerInt), (App)Codec.DOUBLE.optionalFieldOf("inner_double", (Object)7.0).forGetter(TestClass::innerDouble)).apply((Applicative)instance, (innerString, innerBool, innerInt, innerDouble) -> new TestClass(owner, (String)innerString, (Boolean)innerBool, (Integer)innerInt, (Double)innerDouble)));
        }

        @Override
        public void setOwnerHolder(AtlasConfig.ConfigHolder<TestClass> configHolder) {
            this.owner = configHolder;
        }

        @Override
        public List<String> fields() {
            return fields.keySet().stream().toList();
        }

        @Override
        public Component getFieldValue(String name) {
            return convertFieldToValueComponent.apply(this, name);
        }

        @Override
        public Component getFieldName(String name) {
            return convertFieldToNameComponent.apply(this, name);
        }

        @Override
        public void listField(String name, Consumer<Component> input) {
            input.accept(convertFieldToComponent.apply(this, name));
        }

        @Override
        public void listFields(Consumer<Component> input) {
            fields.keySet().forEach(string -> input.accept(convertFieldToComponent.apply(this, (String)string)));
        }

        @Override
        public Field fieldRepresentingHolder(String name) {
            return fields.get(name);
        }

        @Override
        public ArgumentType<?> argumentTypeRepresentingHolder(String name) {
            try {
                Object object = fields.get(name).get(this);
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Boolean.class, Integer.class, Double.class}, (Object)object, n)) {
                    case 0 -> {
                        String ignored = (String)object;
                        yield StringArgumentType.greedyString();
                    }
                    case 1 -> {
                        Boolean ignored = (Boolean)object;
                        yield BoolArgumentType.bool();
                    }
                    case 2 -> {
                        Integer ignored = (Integer)object;
                        yield IntegerArgumentType.integer();
                    }
                    case 3 -> {
                        Double ignored = (Double)object;
                        yield DoubleArgumentType.doubleArg();
                    }
                    default -> null;
                };
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public List<AbstractConfigListEntry<?>> transformIntoConfigEntries() {
            if (this.resetTranslation == null) {
                this.resetTranslation = () -> Component.translatable((String)this.owner.getTranslationResetKey());
            }
            ArrayList entries = new ArrayList();
            entries.add((AbstractConfigListEntry<?>)new StringListEntry(convertFieldToNameComponent.apply(this, "inner_string"), this.innerString, this.resetTranslation.get(), () -> "bar", string -> {
                this.innerString = string;
            }, Optional::empty, false));
            entries.add((AbstractConfigListEntry<?>)new BooleanListEntry(convertFieldToNameComponent.apply(this, "inner_bool"), this.innerBool.booleanValue(), this.resetTranslation.get(), () -> true, bool -> {
                this.innerBool = bool;
            }, Optional::empty, false));
            entries.add((AbstractConfigListEntry<?>)new IntegerListEntry(convertFieldToNameComponent.apply(this, "inner_int"), this.innerInt, this.resetTranslation.get(), () -> 3, integer -> {
                this.innerInt = integer;
            }, Optional::empty, false));
            entries.add((AbstractConfigListEntry<?>)new DoubleListEntry(convertFieldToNameComponent.apply(this, "inner_double"), this.innerDouble, this.resetTranslation.get(), () -> 7.0, aDouble -> {
                this.innerDouble = aDouble;
            }, Optional::empty, false));
            return entries;
        }
    }

    public static enum TestEnum {
        FOO,
        BAR;

    }
}

