/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record ModRepresentation(String name, String modID, Collection<ModRepresentation> provided, Version version) {
    public static final Version UNKNOWN;
    public static final StreamCodec<FriendlyByteBuf, ModRepresentation> CODEC;

    public static ModRepresentation readFromBuf(FriendlyByteBuf buf) {
        Version version;
        String name = buf.readUtf();
        String modID = buf.readUtf();
        int providedSize = buf.readVarInt();
        ArrayList<ModRepresentation> provided = new ArrayList<ModRepresentation>();
        for (int i = 0; i < providedSize; ++i) {
            provided.add(ModRepresentation.readFromBuf(buf));
        }
        try {
            version = Version.parse((String)buf.readUtf());
        }
        catch (VersionParsingException e) {
            version = UNKNOWN;
        }
        return new ModRepresentation(name, modID, Collections.unmodifiableList(provided), version);
    }

    public static void writeToBuf(FriendlyByteBuf buf, ModRepresentation modRepresentation) {
        buf.writeUtf(modRepresentation.name());
        buf.writeUtf(modRepresentation.modID());
        buf.writeVarInt(modRepresentation.provided().size());
        for (ModRepresentation str : modRepresentation.provided()) {
            ModRepresentation.writeToBuf(buf, str);
        }
        buf.writeUtf(modRepresentation.version().getFriendlyString());
    }

    public static Collection<ModRepresentation> mapFromModContainers(Collection<ModContainer> mods) {
        return mods.stream().map(modContainer -> {
            if (modContainer.getContainedMods().isEmpty()) {
                return new ModRepresentation(modContainer.getMetadata().getName(), modContainer.getMetadata().getId(), Collections.emptyList(), modContainer.getMetadata().getVersion());
            }
            return new ModRepresentation(modContainer.getMetadata().getName(), modContainer.getMetadata().getId(), ModRepresentation.mapFromModContainers(modContainer.getContainedMods()), modContainer.getMetadata().getVersion());
        }).toList();
    }

    public void list(Consumer<String> stringConsumer, Function<ModRepresentation, String> name, String prefix) {
        stringConsumer.accept(prefix + name.apply(this) + ": " + String.valueOf(this.version()));
        if (!this.provided.isEmpty()) {
            this.provided.stream().sorted(Comparator.comparing(name)).forEach(modRepresentation -> modRepresentation.list(string -> stringConsumer.accept("  " + string), name, prefix));
        }
    }

    static {
        try {
            UNKNOWN = Version.parse((String)"1.0.0-UNKNOWN");
        }
        catch (VersionParsingException e) {
            throw new RuntimeException(e);
        }
        CODEC = StreamCodec.of(ModRepresentation::writeToBuf, ModRepresentation::readFromBuf);
    }
}

