/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import net.atlas.atlascore.AtlasCore;
import net.atlas.atlascore.command.argument.AtlasConfigArgument;
import net.atlas.atlascore.command.argument.ConfigHolderArgument;
import net.atlas.atlascore.config.AtlasConfig;
import net.atlas.atlascore.config.ConfigHolderLike;
import net.atlas.atlascore.config.ExtendedHolder;
import net.atlas.atlascore.util.ComponentUtils;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_12099;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class ConfigCommand {
    public static void register(CommandDispatcher<class_2168> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"atlas_config").requires(commandSourceStack -> commandSourceStack.method_75037().hasPermission(class_12099.field_63210))).then(class_2170.method_9247((String)"reload").executes(ConfigCommand::reloadAll))).then(class_2170.method_9247((String)"read").executes(ConfigCommand::readAll))).then(class_2170.method_9247((String)"reset").executes(ConfigCommand::resetAll))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"config", (ArgumentType)AtlasConfigArgument.context(false)).then(class_2170.method_9247((String)"reload").executes(context -> ConfigCommand.reload((CommandContext<class_2168>)context, AtlasConfigArgument.getConfig(context, "config"))))).then(class_2170.method_9247((String)"read").executes(context -> ConfigCommand.readConfig((CommandContext<class_2168>)context, AtlasConfigArgument.getConfig(context, "config"))))).then(class_2170.method_9247((String)"reset").executes(context -> ConfigCommand.resetConfig((CommandContext<class_2168>)context, AtlasConfigArgument.getConfig(context, "config"))))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"holder", (ArgumentType)ConfigHolderArgument.configHolderArgument("config")).then(class_2170.method_9247((String)"retrieve").executes(context -> ConfigCommand.readConfigHolder((CommandContext<class_2168>)context, AtlasConfigArgument.getConfig(context, "config"), ConfigHolderArgument.getConfigHolder(context, "holder"))))).then(class_2170.method_9247((String)"edit").then(class_2170.method_9244((String)"value", (ArgumentType)ConfigHolderArgument.ConfigValueArgument.configValueArgument("holder")).executes(context -> ConfigCommand.updateConfigValue((CommandContext<class_2168>)context, AtlasConfigArgument.getConfig(context, "config"), ConfigHolderArgument.getConfigHolder(context, "holder")))))).then(class_2170.method_9247((String)"reset").executes(context -> ConfigCommand.resetConfigValue((CommandContext<class_2168>)context, AtlasConfigArgument.getConfig(context, "config"), ConfigHolderArgument.getConfigHolder(context, "holder")))))));
    }

    private static int readAll(CommandContext<class_2168> context) {
        for (AtlasConfig config : AtlasConfig.configs.values()) {
            ConfigCommand.readConfig(context, config);
        }
        return 1;
    }

    private static int readConfig(CommandContext<class_2168> context, AtlasConfig config) {
        ConfigCommand.createConfigInformation(config, arg_0 -> ((class_2168)((class_2168)context.getSource())).method_45068(arg_0));
        return 1;
    }

    private static int readConfigHolder(CommandContext<class_2168> context, AtlasConfig config, ConfigHolderLike<?> configHolder) {
        ((class_2168)context.getSource()).method_45068((class_2561)ComponentUtils.separatorLine(config.getFormattedName().method_27661(), true));
        if (configHolder instanceof ExtendedHolder) {
            ExtendedHolder extendedHolder = (ExtendedHolder)((Object)configHolder);
            ((class_2168)context.getSource()).method_45068((class_2561)ComponentUtils.separatorLine(class_2561.method_43471((String)configHolder.getAsHolder().getTranslationKey())));
            extendedHolder.fulfilListing(component -> ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"  \u00bb ").method_10852(component)));
        } else if (!(configHolder instanceof AtlasConfig.ConfigHolder)) {
            ((class_2168)context.getSource()).method_45068((class_2561)ComponentUtils.separatorLine(class_2561.method_43471((String)configHolder.getAsHolder().getTranslationKey())));
            ((ExtendedHolder)((Object)configHolder.getAsHolder())).listInner(configHolder.getName(), component -> ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"  \u00bb ").method_10852(component)));
        } else {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"  \u00bb ").method_10852((class_2561)class_2561.method_43471((String)configHolder.getAsHolder().getTranslationKey())).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10852(configHolder.getAsHolder().getValueAsComponent()));
        }
        ((class_2168)context.getSource()).method_45068((class_2561)ComponentUtils.separatorLine(null));
        return 1;
    }

    private static int resetAll(CommandContext<class_2168> context) {
        for (AtlasConfig config : AtlasConfig.configs.values()) {
            ConfigCommand.resetConfig(context, config);
        }
        return 1;
    }

    private static int resetConfig(CommandContext<class_2168> context, AtlasConfig config) {
        config.reset();
        for (class_3222 player : ((class_2168)context.getSource()).method_9211().method_3760().method_14571()) {
            if (!ServerPlayNetworking.canSend((class_3222)player, AtlasCore.AtlasConfigPacket.TYPE)) continue;
            player.field_13987.method_14364(ServerPlayNetworking.createS2CPacket((class_8710)new AtlasCore.AtlasConfigPacket(true, config)));
        }
        ((class_2168)context.getSource()).method_9226(() -> ComponentUtils.separatorLine(config.getFormattedName().method_27661(), true), true);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"  \u00bb ").method_10852((class_2561)class_2561.method_43469((String)"text.config.reset_config", (Object[])new Object[]{config.getFormattedName()})), true);
        ((class_2168)context.getSource()).method_9226(() -> ComponentUtils.separatorLine(null), true);
        return 1;
    }

    private static <T> int resetConfigValue(CommandContext<class_2168> context, AtlasConfig config, ConfigHolderLike<T> configHolder) {
        configHolder.resetValue();
        try {
            config.saveConfig();
        }
        catch (IOException e) {
            return 0;
        }
        for (class_3222 player : ((class_2168)context.getSource()).method_9211().method_3760().method_14571()) {
            if (!ServerPlayNetworking.canSend((class_3222)player, AtlasCore.AtlasConfigPacket.TYPE)) continue;
            player.field_13987.method_14364(ServerPlayNetworking.createS2CPacket((class_8710)new AtlasCore.AtlasConfigPacket(true, config)));
        }
        ((class_2168)context.getSource()).method_9226(() -> ComponentUtils.separatorLine(config.getFormattedName().method_27661(), true), true);
        if (!(configHolder instanceof AtlasConfig.ConfigHolder)) {
            if (configHolder.getAsHolder().restartRequired.restartRequiredOn(FabricLoader.getInstance().getEnvironmentType())) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"  \u00bb ").method_10852((class_2561)class_2561.method_43469((String)"text.config.holder_requires_restart", (Object[])new Object[]{((ExtendedHolder)((Object)configHolder.getAsHolder())).getInnerTranslation(configHolder.getName()), ((ExtendedHolder)((Object)configHolder.getAsHolder())).getInnerValue(configHolder.getName())})), true);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"  \u00bb ").method_10852((class_2561)class_2561.method_43469((String)"text.config.reset_holder", (Object[])new Object[]{((ExtendedHolder)((Object)configHolder.getAsHolder())).getInnerTranslation(configHolder.getName())})), true);
            }
            ((class_2168)context.getSource()).method_9226(() -> ComponentUtils.separatorLine(null), true);
            return 1;
        }
        if (configHolder.getAsHolder().restartRequired.restartRequiredOn(FabricLoader.getInstance().getEnvironmentType())) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"  \u00bb ").method_10852((class_2561)class_2561.method_43469((String)"text.config.holder_requires_restart", (Object[])new Object[]{class_2561.method_43471((String)configHolder.getAsHolder().getTranslationKey()), configHolder.getAsHolder().getValueAsComponent()})), true);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"  \u00bb ").method_10852((class_2561)class_2561.method_43469((String)"text.config.reset_holder", (Object[])new Object[]{class_2561.method_43471((String)configHolder.getAsHolder().getTranslationKey())})), true);
        }
        ((class_2168)context.getSource()).method_9226(() -> ComponentUtils.separatorLine(null), true);
        return 1;
    }

    private static <T> int updateConfigValue(CommandContext<class_2168> context, AtlasConfig config, ConfigHolderLike<T> configHolder) {
        if (configHolder instanceof ExtendedHolder) {
            ExtendedHolder extendedHolder = (ExtendedHolder)((Object)configHolder);
            if (extendedHolder.getUnsetInners().isEmpty()) {
                return extendedHolder.postUpdate((class_2168)context.getSource());
            }
            int ret = 1;
            for (ConfigHolderLike<?> inner : extendedHolder.getUnsetInners()) {
                ret &= ConfigCommand.updateConfigValue(context, config, inner);
            }
            return ret;
        }
        configHolder.setToParsedValue();
        try {
            config.saveConfig();
        }
        catch (IOException e) {
            return 0;
        }
        for (class_3222 player : ((class_2168)context.getSource()).method_9211().method_3760().method_14571()) {
            if (!ServerPlayNetworking.canSend((class_3222)player, AtlasCore.AtlasConfigPacket.TYPE)) continue;
            player.field_13987.method_14364(ServerPlayNetworking.createS2CPacket((class_8710)new AtlasCore.AtlasConfigPacket(true, config)));
        }
        ((class_2168)context.getSource()).method_9226(() -> ComponentUtils.separatorLine(config.getFormattedName().method_27661(), true), true);
        if (!(configHolder instanceof AtlasConfig.ConfigHolder)) {
            if (configHolder.getAsHolder().restartRequired.restartRequiredOn(FabricLoader.getInstance().getEnvironmentType())) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"  \u00bb ").method_10852((class_2561)class_2561.method_43469((String)"text.config.holder_requires_restart", (Object[])new Object[]{((ExtendedHolder)((Object)configHolder.getAsHolder())).getInnerTranslation(configHolder.getName()), ((ExtendedHolder)((Object)configHolder.getAsHolder())).getInnerValue(configHolder.getName())})), true);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"  \u00bb ").method_10852((class_2561)class_2561.method_43469((String)"text.config.update_holder", (Object[])new Object[]{((ExtendedHolder)((Object)configHolder.getAsHolder())).getInnerTranslation(configHolder.getName()), ((ExtendedHolder)((Object)configHolder.getAsHolder())).getInnerValue(configHolder.getName())})), true);
            }
        } else if (configHolder.getAsHolder().restartRequired.restartRequiredOn(FabricLoader.getInstance().getEnvironmentType())) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"  \u00bb ").method_10852((class_2561)class_2561.method_43469((String)"text.config.holder_requires_restart", (Object[])new Object[]{class_2561.method_43471((String)configHolder.getAsHolder().getTranslationKey()), configHolder.getAsHolder().getValueAsComponent()})), true);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"  \u00bb ").method_10852((class_2561)class_2561.method_43469((String)"text.config.update_holder", (Object[])new Object[]{class_2561.method_43471((String)configHolder.getAsHolder().getTranslationKey()), configHolder.getAsHolder().getValueAsComponent()})), true);
        }
        ((class_2168)context.getSource()).method_9226(() -> ComponentUtils.separatorLine(null), true);
        return 1;
    }

    private static void createConfigInformation(AtlasConfig config, Consumer<class_2561> sender) {
        List<AtlasConfig.ConfigHolder<?>> uncategorised;
        sender.accept((class_2561)ComponentUtils.separatorLine(config.getFormattedName().method_27661(), true));
        if (!config.categories.isEmpty()) {
            for (AtlasConfig.Category category : config.categories) {
                sender.accept((class_2561)ComponentUtils.separatorLine(class_2561.method_43471((String)category.translationKey())));
                for (AtlasConfig.ConfigHolder<?> configHolder : category.members()) {
                    if (configHolder instanceof ExtendedHolder) {
                        ExtendedHolder extendedHolder = (ExtendedHolder)((Object)configHolder);
                        sender.accept((class_2561)ComponentUtils.separatorLine(configHolder.getValueAsComponent().method_27661()));
                        extendedHolder.fulfilListing(component -> sender.accept((class_2561)class_2561.method_43470((String)"  \u00bb ").method_10852(component)));
                        sender.accept((class_2561)ComponentUtils.separatorLine(null));
                        continue;
                    }
                    sender.accept((class_2561)class_2561.method_43470((String)"  \u00bb ").method_10852((class_2561)class_2561.method_43471((String)configHolder.getTranslationKey())).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10852(configHolder.getValueAsComponent()));
                }
            }
        }
        if (!(uncategorised = config.getUncategorisedHolders()).isEmpty()) {
            if (!config.categories.isEmpty()) {
                sender.accept((class_2561)ComponentUtils.separatorLine(class_2561.method_43471((String)"text.config.misc_category")));
            }
            for (AtlasConfig.ConfigHolder<?> configHolder : config.getUncategorisedHolders()) {
                if (configHolder instanceof ExtendedHolder) {
                    ExtendedHolder extendedHolder = (ExtendedHolder)((Object)configHolder);
                    sender.accept((class_2561)ComponentUtils.separatorLine(configHolder.getValueAsComponent().method_27661()));
                    extendedHolder.fulfilListing(component -> sender.accept((class_2561)class_2561.method_43470((String)"  \u00bb ").method_10852(component)));
                    sender.accept((class_2561)ComponentUtils.separatorLine(null));
                    continue;
                }
                sender.accept((class_2561)class_2561.method_43470((String)"  \u00bb ").method_10852((class_2561)class_2561.method_43471((String)configHolder.getTranslationKey())).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10852(configHolder.getValueAsComponent()));
            }
        }
        sender.accept((class_2561)ComponentUtils.separatorLine(null));
    }

    private static int reloadAll(CommandContext<class_2168> context) {
        for (AtlasConfig config : AtlasConfig.configs.values()) {
            config.reload();
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.config.reload_all.success"), true);
        return 1;
    }

    private static int reload(CommandContext<class_2168> context, AtlasConfig config) {
        config.reload();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.config.reload.success"), true);
        return 1;
    }
}

