/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.command.argument;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.atlas.atlascore.config.AtlasConfig;
import net.atlas.atlascore.config.ContextBasedConfig;
import net.atlas.atlascore.util.Context;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7157;

public record AtlasConfigArgument(boolean requiresContext) implements ArgumentType<AtlasConfig>
{
    private static final Collection<String> EXAMPLES = List.of("foo:bar_config");

    public static AtlasConfigArgument context(boolean requiresContext) {
        return new AtlasConfigArgument(requiresContext);
    }

    public static AtlasConfig getConfig(CommandContext<?> context, String name) {
        AtlasConfig ret = (AtlasConfig)context.getArgument(name, AtlasConfig.class);
        if (ret instanceof ContextBasedConfig) {
            class_2168 sourceStack;
            ContextBasedConfig contextBasedConfig = (ContextBasedConfig)ret;
            Object object = context.getSource();
            if (object instanceof class_2168 && (sourceStack = (class_2168)object).method_9228() != null) {
                ret = contextBasedConfig.getConfig(Context.builder().applyInformationFromCommandSourceStack(sourceStack).build());
            } else {
                object = context.getSource();
                if (object instanceof class_2168) {
                    class_2168 sourceStack2 = (class_2168)object;
                    ret = contextBasedConfig.getConfig(Context.builder().putOnDedicated(sourceStack2.method_9211().method_3816()).build());
                }
            }
        }
        return ret;
    }

    public AtlasConfig parse(StringReader stringReader) throws CommandSyntaxException {
        class_2960 resourcelocation = class_2960.method_12835((StringReader)stringReader);
        if (this.requiresContext) {
            return AtlasConfig.configs.values().stream().filter(config -> config instanceof ContextBasedConfig && Objects.equals(config.name, resourcelocation)).findFirst().orElse(null);
        }
        return AtlasConfig.configs.get(resourcelocation);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        return class_2172.method_9257(AtlasConfig.configs.entrySet().stream().filter(entry -> ((AtlasConfig)entry.getValue()).configSide.isCommon() && (!this.requiresContext || entry.getValue() instanceof ContextBasedConfig)).map(Map.Entry::getKey), (SuggestionsBuilder)suggestionsBuilder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static class Info
    implements class_2314<AtlasConfigArgument, Template> {
        public void serializeToNetwork(Template template, class_2540 friendlyByteBuf) {
            friendlyByteBuf.method_52964(template.requiresContext);
        }

        public void serializeToJson(Template template, JsonObject jsonObject) {
            jsonObject.addProperty("requiresContext", Boolean.valueOf(template.requiresContext));
        }

        public Template deserializeFromNetwork(class_2540 friendlyByteBuf) {
            return new Template(friendlyByteBuf.readBoolean());
        }

        public Template unpack(AtlasConfigArgument argumentType) {
            return new Template(argumentType.requiresContext);
        }

        public final class Template
        implements class_2314.class_7217<AtlasConfigArgument> {
            private final boolean requiresContext;

            public Template(boolean requiresContext) {
                this.requiresContext = requiresContext;
            }

            public AtlasConfigArgument instantiate(class_7157 commandBuildContext) {
                return AtlasConfigArgument.context(this.requiresContext);
            }

            public class_2314<AtlasConfigArgument, ?> method_41728() {
                return Info.this;
            }
        }
    }
}

