/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.command.argument;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.atlas.atlascore.command.OptsArgumentUtils;
import net.atlas.atlascore.command.argument.AtlasConfigArgument;
import net.atlas.atlascore.command.argument.ExtendedArgumentType;
import net.atlas.atlascore.config.AtlasConfig;
import net.atlas.atlascore.config.ConfigHolderLike;
import net.atlas.atlascore.config.ExtendedHolder;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public record ConfigHolderArgument(String configArgument) implements ExtendedArgumentType<ConfigHolderLike<?>>
{
    public static final DynamicCommandExceptionType ERROR_MALFORMED_HOLDER = new DynamicCommandExceptionType(object -> class_2561.method_54159((String)"arguments.config.holder.malformed", (Object[])new Object[]{object}));
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_HOLDER = new DynamicCommandExceptionType(object -> class_2561.method_54159((String)"arguments.config.holder.unknown", (Object[])new Object[]{object}));
    private static final Collection<String> EXAMPLES = List.of("grayFormattingColour");

    public static ConfigHolderArgument configHolderArgument(String parentConfigArgument) {
        return new ConfigHolderArgument(parentConfigArgument);
    }

    public static ConfigHolderLike<?> getConfigHolder(CommandContext<?> context, String name) {
        return (ConfigHolderLike)context.getArgument(name, ConfigHolderLike.class);
    }

    public ConfigHolderLike<?> parse(StringReader stringReader) throws CommandSyntaxException {
        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().create();
    }

    public static String readHolderName(StringReader stringReader) {
        int i = stringReader.getCursor();
        while (stringReader.canRead() && stringReader.peek() != '=' && stringReader.peek() != '[' && stringReader.peek() != ']' && !Character.isWhitespace(stringReader.peek())) {
            stringReader.skip();
        }
        return stringReader.getString().substring(i, stringReader.getCursor());
    }

    @Override
    public <S> ConfigHolderLike<?> parse(StringReader reader, CommandContext<S> commandContext) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String configHolderName = ConfigHolderArgument.readHolderName(reader);
        AtlasConfig.ConfigHolder<?> configHolder = AtlasConfigArgument.getConfig(commandContext, (String)this.configArgument).valueNameToConfigHolderMap.get(configHolderName);
        if (configHolder == null) {
            reader.setCursor(cursor);
            throw ERROR_UNKNOWN_HOLDER.createWithContext((ImmutableStringReader)reader, (Object)configHolderName);
        }
        ConfigHolderLike<?> inner = null;
        ConfigHolderLike<?> baseHolder = configHolder;
        try {
            int unresolvedInners = 0;
            boolean isExtended = configHolder instanceof ExtendedHolder;
            while (isExtended && reader.canRead() && reader.peek() == '[') {
                reader.skip();
                inner = ((ExtendedHolder)((Object)baseHolder)).findInner(reader);
                baseHolder = inner;
                isExtended = baseHolder instanceof ExtendedHolder;
                ++unresolvedInners;
                if (isExtended) continue;
                while (unresolvedInners > 0) {
                    reader.expect(']');
                    --unresolvedInners;
                }
            }
        }
        catch (CommandSyntaxException e) {
            reader.setCursor(cursor);
            throw e;
        }
        return inner == null ? configHolder : inner;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        SuggestionsVisitor visitor = new SuggestionsVisitor();
        visitor.visitSuggestions(suggestionsBuilder -> class_2172.method_9265(AtlasConfigArgument.getConfig(commandContext, (String)this.configArgument).valueNameToConfigHolderMap.keySet(), (SuggestionsBuilder)builder));
        try {
            this.parseHolder(visitor, reader, AtlasConfigArgument.getConfig(commandContext, this.configArgument));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return visitor.resolveSuggestions(builder, reader);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private void parseHolder(SuggestionsVisitor visitor, StringReader reader, AtlasConfig atlasConfig) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        Map<String, AtlasConfig.ConfigHolder<?>> valueNameToConfigHolderMap = atlasConfig.valueNameToConfigHolderMap;
        String currentHolderName = ConfigHolderArgument.readHolderName(reader);
        if (!valueNameToConfigHolderMap.containsKey(currentHolderName)) {
            reader.setCursor(cursor);
            throw ERROR_UNKNOWN_HOLDER.createWithContext((ImmutableStringReader)reader, (Object)currentHolderName);
        }
        ConfigHolderLike<?> configHolderLike = (ConfigHolderLike<?>)valueNameToConfigHolderMap.get(currentHolderName);
        boolean isExtended = configHolderLike instanceof ExtendedHolder;
        if (isExtended) {
            visitor.visitSuggestions(this::suggestStartInner);
            int unresolvedInners = 0;
            while (isExtended) {
                ConfigHolderLike<?> temp;
                if (reader.canRead() && reader.peek() == ']') {
                    do {
                        reader.skip();
                    } while (--unresolvedInners > 0);
                    break;
                }
                reader.expect('[');
                ExtendedHolder extendedHolder = (ExtendedHolder)((Object)configHolderLike);
                visitor.visitSuggestions(suggestionsBuilder -> extendedHolder.suggestInner(reader, (SuggestionsBuilder)suggestionsBuilder));
                cursor = reader.getCursor();
                currentHolderName = ConfigHolderArgument.readHolderName(reader);
                ConfigHolderLike<?> configHolderLike2 = temp = extendedHolder.retrieveInner(currentHolderName);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExtendedHolder.class}, configHolderLike2, n)) {
                    case 0: {
                        ExtendedHolder ignored = (ExtendedHolder)((Object)configHolderLike2);
                        configHolderLike = temp;
                        visitor.visitSuggestions(this::suggestStartInceptionOrEnd);
                        break;
                    }
                    case -1: {
                        reader.setCursor(cursor);
                        throw ERROR_UNKNOWN_HOLDER.createWithContext((ImmutableStringReader)reader, (Object)currentHolderName);
                    }
                    default: {
                        visitor.visitSuggestions(OptsArgumentUtils.SUGGEST_NOTHING);
                        isExtended = false;
                    }
                }
                ++unresolvedInners;
                if (isExtended) continue;
                do {
                    if (!reader.canRead() || reader.peek() != ']') {
                        visitor.visitSuggestions(this::suggestEnd);
                    }
                    reader.expect(']');
                } while (--unresolvedInners > 0);
            }
        }
    }

    private CompletableFuture<Suggestions> suggestStartInner(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf('['));
        }
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestStartInceptionOrEnd(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf('['));
            suggestionsBuilder.suggest(String.valueOf(']'));
        }
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestEnd(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf(']'));
        }
        return suggestionsBuilder.buildFuture();
    }

    static class SuggestionsVisitor {
        private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions = OptsArgumentUtils.SUGGEST_NOTHING;

        SuggestionsVisitor() {
        }

        public void visitSuggestions(Function<SuggestionsBuilder, CompletableFuture<Suggestions>> function) {
            this.suggestions = function;
        }

        public CompletableFuture<Suggestions> resolveSuggestions(SuggestionsBuilder suggestionsBuilder, StringReader stringReader) {
            return this.suggestions.apply(suggestionsBuilder.createOffset(stringReader.getCursor()));
        }
    }

    public record ConfigValueArgument(String holderArgument) implements ExtendedArgumentType<Object>
    {
        private static final Collection<String> EXAMPLES = Arrays.asList("1", "2.03", "foo", "string", "true", "#FFFFFF");

        public static ConfigValueArgument configValueArgument(String parentHolderArgument) {
            return new ConfigValueArgument(parentHolderArgument);
        }

        public Object parse(StringReader stringReader) throws CommandSyntaxException {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().create();
        }

        @Override
        public <S> Object parse(StringReader reader, S source, CommandContext<S> commandContext) throws CommandSyntaxException {
            return ConfigHolderArgument.getConfigHolder(commandContext, this.holderArgument).parse(reader, source, commandContext);
        }

        @Override
        public <S> Object parse(StringReader reader, CommandContext<S> commandContext) throws CommandSyntaxException {
            return this.parse(reader, commandContext.getSource(), commandContext);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
            return ConfigHolderArgument.getConfigHolder(commandContext, this.holderArgument).buildSuggestions(commandContext, suggestionsBuilder);
        }

        public Collection<String> getExamples() {
            return EXAMPLES;
        }

        public static class ValueInfo
        implements class_2314<ConfigValueArgument, Template> {
            public void serializeToNetwork(Template template, class_2540 friendlyByteBuf) {
                friendlyByteBuf.method_10814(template.holderArgument);
            }

            public void serializeToJson(Template template, JsonObject jsonObject) {
                jsonObject.addProperty("holderArgument", template.holderArgument);
            }

            public Template deserializeFromNetwork(class_2540 friendlyByteBuf) {
                return new Template(friendlyByteBuf.method_19772());
            }

            public Template unpack(ConfigValueArgument argumentType) {
                return new Template(argumentType.holderArgument);
            }

            public final class Template
            implements class_2314.class_7217<ConfigValueArgument> {
                private final String holderArgument;

                public Template(String holderArgument) {
                    this.holderArgument = holderArgument;
                }

                public ConfigValueArgument instantiate(class_7157 commandBuildContext) {
                    return ConfigValueArgument.configValueArgument(this.holderArgument);
                }

                public class_2314<ConfigValueArgument, ?> method_41728() {
                    return ValueInfo.this;
                }
            }
        }
    }

    public static class HolderInfo
    implements class_2314<ConfigHolderArgument, Template> {
        public void serializeToNetwork(Template template, class_2540 friendlyByteBuf) {
            friendlyByteBuf.method_10814(template.configArgument);
        }

        public void serializeToJson(Template template, JsonObject jsonObject) {
            jsonObject.addProperty("configArgument", template.configArgument);
        }

        public Template deserializeFromNetwork(class_2540 friendlyByteBuf) {
            return new Template(friendlyByteBuf.method_19772());
        }

        public Template unpack(ConfigHolderArgument argumentType) {
            return new Template(argumentType.configArgument);
        }

        public final class Template
        implements class_2314.class_7217<ConfigHolderArgument> {
            private final String configArgument;

            public Template(String configArgument) {
                this.configArgument = configArgument;
            }

            public ConfigHolderArgument instantiate(class_7157 commandBuildContext) {
                return ConfigHolderArgument.configHolderArgument(this.configArgument);
            }

            public class_2314<ConfigHolderArgument, ?> method_41728() {
                return HolderInfo.this;
            }
        }
    }
}

