/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.config;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.reflect.Field;
import java.util.concurrent.CompletableFuture;
import net.atlas.atlascore.command.argument.ExtendedArgumentType;
import net.atlas.atlascore.config.AtlasConfig;
import net.atlas.atlascore.config.ConfigHolderLike;

public class FieldHolder
implements ConfigHolderLike<Object> {
    public final AtlasConfig.ConfigHolder<?> owner;
    private final Field field;
    private final ArgumentType<?> type;
    private final Object defaultValue;
    private final String name;
    public Object parsedValue;

    public FieldHolder(AtlasConfig.ConfigHolder<?> owner, Field field, ArgumentType<?> type, Object defaultValue, String name) {
        this.owner = owner;
        this.field = field;
        this.type = type;
        this.defaultValue = defaultValue;
        this.name = name;
    }

    @Override
    public void setToParsedValue() {
        if (this.parsedValue == null) {
            return;
        }
        this.setValue(this.parsedValue);
        this.parsedValue = null;
    }

    @Override
    public AtlasConfig.ConfigHolder<Object> getAsHolder() {
        return this.owner;
    }

    @Override
    public Object get() {
        try {
            return this.field.get(this.owner.get());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setValue(Object newValue) {
        try {
            Object o = this.owner.get();
            this.field.set(o, newValue);
            this.owner.setValueAmbiguousType(o);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void resetValue() {
        this.setValue(this.defaultValue);
    }

    @Override
    public <S> Object parse(StringReader reader, S source, CommandContext<S> commandContext) throws CommandSyntaxException {
        Object ret;
        ArgumentType<?> argumentType = this.type;
        if (argumentType instanceof ExtendedArgumentType) {
            ExtendedArgumentType extendedArgumentType = (ExtendedArgumentType)argumentType;
            ret = extendedArgumentType.parse(reader, commandContext);
        } else {
            ret = this.type.parse(reader);
        }
        this.parsedValue = ret;
        return ret;
    }

    @Override
    public <S> CompletableFuture<Suggestions> buildSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        return this.type.listSuggestions(commandContext, suggestionsBuilder);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasParsedValue() {
        return this.parsedValue != null;
    }
}

