/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.command.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.atlas.atlascore.command.OptsArgumentUtils;
import net.atlas.atlascore.command.argument.AtlasConfigArgument;
import net.atlas.atlascore.config.AtlasConfig;
import net.atlas.atlascore.config.ConfigHolderLike;
import net.atlas.atlascore.config.ExtendedHolder;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public record ConfigHolderArgument(String configArgument) {
    public static final DynamicCommandExceptionType ERROR_MALFORMED_HOLDER = new DynamicCommandExceptionType(object -> class_2561.method_54159((String)"arguments.config.holder.malformed", (Object[])new Object[]{object}));
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_HOLDER = new DynamicCommandExceptionType(object -> class_2561.method_54159((String)"arguments.config.holder.unknown", (Object[])new Object[]{object}));

    public static StringArgumentType configHolderArgument() {
        return StringArgumentType.word();
    }

    public static ConfigHolderLike<?> getConfigHolder(CommandContext<?> context, String name, String configArgument) throws CommandSyntaxException {
        StringReader reader = new StringReader((String)context.getArgument(name, String.class));
        int cursor = reader.getCursor();
        String configHolderName = ConfigHolderArgument.readHolderName(reader);
        AtlasConfig.ConfigHolder<?> configHolder = AtlasConfigArgument.getConfig(context, (String)configArgument, (boolean)false).valueNameToConfigHolderMap.get(configHolderName);
        if (configHolder == null) {
            reader.setCursor(cursor);
            throw ERROR_UNKNOWN_HOLDER.createWithContext((ImmutableStringReader)reader, (Object)configHolderName);
        }
        ConfigHolderLike<?> inner = null;
        ConfigHolderLike<?> baseHolder = configHolder;
        try {
            boolean isExtended = configHolder instanceof ExtendedHolder;
            while (isExtended && reader.canRead() && reader.peek() == '.') {
                reader.skip();
                inner = ((ExtendedHolder)((Object)baseHolder)).findInner(reader);
                baseHolder = inner;
                isExtended = baseHolder instanceof ExtendedHolder;
            }
        }
        catch (CommandSyntaxException e) {
            reader.setCursor(cursor);
            throw e;
        }
        return inner == null ? configHolder : inner;
    }

    public static String readHolderName(StringReader stringReader) {
        int i = stringReader.getCursor();
        while (stringReader.canRead() && stringReader.peek() != '=' && stringReader.peek() != '.' && !Character.isWhitespace(stringReader.peek())) {
            stringReader.skip();
        }
        return stringReader.getString().substring(i, stringReader.getCursor());
    }

    public static <S> CompletableFuture<Suggestions> suggestions(CommandContext<S> commandContext, SuggestionsBuilder builder, String configArgument) {
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        SuggestionsVisitor visitor = new SuggestionsVisitor();
        visitor.visitSuggestions(suggestionsBuilder -> class_2172.method_9265(AtlasConfigArgument.getConfig(commandContext, (String)configArgument, (boolean)false).valueNameToConfigHolderMap.keySet(), (SuggestionsBuilder)builder));
        try {
            ConfigHolderArgument.parseHolder(visitor, reader, AtlasConfigArgument.getConfig(commandContext, configArgument, false));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return visitor.resolveSuggestions(builder, reader);
    }

    private static void parseHolder(SuggestionsVisitor visitor, StringReader reader, AtlasConfig atlasConfig) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        Map<String, AtlasConfig.ConfigHolder<?>> valueNameToConfigHolderMap = atlasConfig.valueNameToConfigHolderMap;
        String currentHolderName = ConfigHolderArgument.readHolderName(reader);
        if (!valueNameToConfigHolderMap.containsKey(currentHolderName)) {
            reader.setCursor(cursor);
            throw ERROR_UNKNOWN_HOLDER.createWithContext((ImmutableStringReader)reader, (Object)currentHolderName);
        }
        ConfigHolderLike<?> configHolderLike = (ConfigHolderLike<?>)valueNameToConfigHolderMap.get(currentHolderName);
        boolean isExtended = configHolderLike instanceof ExtendedHolder;
        if (isExtended) {
            visitor.visitSuggestions(ConfigHolderArgument::suggestStartInner);
            block4: while (isExtended) {
                ConfigHolderLike<?> temp;
                reader.expect('.');
                ExtendedHolder extendedHolder = (ExtendedHolder)((Object)configHolderLike);
                visitor.visitSuggestions(suggestionsBuilder -> extendedHolder.suggestInner(reader, (SuggestionsBuilder)suggestionsBuilder));
                cursor = reader.getCursor();
                currentHolderName = ConfigHolderArgument.readHolderName(reader);
                ConfigHolderLike<?> configHolderLike2 = temp = extendedHolder.retrieveInner(currentHolderName);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExtendedHolder.class}, configHolderLike2, n)) {
                    case 0: {
                        ExtendedHolder ignored = (ExtendedHolder)((Object)configHolderLike2);
                        configHolderLike = temp;
                        visitor.visitSuggestions(ConfigHolderArgument::suggestStartInner);
                        continue block4;
                    }
                    case -1: {
                        reader.setCursor(cursor);
                        throw ERROR_UNKNOWN_HOLDER.createWithContext((ImmutableStringReader)reader, (Object)currentHolderName);
                    }
                }
                visitor.visitSuggestions(OptsArgumentUtils.SUGGEST_NOTHING);
                isExtended = false;
            }
        }
    }

    private static CompletableFuture<Suggestions> suggestStartInner(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf('.'));
        }
        return suggestionsBuilder.buildFuture();
    }

    static class SuggestionsVisitor {
        private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions = OptsArgumentUtils.SUGGEST_NOTHING;

        SuggestionsVisitor() {
        }

        public void visitSuggestions(Function<SuggestionsBuilder, CompletableFuture<Suggestions>> function) {
            this.suggestions = function;
        }

        public CompletableFuture<Suggestions> resolveSuggestions(SuggestionsBuilder suggestionsBuilder, StringReader stringReader) {
            return this.suggestions.apply(suggestionsBuilder.createOffset(stringReader.getCursor()));
        }
    }

    public record ConfigValueArgument() {
        public static <S> void readArgument(CommandContext<S> commandContext, String name, ConfigHolderLike<?> holder) throws CommandSyntaxException {
            StringReader reader = new StringReader((String)commandContext.getArgument(name, String.class));
            holder.parse(reader, commandContext.getSource(), commandContext);
        }

        public static <S> CompletableFuture<Suggestions> suggestions(CommandContext<S> commandContext, SuggestionsBuilder builder, String holderArgument, String configArgument) throws CommandSyntaxException {
            StringReader reader = new StringReader(builder.getInput());
            SuggestionsVisitor suggestionsVisitor = new SuggestionsVisitor();
            reader.setCursor(builder.getStart());
            try {
                int cursor = reader.getCursor();
                ConfigHolderLike<?> configHolder = ConfigHolderArgument.getConfigHolder(commandContext, holderArgument, configArgument);
                suggestionsVisitor.visitSuggestions(builder1 -> configHolder.buildSuggestions(commandContext, builder1.createOffset(cursor)));
                configHolder.verifySuggestionsArePresent(commandContext, reader);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return suggestionsVisitor.resolveSuggestions(builder, reader);
        }
    }
}

