/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.config;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.ColorEntry;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerSliderEntry;
import me.shedaniel.clothconfig2.gui.entries.MultiElementListEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListEntry;
import net.atlas.atlascore.AtlasCore;
import net.atlas.atlascore.client.gui.CodecBackedListEntry;
import net.atlas.atlascore.command.OptsArgumentUtils;
import net.atlas.atlascore.command.argument.ConfigHolderArgument;
import net.atlas.atlascore.config.ConfigHolderLike;
import net.atlas.atlascore.config.ExtendedHolder;
import net.atlas.atlascore.config.FieldHolder;
import net.atlas.atlascore.util.Codecs;
import net.atlas.atlascore.util.ComponentUtils;
import net.atlas.atlascore.util.ConfigRepresentable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5699;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class AtlasConfig {
    public final class_2960 name;
    public final SyncMode defaultSyncMode;
    public final ConfigSide configSide;
    public boolean isDefault;
    public final Map<String, ConfigHolder<?>> valueNameToConfigHolderMap = Maps.newHashMap();
    public final List<Category> categories;
    public static final Map<class_2960, AtlasConfig> configs = Maps.newHashMap();
    public static final Map<String, AtlasConfig> menus = Maps.newHashMap();
    File configFile;
    JsonObject configJsonObject;
    List<ConfigHolder<?>> configHolders;

    public AtlasConfig(class_2960 name, SyncMode defaultSyncMode, ConfigSide configSide) {
        this.configSide = configSide;
        this.defaultSyncMode = defaultSyncMode;
        this.name = name;
        this.configHolders = new ArrayList();
        this.categories = this.createCategories();
        this.configFile = null;
        this.configJsonObject = null;
        this.defineConfigHolders();
        if (!Files.exists(this.getConfigFolderPath(), new LinkOption[0])) {
            try {
                Files.createDirectories(this.getConfigFolderPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new class_148(new class_128("Failed to create config directory for config " + String.valueOf(name), (Throwable)e));
            }
        }
        this.load();
        if (!configs.containsKey(name)) {
            configs.put(name, this);
        }
    }

    public AtlasConfig(class_2960 name, SyncMode defaultSyncMode) {
        this(name, defaultSyncMode, ConfigSide.COMMON);
    }

    public AtlasConfig(class_2960 name, ConfigSide configSide) {
        this(name, SyncMode.OVERRIDE_CLIENT, configSide);
    }

    public AtlasConfig(class_2960 name) {
        this(name, SyncMode.OVERRIDE_CLIENT, ConfigSide.COMMON);
    }

    public class_2561 getFormattedName() {
        return class_2561.method_48321((String)("text.config." + this.name.method_12832() + ".title"), (String)"Atlas Config");
    }

    public AtlasConfig declareDefaultForMod(String modID) {
        menus.put(modID, this);
        return this;
    }

    public List<ConfigHolder<?>> getAllHolders() {
        return this.configHolders;
    }

    public List<ConfigHolder<?>> getUncategorisedHolders() {
        if (this.categories.isEmpty()) {
            return this.configHolders;
        }
        return this.configHolders.stream().filter(configHolder -> {
            AtomicBoolean atomic = new AtomicBoolean(true);
            this.categories.forEach(category -> atomic.set(atomic.get() & !category.members.contains(configHolder)));
            return atomic.get();
        }).toList();
    }

    @NotNull
    public List<Category> createCategories() {
        return new ArrayList<Category>();
    }

    public abstract void defineConfigHolders();

    public abstract void resetExtraHolders();

    public abstract <T> void alertChange(ConfigValue<T> var1, T var2);

    public abstract <T> void alertClientValue(ConfigValue<T> var1, T var2, T var3);

    public static Integer getColor(String hex, Integer otherwise, boolean hasAlpha) {
        String color = AtlasConfig.stripHexStarter(hex);
        if (color.length() > 8) {
            return otherwise;
        }
        if (!hasAlpha && color.length() > 6) {
            return otherwise;
        }
        return (int)Long.parseLong(color, 16);
    }

    public static String stripHexStarter(String hex) {
        return hex.startsWith("#") ? hex.substring(1) : hex;
    }

    @ApiStatus.Internal
    protected Path getConfigFolderPath() {
        return Path.of(String.valueOf(FabricLoader.getInstance().getConfigDir().getFileName().getFileName()) + "/" + this.name.method_12836() + this.configSide.getAsDir(), new String[0]);
    }

    public void reload() {
        this.resetExtraHolders();
        this.load();
    }

    @ApiStatus.Internal
    protected void load() {
        this.isDefault = false;
        if (this.configFile == null) {
            this.configFile = new File(String.valueOf(this.getConfigFolderPath().toAbsolutePath()) + "/" + this.name.method_12832() + ".json");
        }
        if (!this.configFile.exists()) {
            try {
                this.configFile.createNewFile();
                this.saveConfig();
            }
            catch (IOException e) {
                throw new class_148(new class_128("Failed to create config file for config " + String.valueOf(this.name), (Throwable)e));
            }
        }
        try {
            if (this.configJsonObject == null) {
                this.configJsonObject = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new FileReader(this.configFile))).getAsJsonObject();
            }
            for (Category category : this.categories) {
                JsonObject categoryRoot = new JsonObject();
                if (this.configJsonObject.has(category.name)) {
                    categoryRoot = this.configJsonObject.getAsJsonObject(category.name);
                }
                for (ConfigHolder<?> holder : category.members) {
                    if (!categoryRoot.has(holder.heldValue.name)) continue;
                    holder.loadFromJSONAndResetManaged(categoryRoot);
                }
            }
            for (ConfigHolder configHolder : this.valueNameToConfigHolderMap.values()) {
                if (!this.configJsonObject.has(configHolder.heldValue.name)) continue;
                configHolder.loadFromJSONAndResetManaged(this.configJsonObject);
            }
            this.loadExtra(this.configJsonObject);
        }
        catch (IOException | IllegalStateException e) {
            AtlasCore.LOGGER.error("Failed to load config from file!", e);
        }
    }

    protected abstract void loadExtra(JsonObject var1);

    @Deprecated(forRemoval=true)
    protected InputStream getDefaultedConfig() {
        return null;
    }

    public AtlasConfig loadFromNetwork(class_9129 buf) {
        this.configHolders.forEach(configHolder -> configHolder.readFromBuf(buf));
        return this;
    }

    public static AtlasConfig staticLoadFromNetwork(class_9129 buf) {
        return configs.get(buf.method_10810()).loadFromNetwork(buf);
    }

    public static AtlasConfig staticReadClientConfigInformation(class_9129 buf) {
        return configs.get(buf.method_10810()).readClientConfigInformation(buf);
    }

    public AtlasConfig readClientConfigInformation(class_9129 buf) {
        this.configHolders.forEach(configHolder -> configHolder.broadcastClientValueRecieved(buf));
        return this;
    }

    public void saveToNetwork(class_9129 buf) {
        this.configHolders.forEach(configHolder -> configHolder.writeToBuf(buf));
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public ConfigHolder<?> fromValue(ConfigValue<?> value) {
        return this.valueNameToConfigHolderMap.get(value.name);
    }

    public <T> TagHolder<T> createCodecBacked(String name, T defaultVal, Codec<T> codec) {
        return this.createCodecBacked(name, defaultVal, codec, this.defaultSyncMode);
    }

    public <T> TagHolder<T> createCodecBacked(String name, T defaultVal, Codec<T> codec, SyncMode syncMode) {
        TagHolder<T> tagHolder = new TagHolder<T>(new ConfigValue<T>(defaultVal, null, false, name, this, syncMode), codec);
        this.configHolders.add(tagHolder);
        return tagHolder;
    }

    public <T extends ConfigRepresentable> ObjectHolder<T> createObject(String name, T defaultInstance, Class<T> clazz, class_9139<class_9129, T> streamCodec) {
        return this.createObject(name, defaultInstance, clazz, streamCodec, true, this.defaultSyncMode);
    }

    public <T extends ConfigRepresentable> ObjectHolder<T> createObject(String name, T defaultInstance, Class<T> clazz, class_9139<class_9129, T> streamCodec, boolean expandByDefault) {
        return this.createObject(name, defaultInstance, clazz, streamCodec, expandByDefault, this.defaultSyncMode);
    }

    public <T extends ConfigRepresentable> ObjectHolder<T> createObject(String name, T defaultInstance, Class<T> clazz, class_9139<class_9129, T> streamCodec, SyncMode syncMode) {
        return this.createObject(name, defaultInstance, clazz, streamCodec, true, syncMode);
    }

    public <T extends ConfigRepresentable> ObjectHolder<T> createObject(String name, T defaultInstance, Class<T> clazz, class_9139<class_9129, T> streamCodec, boolean expandByDefault, SyncMode syncMode) {
        ObjectHolder<T> objectHolder = new ObjectHolder<T>(new ConfigValue<T>(defaultInstance, null, false, name, this, syncMode), clazz, streamCodec, expandByDefault);
        this.configHolders.add(objectHolder);
        return objectHolder;
    }

    public final <E extends Enum<E>> EnumHolder<E> createEnum(String name, E defaultVal, Class<E> clazz, E[] values, Function<Enum, class_2561> names) {
        return this.createEnum(name, defaultVal, clazz, (Enum[])values, names, this.defaultSyncMode);
    }

    public final <E extends Enum<E>> EnumHolder<E> createEnum(String name, E defaultVal, Class<E> clazz, E[] values, Function<Enum, class_2561> names, SyncMode syncMode) {
        EnumHolder<E> enumHolder = new EnumHolder<E>(new ConfigValue<E>(defaultVal, values, false, name, this, syncMode), clazz, names);
        this.configHolders.add(enumHolder);
        return enumHolder;
    }

    public StringHolder createStringRange(String name, String defaultVal, String ... values) {
        return this.createStringRange(name, defaultVal, this.defaultSyncMode, values);
    }

    public StringHolder createStringRange(String name, String defaultVal, SyncMode syncMode, String ... values) {
        StringHolder stringHolder = new StringHolder(new ConfigValue<String>(defaultVal, values, false, name, this, syncMode));
        this.configHolders.add(stringHolder);
        return stringHolder;
    }

    public StringHolder createString(String name, String defaultVal) {
        return this.createString(name, defaultVal, this.defaultSyncMode);
    }

    public StringHolder createString(String name, String defaultVal, SyncMode syncMode) {
        StringHolder stringHolder = new StringHolder(new ConfigValue<String>(defaultVal, null, false, name, this, syncMode));
        this.configHolders.add(stringHolder);
        return stringHolder;
    }

    public BooleanHolder createBoolean(String name, boolean defaultVal) {
        return this.createBoolean(name, defaultVal, this.defaultSyncMode);
    }

    public BooleanHolder createBoolean(String name, boolean defaultVal, SyncMode syncMode) {
        BooleanHolder booleanHolder = new BooleanHolder(new ConfigValue<Boolean>(defaultVal, new Boolean[]{false, true}, false, name, this, syncMode));
        this.configHolders.add(booleanHolder);
        return booleanHolder;
    }

    public ColorHolder createColor(String name, Integer defaultVal, boolean alpha) {
        return this.createColor(name, defaultVal, alpha, this.defaultSyncMode);
    }

    public ColorHolder createColor(String name, Integer defaultVal, boolean alpha, SyncMode syncMode) {
        ColorHolder colorHolder = new ColorHolder(new ConfigValue<Integer>(defaultVal, null, false, name, this, this.defaultSyncMode), alpha);
        this.configHolders.add(colorHolder);
        return colorHolder;
    }

    public IntegerHolder createIntegerUnbound(String name, Integer defaultVal) {
        return this.createInteger(name, defaultVal, null, false, false, this.defaultSyncMode);
    }

    public IntegerHolder createIntegerUnbound(String name, Integer defaultVal, SyncMode syncMode) {
        return this.createInteger(name, defaultVal, null, false, false, syncMode);
    }

    public IntegerHolder createInRestrictedValues(String name, Integer defaultVal, Integer ... values) {
        return this.createInteger(name, defaultVal, values, false, false, this.defaultSyncMode);
    }

    public IntegerHolder createInRestrictedValues(String name, Integer defaultVal, SyncMode syncMode, Integer ... values) {
        return this.createInteger(name, defaultVal, values, false, false, syncMode);
    }

    public IntegerHolder createInRange(String name, int defaultVal, int min, int max, boolean isSlider) {
        return this.createInRange(name, defaultVal, min, max, isSlider, this.defaultSyncMode);
    }

    public IntegerHolder createInRange(String name, int defaultVal, int min, int max, boolean isSlider, SyncMode syncMode) {
        Integer[] range = new Integer[]{min, max};
        return this.createInteger(name, defaultVal, range, true, isSlider, syncMode);
    }

    public IntegerHolder createInteger(String name, Integer defaultVal, Integer[] values, boolean isRange, boolean isSlider, SyncMode syncMode) {
        IntegerHolder integerHolder = new IntegerHolder(new ConfigValue<Integer>(defaultVal, values, isRange, name, this, syncMode), isSlider);
        this.configHolders.add(integerHolder);
        return integerHolder;
    }

    public DoubleHolder createDoubleUnbound(String name, Double defaultVal) {
        return this.createDouble(name, defaultVal, null, false, this.defaultSyncMode);
    }

    public DoubleHolder createDoubleUnbound(String name, Double defaultVal, SyncMode syncMode) {
        return this.createDouble(name, defaultVal, null, false, syncMode);
    }

    public DoubleHolder createInRestrictedValues(String name, Double defaultVal, Double ... values) {
        return this.createDouble(name, defaultVal, values, false, this.defaultSyncMode);
    }

    public DoubleHolder createInRestrictedValues(String name, Double defaultVal, SyncMode syncMode, Double ... values) {
        return this.createDouble(name, defaultVal, values, false, syncMode);
    }

    public DoubleHolder createInRange(String name, double defaultVal, double min, double max) {
        return this.createInRange(name, defaultVal, min, max, this.defaultSyncMode);
    }

    public DoubleHolder createInRange(String name, double defaultVal, double min, double max, SyncMode syncMode) {
        Double[] range = new Double[]{min, max};
        return this.createDouble(name, defaultVal, range, true, syncMode);
    }

    public DoubleHolder createDouble(String name, Double defaultVal, Double[] values, boolean isRange, SyncMode syncMode) {
        DoubleHolder doubleHolder = new DoubleHolder(new ConfigValue<Double>(defaultVal, values, isRange, name, this, syncMode));
        this.configHolders.add(doubleHolder);
        return doubleHolder;
    }

    public final void saveConfig() throws IOException {
        PrintWriter printWriter = new PrintWriter(this.configFile);
        JsonObject root = new JsonObject();
        root = this.saveExtra((JsonElement)root).getAsJsonObject();
        if (!this.categories.isEmpty()) {
            for (Category category : this.categories) {
                JsonObject categoryRoot = new JsonObject();
                for (ConfigHolder<?> holder : category.members) {
                    categoryRoot = ((JsonElement)holder.encodeAsJSON(categoryRoot).getOrThrow()).getAsJsonObject();
                }
                root.add(category.name, (JsonElement)categoryRoot);
            }
        }
        for (ConfigHolder configHolder : this.getUncategorisedHolders()) {
            root = ((JsonElement)configHolder.encodeAsJSON(root).getOrThrow()).getAsJsonObject();
        }
        AtlasCore.GSON.toJson((JsonElement)root, (Appendable)printWriter);
        printWriter.close();
    }

    public JsonElement saveExtra(JsonElement root) {
        return root;
    }

    public void reset() {
        try {
            this.resetExtraHolders();
            this.valueNameToConfigHolderMap.values().forEach(ConfigHolder::resetToDefaultAndResetManaged);
            this.saveConfig();
        }
        catch (IOException e) {
            throw new class_148(new class_128("Failed to recreate config file for config " + String.valueOf(this.name), (Throwable)e));
        }
        this.reload();
    }

    public void reloadFromDefault() {
        this.isDefault = true;
        this.resetExtraHolders();
        this.valueNameToConfigHolderMap.values().forEach(ConfigHolder::resetToDefaultAndSetSynchedValue);
    }

    @Environment(value=EnvType.CLIENT)
    public static void handleExtraSyncStatic(AtlasCore.AtlasConfigPacket packet, ClientPlayNetworking.Context context) {
        AtlasConfig config = packet.config();
        if (!packet.forCommand()) {
            class_5250 disconnectReason = class_2561.method_43471((String)"text.config.mismatch");
            AtomicBoolean isMismatched = new AtomicBoolean(false);
            ClientPlayNetworking.send((class_8710)new AtlasCore.ClientInformPacket(config));
            ArrayList restartRequiredHolders = new ArrayList();
            config.valueNameToConfigHolderMap.values().forEach(configHolder -> {
                if (configHolder.restartRequired.restartRequiredOn(EnvType.CLIENT) && configHolder.wasUpdated()) {
                    restartRequiredHolders.add(configHolder);
                }
            });
            if (!restartRequiredHolders.isEmpty()) {
                isMismatched.set(true);
                restartRequiredHolders.forEach(ConfigHolder::setToSynchedValue);
                try {
                    config.saveConfig();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                Consumer<class_5250> appender = component -> disconnectReason.method_10852((class_2561)component.method_27696(component.method_10866().method_36140(Boolean.valueOf(false))));
                Consumer<class_5250> appenderWithLineBreak = component -> disconnectReason.method_10852((class_2561)component.method_10852((class_2561)class_2561.method_43470((String)"\n")).method_27696(component.method_10866().method_36140(Boolean.valueOf(false))));
                appenderWithLineBreak.accept(ComponentUtils.separatorLine(config.getFormattedName().method_27661(), true));
                Consumer<ConfigHolder> lister = configHolder -> {
                    appender.accept(class_2561.method_43470((String)"  \u00bb ").method_10852((class_2561)class_2561.method_43469((String)"text.config.holder.sync_mismatch", (Object[])new Object[]{class_2561.method_43471((String)configHolder.getTranslationKey()).method_27692(class_124.field_1054)})));
                    if (configHolder instanceof ExtendedHolder) {
                        ExtendedHolder extendedHolder = (ExtendedHolder)((Object)configHolder);
                        AtomicReference<class_5250> entries = new AtomicReference<class_5250>(class_2561.method_43470((String)"\n"));
                        appender.accept(entries.get());
                        configHolder.setToPreviousValue();
                        extendedHolder.fulfilListing(component -> entries.set(((class_5250)entries.get()).method_10852((class_2561)class_2561.method_43470((String)"    \u00bb | ").method_10852(component).method_10852((class_2561)class_2561.method_43470((String)"\n")))));
                        appenderWithLineBreak.accept(class_2561.method_43470((String)"  \u00bb | ").method_10852((class_2561)class_2561.method_43469((String)"text.config.holder.sync_client_value", (Object[])new Object[]{entries.get()})));
                        configHolder.setToPreviousValue();
                        appenderWithLineBreak.accept(ComponentUtils.separatorLine(null));
                        entries.set(class_2561.method_43470((String)"\n"));
                        extendedHolder.fulfilListing(component -> entries.set(((class_5250)entries.get()).method_10852((class_2561)class_2561.method_43470((String)"    \u00bb | ").method_10852(component).method_10852((class_2561)class_2561.method_43470((String)"\n")))));
                        appenderWithLineBreak.accept(class_2561.method_43470((String)"  \u00bb | ").method_10852((class_2561)class_2561.method_43469((String)"text.config.holder.sync_server_value", (Object[])new Object[]{entries.get()})));
                        appenderWithLineBreak.accept(ComponentUtils.separatorLine(null));
                    } else {
                        appender.accept(class_2561.method_43469((String)"text.config.holder.sync_client_value", (Object[])new Object[]{configHolder.getValueAsComponent()}));
                        appender.accept(class_2561.method_43470((String)" / "));
                        appender.accept(class_2561.method_43469((String)"text.config.holder.sync_server_value", (Object[])new Object[]{configHolder.getValueAsComponent()}));
                    }
                };
                restartRequiredHolders.forEach(lister);
                appenderWithLineBreak.accept(ComponentUtils.separatorLine(null));
            }
            if (isMismatched.get()) {
                context.responseSender().disconnect((class_2561)disconnectReason);
                return;
            }
        } else {
            AtomicBoolean isMismatched = new AtomicBoolean(false);
            ClientPlayNetworking.send((class_8710)new AtlasCore.ClientInformPacket(config));
            ArrayList restartRequiredHolders = new ArrayList();
            config.valueNameToConfigHolderMap.values().forEach(configHolder -> {
                if (configHolder.restartRequired.restartRequiredOn(EnvType.CLIENT) && configHolder.wasUpdated()) {
                    restartRequiredHolders.add(configHolder);
                }
            });
            if (!restartRequiredHolders.isEmpty()) {
                isMismatched.set(true);
                restartRequiredHolders.forEach(ConfigHolder::setToSynchedValue);
                try {
                    config.saveConfig();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                restartRequiredHolders.forEach(ConfigHolder::setToPreviousValue);
                config.valueNameToConfigHolderMap.values().forEach(ConfigHolder::setToPreviousValue);
            }
            if (isMismatched.get()) {
                context.client().method_44714().method_44736((class_2561)class_2561.method_43471((String)"text.config.command.mismatch"), false);
            }
        }
        packet.config().handleExtraSync(packet, context);
    }

    @Environment(value=EnvType.CLIENT)
    public abstract void handleExtraSync(AtlasCore.AtlasConfigPacket var1, ClientPlayNetworking.Context var2);

    public abstract void handleConfigInformation(AtlasCore.ClientInformPacket var1, class_3222 var2, PacketSender var3);

    @Environment(value=EnvType.CLIENT)
    public abstract class_437 createScreen(class_437 var1);

    @Environment(value=EnvType.CLIENT)
    public boolean hasScreen() {
        return true;
    }

    public static enum ConfigSide {
        CLIENT,
        COMMON;


        public String getAsDir() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> "";
                case 0 -> "/client";
            };
        }

        public boolean isCommon() {
            return this == COMMON;
        }
    }

    public static enum SyncMode {
        NONE,
        INFORM_SERVER,
        OVERRIDE_CLIENT;

    }

    public record Category(AtlasConfig config, String name, List<ConfigHolder<?>> members) {
        public String translationKey() {
            return "text.config." + this.config.name.method_12832() + ".category." + this.name;
        }

        public void addMember(ConfigHolder<?> member) {
            this.members.add(member);
        }

        @Environment(value=EnvType.CLIENT)
        public List<AbstractConfigListEntry<?>> membersAsCloth() {
            ArrayList transformed = new ArrayList();
            this.members.forEach(configHolder -> {
                AbstractConfigListEntry<?> entry = configHolder.transformIntoConfigEntry();
                entry.setEditable(!configHolder.serverManaged);
                transformed.add(entry);
            });
            return transformed;
        }
    }

    public static abstract class ConfigHolder<T>
    implements ConfigHolderLike<T> {
        protected T value;
        protected T prevValue = null;
        protected T synchedValue = null;
        protected T parsedValue = null;
        public final ConfigValue<T> heldValue;
        public final class_9139<class_9129, T> streamCodec;
        public final Codec<T> codec;
        public RestartRequiredMode restartRequired = RestartRequiredMode.NO_RESTART;
        public boolean serverManaged = false;
        public Supplier<Optional<class_2561[]>> tooltip = Optional::empty;

        public ConfigHolder(ConfigValue<T> value, Codec<T> codec, class_9139<class_9129, T> streamCodec) {
            this.value = value.defaultValue;
            this.heldValue = value;
            this.streamCodec = streamCodec != null ? streamCodec : this.formAlternateStreamCodec();
            this.codec = codec != null ? codec.fieldOf(value.name).codec() : this.formAlternateCodec();
            value.addAssociation(this);
        }

        protected class_9139<class_9129, T> formAlternateStreamCodec() {
            return null;
        }

        protected Codec<T> formAlternateCodec() {
            return null;
        }

        @Override
        public T get() {
            if (this.synchedValue != null) {
                return this.synchedValue;
            }
            return this.value;
        }

        public boolean wasUpdated() {
            return this.synchedValue != null;
        }

        public DataResult<JsonElement> encodeAsJSON(JsonObject root) {
            return this.codec.encode(this.value, (DynamicOps)JsonOps.INSTANCE, (Object)root);
        }

        public void writeToBuf(class_9129 buf) {
            if (this.heldValue.syncMode() != SyncMode.NONE) {
                this.streamCodec.encode((Object)buf, this.value);
            }
        }

        public void readFromBuf(class_9129 buf) {
            if (this.heldValue.syncMode() != SyncMode.NONE) {
                Object newValue = this.streamCodec.decode((Object)buf);
                if (this.isNotValid(newValue) || this.heldValue.syncMode == SyncMode.INFORM_SERVER) {
                    return;
                }
                if (Objects.equals(newValue, this.value)) {
                    this.synchedValue = null;
                    this.serverManaged = this.heldValue.owner.configSide.isCommon();
                    return;
                }
                this.setSynchedValue(newValue);
            }
        }

        public void broadcastClientValueRecieved(class_9129 buf) {
            if (this.heldValue.syncMode() != SyncMode.NONE) {
                Object clientValue = this.streamCodec.decode((Object)buf);
                this.heldValue.emitClientValueRecieved(this.value, clientValue);
            }
        }

        public boolean isNotValid(T newValue) {
            return !this.heldValue.isValid(newValue);
        }

        public void loadFromJSONAndResetManaged(JsonObject jsonObject) {
            this.setValueAndResetManaged(this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow());
        }

        public void setValueAndResetManaged(T newValue) {
            this.setValue(newValue);
            this.serverManaged = false;
            this.synchedValue = null;
        }

        @Override
        public void setValue(T newValue) {
            if (this.isNotValid(newValue)) {
                return;
            }
            this.prevValue = this.value;
            this.value = newValue;
            this.heldValue.emitChanged(newValue);
        }

        public void resetToDefaultAndResetManaged() {
            this.setValueAndResetManaged(this.heldValue.defaultValue);
        }

        public void resetToDefaultAndSetSynchedValue() {
            this.setSynchedValue(this.heldValue.defaultValue);
        }

        public void setSynchedValue(T newValue) {
            if (this.isNotValid(newValue)) {
                return;
            }
            this.synchedValue = newValue;
            this.serverManaged = this.heldValue.owner.configSide.isCommon();
            this.heldValue.emitChanged(newValue);
        }

        @Override
        public void resetValue() {
            this.setValue(this.heldValue.defaultValue());
        }

        public void tieToCategory(Category category) {
            category.addMember(this);
        }

        public void setRestartRequired(RestartRequiredMode restartRequired) {
            this.restartRequired = restartRequired;
        }

        public void setupTooltip(int length) {
            if (length == 0) {
                AtlasCore.LOGGER.warn("Config holder given a tooltip without any lines!");
                this.tooltip = () -> Optional.of(new class_2561[0]);
                return;
            }
            class_2561[] components = new class_2561[length];
            components[0] = class_2561.method_43471((String)(this.getTranslationKey() + ".tooltip"));
            for (int i = 1; i < length; ++i) {
                components[i] = class_2561.method_43471((String)(this.getTranslationKey() + ".tooltip." + i));
            }
            this.tooltip = () -> Optional.of(components);
        }

        public String getTranslationKey() {
            return "text.config." + this.heldValue.owner.name.method_12832() + ".option." + this.heldValue.name;
        }

        public String getTranslationResetKey() {
            return "text.config." + this.heldValue.owner.name.method_12832() + ".reset";
        }

        public abstract class_2561 getValueAsComponent();

        @Environment(value=EnvType.CLIENT)
        public abstract AbstractConfigListEntry<?> transformIntoConfigEntry();

        @Override
        public void setToParsedValue() {
            if (this.parsedValue == null) {
                return;
            }
            this.setValue(this.parsedValue);
            this.parsedValue = null;
        }

        @Override
        public boolean hasParsedValue() {
            return this.parsedValue != null;
        }

        @Override
        public ConfigHolder<T> getAsHolder() {
            return this;
        }

        @Override
        public String getName() {
            return this.heldValue.name;
        }

        public final void setValueAmbiguousType(Object o) {
            this.setValue(o);
        }

        public void setToPreviousValue() {
            if (this.prevValue != null) {
                this.setValue(this.prevValue);
            }
        }

        public void setToSynchedValue() {
            if (this.synchedValue != null) {
                this.setValue(this.synchedValue);
            }
        }
    }

    public record ConfigValue<T>(T defaultValue, T[] possibleValues, boolean isRange, String name, AtlasConfig owner, SyncMode syncMode) {
        public void emitChanged(T newValue) {
            this.owner.alertChange(this, newValue);
        }

        public void emitClientValueRecieved(T serverValue, T clientValue) {
            this.owner.alertClientValue(this, serverValue, clientValue);
        }

        public boolean isValid(T newValue) {
            return this.possibleValues == null || Arrays.stream(this.possibleValues).toList().contains(newValue);
        }

        public void addAssociation(ConfigHolder<T> configHolder) {
            if (this.owner.valueNameToConfigHolderMap.containsKey(this.name)) {
                throw new class_148(new class_128("Tried to associate a ConfigHolder to a ConfigValue which already has one!", (Throwable)new RuntimeException()));
            }
            this.owner.valueNameToConfigHolderMap.put(this.name, configHolder);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConfigValue)) {
                return false;
            }
            ConfigValue that = (ConfigValue)o;
            return this.isRange() == that.isRange() && Objects.equals(this.defaultValue, that.defaultValue) && Arrays.equals(this.possibleValues, that.possibleValues) && Objects.equals(this.name, that.name) && Objects.equals(this.owner, that.owner);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.defaultValue, this.isRange(), this.name, this.owner);
            result = 31 * result + Arrays.hashCode(this.possibleValues);
            return result;
        }
    }

    public static class TagHolder<T>
    extends ConfigHolder<T> {
        private final Codec<T> rawCodec;

        private TagHolder(ConfigValue<T> value, Codec<T> codec) {
            super(value, codec, class_9135.method_57987(codec).method_56439(buf -> buf));
            this.rawCodec = codec;
        }

        @Override
        public class_2561 getValueAsComponent() {
            return class_2561.method_43470((String)this.asSNBT(this.get()));
        }

        public class_2520 asNBT(T val) {
            class_2520 tag = (class_2520)this.rawCodec.encodeStart((DynamicOps)class_2509.field_11560, val).getOrThrow();
            return tag;
        }

        public String asSNBT(T val) {
            return this.asNBT(val).method_10714();
        }

        public T loadFromSNBT(StringReader reader) throws CommandSyntaxException {
            class_2520 tag = new class_2522(reader).method_10723();
            return (T)this.rawCodec.parse((DynamicOps)class_2509.field_11560, (Object)tag).getOrThrow(s -> CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, s));
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public AbstractConfigListEntry<?> transformIntoConfigEntry() {
            return new CodecBackedListEntry<T>((class_2561)class_2561.method_43471((String)this.getTranslationKey()), this.rawCodec, this.asNBT(this.get()), (class_2561)class_2561.method_43471((String)this.getTranslationResetKey()), () -> this.asNBT(this.heldValue.defaultValue), tag -> this.setValue(this.rawCodec.parse((DynamicOps)class_2509.field_11560, tag).getOrThrow()), this.tooltip, this.restartRequired.restartRequiredOn(EnvType.CLIENT));
        }

        @Override
        public <S> CompletableFuture<Suggestions> buildSuggestions(CommandContext<S> commandContext, SuggestionsBuilder builder) {
            return Suggestions.empty();
        }

        @Override
        public <S> void verifySuggestionsArePresent(CommandContext<S> commandContext, StringReader reader) throws CommandSyntaxException {
            this.loadFromSNBT(reader);
        }

        @Override
        public <S> T parse(StringReader stringReader, S source, CommandContext<S> commandContext) throws CommandSyntaxException {
            this.parsedValue = this.loadFromSNBT(stringReader);
            return (T)this.parsedValue;
        }
    }

    public static class ObjectHolder<T extends ConfigRepresentable>
    extends ConfigHolder<T>
    implements ExtendedHolder {
        public final Class<T> clazz;
        public final boolean expandByDefault;

        private ObjectHolder(ConfigValue<T> value, Class<T> clazz, class_9139<class_9129, T> sync, boolean expandByDefault) {
            super(value, null, sync);
            ((ConfigRepresentable)this.value).setOwnerHolder(this);
            this.clazz = clazz;
            this.expandByDefault = expandByDefault;
        }

        @Override
        protected Codec<T> formAlternateCodec() {
            return ((ConfigRepresentable)this.heldValue.defaultValue()).getCodec(this).fieldOf(this.heldValue.name).codec();
        }

        @Override
        public class_2561 getValueAsComponent() {
            return class_2561.method_43471((String)this.getTranslationKey());
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public AbstractConfigListEntry<?> transformIntoConfigEntry() {
            return new MultiElementListEntry((class_2561)class_2561.method_43471((String)this.getTranslationKey()), (Object)((ConfigRepresentable)this.get()), ((ConfigRepresentable)this.get()).transformIntoConfigEntries(), this.expandByDefault);
        }

        @Override
        public <S> CompletableFuture<Suggestions> buildSuggestions(CommandContext<S> commandContext, SuggestionsBuilder builder) {
            StringReader reader = new StringReader(builder.getInput());
            reader.setCursor(builder.getStart());
            SuggestionsVisitor visitor = new SuggestionsVisitor();
            visitor.visitSuggestions(suggestionsBuilder -> class_2172.method_9265(((ConfigRepresentable)this.heldValue.defaultValue).fields(), (SuggestionsBuilder)builder));
            try {
                this.suggestFields(visitor, commandContext, reader, builder.getStart());
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return visitor.resolveSuggestions(builder, reader);
        }

        @Override
        public <S> void verifySuggestionsArePresent(CommandContext<S> commandContext, StringReader reader) throws CommandSyntaxException {
            FieldHolder field = (FieldHolder)this.findInner(reader);
            reader.expect('=');
            field.verifySuggestionsArePresent(commandContext, reader);
        }

        private <S> void suggestFields(SuggestionsVisitor visitor, CommandContext<S> context, StringReader reader, int cursor) throws CommandSyntaxException {
            String fieldName = ConfigHolderArgument.readHolderName(reader);
            if (this.retrieveInner(fieldName) == null) {
                reader.setCursor(cursor);
                throw ConfigHolderArgument.ERROR_UNKNOWN_HOLDER.createWithContext((ImmutableStringReader)reader, (Object)fieldName);
            }
            visitor.visitSuggestions(this::suggestSetValue);
            reader.expect('=');
            visitor.visitSuggestions(builder -> {
                try {
                    return this.retrieveInner(fieldName).buildSuggestions(context, (SuggestionsBuilder)builder);
                }
                catch (CommandSyntaxException e) {
                    reader.setCursor(cursor);
                    return Suggestions.empty();
                }
            });
        }

        private CompletableFuture<Suggestions> suggestSetValue(SuggestionsBuilder suggestionsBuilder) {
            if (suggestionsBuilder.getRemaining().isEmpty()) {
                suggestionsBuilder.suggest(String.valueOf('='));
            }
            return suggestionsBuilder.buildFuture();
        }

        @Override
        public <S> T parse(StringReader stringReader, S source, CommandContext<S> context) throws CommandSyntaxException {
            int cursor = stringReader.getCursor();
            try {
                FieldHolder field = (FieldHolder)this.findInner(stringReader);
                stringReader.expect('=');
                field.parse(stringReader, source, context);
                field.setToParsedValue();
            }
            catch (CommandSyntaxException e) {
                stringReader.setCursor(cursor);
                throw e;
            }
            return (T)((ConfigRepresentable)this.get());
        }

        @Override
        public class_2561 getInnerTranslation(String name) {
            return ((ConfigRepresentable)this.get()).getFieldName(name);
        }

        @Override
        public class_2561 getInnerValue(String name) {
            return ((ConfigRepresentable)this.get()).getFieldValue(name);
        }

        @Override
        public void listInner(String name, Consumer<class_2561> input) {
            ((ConfigRepresentable)this.get()).listField(name, input);
        }

        @Override
        public void fulfilListing(Consumer<class_2561> input) {
            ((ConfigRepresentable)this.get()).listFields(input);
        }

        @Override
        public List<ConfigHolderLike<?>> getUnsetInners() {
            ArrayList inners = new ArrayList();
            List<String> fields = ((ConfigRepresentable)this.get()).fields();
            for (String field : fields) {
                try {
                    ConfigHolderLike<?> fieldHolder = this.retrieveInner(field);
                    if (!fieldHolder.hasParsedValue()) continue;
                    inners.add(fieldHolder);
                }
                catch (CommandSyntaxException commandSyntaxException) {}
            }
            return inners;
        }

        @Override
        public ConfigHolderLike<?> findInner(StringReader reader) throws CommandSyntaxException {
            String name;
            List<String> fields = ((ConfigRepresentable)this.heldValue.defaultValue()).fields();
            if (!fields.contains(name = ConfigHolderArgument.readHolderName(reader))) {
                throw ConfigHolderArgument.ERROR_UNKNOWN_HOLDER.createWithContext((ImmutableStringReader)reader, (Object)name);
            }
            Field field = ((ConfigRepresentable)this.heldValue.defaultValue()).fieldRepresentingHolder(name);
            try {
                return new FieldHolder(this, field, ((ConfigRepresentable)this.heldValue.defaultValue()).argumentTypeRepresentingHolder(name), field.get(this.heldValue.defaultValue()), name);
            }
            catch (IllegalAccessException e) {
                throw ConfigHolderArgument.ERROR_MALFORMED_HOLDER.createWithContext((ImmutableStringReader)reader, (Object)name);
            }
        }

        @Override
        public ConfigHolderLike<?> retrieveInner(String name) throws CommandSyntaxException {
            List<String> fields = ((ConfigRepresentable)this.heldValue.defaultValue()).fields();
            if (!fields.contains(name)) {
                return null;
            }
            Field field = ((ConfigRepresentable)this.heldValue.defaultValue()).fieldRepresentingHolder(name);
            try {
                return new FieldHolder(this, field, ((ConfigRepresentable)this.heldValue.defaultValue()).argumentTypeRepresentingHolder(name), field.get(this.heldValue.defaultValue()), name);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }

        @Override
        public CompletableFuture<Suggestions> suggestInner(StringReader reader, SuggestionsBuilder builder) {
            List<String> fields = ((ConfigRepresentable)this.heldValue.defaultValue()).fields();
            return class_2172.method_9265(fields, (SuggestionsBuilder)builder);
        }

        @Override
        public int postUpdate(class_2168 commandSourceStack) {
            try {
                AtlasConfig config = this.heldValue.owner;
                config.saveConfig();
                commandSourceStack.method_9211().method_3760().method_14581(ServerPlayNetworking.createS2CPacket((class_8710)new AtlasCore.AtlasConfigPacket(true, config)));
                commandSourceStack.method_9226(() -> ComponentUtils.separatorLine(config.getFormattedName().method_27661(), true), true);
                if (this.restartRequired.restartRequiredOn(FabricLoader.getInstance().getEnvironmentType())) {
                    commandSourceStack.method_9226(() -> class_2561.method_43470((String)"  \u00bb ").method_10852((class_2561)class_2561.method_48322((String)"text.config.holder_requires_restart.no_value", (String)"The value for %s has been saved successfully, however changes will not take effect without a restart.", (Object[])new Object[]{class_2561.method_43471((String)this.getTranslationKey())})), true);
                } else {
                    commandSourceStack.method_9226(() -> class_2561.method_43470((String)"  \u00bb ").method_10852((class_2561)class_2561.method_48322((String)"text.config.update_holder.no_value", (String)"The value for config holder %s was changed successfully.", (Object[])new Object[]{class_2561.method_43471((String)this.getTranslationKey())})), true);
                }
                commandSourceStack.method_9226(() -> ComponentUtils.separatorLine(null), true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return 1;
        }

        @Override
        public void setValue(T newValue) {
            newValue.setOwnerHolder(this);
            super.setValue(newValue);
        }

        @Override
        public void setSynchedValue(T newValue) {
            newValue.setOwnerHolder(this);
            super.setSynchedValue(newValue);
        }

        static class SuggestionsVisitor {
            private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions = OptsArgumentUtils.SUGGEST_NOTHING;

            SuggestionsVisitor() {
            }

            public void visitSuggestions(Function<SuggestionsBuilder, CompletableFuture<Suggestions>> function) {
                this.suggestions = function;
            }

            public CompletableFuture<Suggestions> resolveSuggestions(SuggestionsBuilder suggestionsBuilder, StringReader stringReader) {
                return this.suggestions.apply(suggestionsBuilder.createOffset(stringReader.getCursor()));
            }
        }
    }

    public static class EnumHolder<E extends Enum<E>>
    extends ConfigHolder<E> {
        public final Class<E> clazz;
        public final Function<Enum, class_2561> names;

        private EnumHolder(ConfigValue<E> value, Class<E> clazz, Function<Enum, class_2561> names) {
            super(value, Codec.STRING.validate(string -> Arrays.stream((Enum[])value.possibleValues).noneMatch(e -> e.name().equalsIgnoreCase((String)string)) ? DataResult.error(() -> "Invalid enum constant for type " + clazz.getSimpleName() + ": " + string) : DataResult.success((Object)string)).xmap(s -> Enum.valueOf(clazz, s.toUpperCase()), e -> e.name().toLowerCase()), class_9139.method_56437(class_2540::method_10817, buf -> buf.method_10818(clazz)));
            this.clazz = clazz;
            this.names = names;
        }

        @Override
        public class_2561 getValueAsComponent() {
            return this.names.apply((Enum)this.get());
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public AbstractConfigListEntry<?> transformIntoConfigEntry() {
            return new EnumListEntry((class_2561)class_2561.method_43471((String)this.getTranslationKey()), this.clazz, (Enum)this.get(), (class_2561)class_2561.method_43471((String)this.getTranslationResetKey()), () -> (Enum)this.heldValue.defaultValue, this::setValue, this.names, this.tooltip, this.restartRequired.restartRequiredOn(EnvType.CLIENT));
        }

        @Override
        public <S> CompletableFuture<Suggestions> buildSuggestions(CommandContext<S> commandContext, SuggestionsBuilder builder) {
            for (Enum e : (Enum[])this.heldValue.possibleValues) {
                if (!e.name().toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(e.name().toLowerCase());
            }
            return builder.buildFuture();
        }

        @Override
        public <S> void verifySuggestionsArePresent(CommandContext<S> commandContext, StringReader reader) throws CommandSyntaxException {
            String name = reader.readString();
            for (Enum entry : (Enum[])this.heldValue.possibleValues) {
                if (!entry.name().toLowerCase().equals(name.toLowerCase())) continue;
                return;
            }
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedSymbol().create((Object)"a valid enum input");
        }

        @Override
        public <S> E parse(StringReader stringReader, S source, CommandContext<S> commandContext) throws CommandSyntaxException {
            String name = stringReader.readString();
            for (Enum e : (Enum[])this.heldValue.possibleValues) {
                if (!e.name().equalsIgnoreCase(name)) continue;
                this.parsedValue = e;
                return (E)e;
            }
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedSymbol().create((Object)"a valid enum input");
        }
    }

    public static class StringHolder
    extends ConfigHolder<String> {
        private StringHolder(ConfigValue<String> value) {
            super(value, Codec.STRING.validate(s -> value.possibleValues == null || Arrays.asList((String[])value.possibleValues).contains(s) ? DataResult.success((Object)s) : DataResult.error(() -> "Expected a string matching one of the following: " + Arrays.toString(value.possibleValues) + "\nFound: " + s)), class_9135.field_48554.method_56439(buf -> buf));
        }

        @Override
        public class_2561 getValueAsComponent() {
            return class_2561.method_43470((String)((String)this.get()));
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public AbstractConfigListEntry<?> transformIntoConfigEntry() {
            return new StringListEntry((class_2561)class_2561.method_43471((String)this.getTranslationKey()), (String)this.get(), (class_2561)class_2561.method_43471((String)this.getTranslationResetKey()), () -> (String)this.heldValue.defaultValue, this::setValue, this.tooltip, this.restartRequired.restartRequiredOn(EnvType.CLIENT));
        }

        @Override
        public <S> CompletableFuture<Suggestions> buildSuggestions(CommandContext<S> commandContext, SuggestionsBuilder builder) {
            if (this.heldValue.possibleValues != null) {
                return class_2172.method_9253((String[])((String[])this.heldValue.possibleValues), (SuggestionsBuilder)builder);
            }
            return Suggestions.empty();
        }

        @Override
        public <S> void verifySuggestionsArePresent(CommandContext<S> commandContext, StringReader reader) throws CommandSyntaxException {
            String read = reader.readString();
            if (this.heldValue.possibleValues != null) {
                if (Arrays.stream((String[])this.heldValue.possibleValues).noneMatch(read::equals)) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().create();
                }
            }
        }

        @Override
        public <S> String parse(StringReader stringReader, S source, CommandContext<S> commandContext) throws CommandSyntaxException {
            String read = stringReader.readString();
            if (this.heldValue.possibleValues != null) {
                if (Arrays.stream((String[])this.heldValue.possibleValues).noneMatch(read::equals)) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().create();
                }
            }
            this.parsedValue = read;
            return (String)this.parsedValue;
        }
    }

    public static class BooleanHolder
    extends ConfigHolder<Boolean> {
        private BooleanHolder(ConfigValue<Boolean> value) {
            super(value, Codec.BOOL, class_9135.field_48547.method_56439(buf -> buf));
        }

        @Override
        public class_2561 getValueAsComponent() {
            return (Boolean)this.get() != false ? class_2561.method_43471((String)"text.config.true") : class_2561.method_43471((String)"text.config.false");
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public AbstractConfigListEntry<?> transformIntoConfigEntry() {
            return new BooleanListEntry((class_2561)class_2561.method_43471((String)this.getTranslationKey()), ((Boolean)this.get()).booleanValue(), (class_2561)class_2561.method_43471((String)this.getTranslationResetKey()), () -> (Boolean)this.heldValue.defaultValue, this::setValue, this.tooltip, this.restartRequired.restartRequiredOn(EnvType.CLIENT));
        }

        @Override
        public <S> CompletableFuture<Suggestions> buildSuggestions(CommandContext<S> commandContext, SuggestionsBuilder builder) {
            if ("true".startsWith(builder.getRemainingLowerCase())) {
                builder.suggest("true");
            }
            if ("false".startsWith(builder.getRemainingLowerCase())) {
                builder.suggest("false");
            }
            return builder.buildFuture();
        }

        @Override
        public <S> void verifySuggestionsArePresent(CommandContext<S> commandContext, StringReader reader) throws CommandSyntaxException {
            if (!reader.getRemaining().equals("true") && !reader.getRemaining().equals("false")) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedBool().create();
            }
        }

        @Override
        public <S> Boolean parse(StringReader stringReader, S source, CommandContext<S> commandContext) throws CommandSyntaxException {
            this.parsedValue = stringReader.readBoolean();
            return (Boolean)this.parsedValue;
        }
    }

    public static class ColorHolder
    extends ConfigHolder<Integer> {
        private boolean hasAlpha;

        private ColorHolder(ConfigValue<Integer> value, boolean alpha) {
            super(value, Codec.STRING.validate(s -> AtlasConfig.stripHexStarter(s).length() > (alpha ? 8 : 6) ? DataResult.error(() -> "Input too long to be a valid color hex: " + s) : DataResult.success((Object)s)).xmap(s -> AtlasConfig.getColor(s, null, alpha), integer -> "#" + ColorHolder.toColorHex(alpha, integer)), class_9135.field_48550.method_56439(buf -> buf));
            this.hasAlpha = alpha;
        }

        @Override
        public boolean isNotValid(Integer newValue) {
            String hex = Integer.toHexString(newValue);
            if (hex.length() > 8) {
                return true;
            }
            if (!this.hasAlpha && hex.length() > 6) {
                return true;
            }
            return super.isNotValid(newValue);
        }

        @Override
        public class_2561 getValueAsComponent() {
            return class_2561.method_43470((String)("#" + ColorHolder.toColorHex(this.hasAlpha, (Integer)this.get())));
        }

        public static String toColorHex(boolean hasAlpha, int val) {
            int i = 6;
            if (hasAlpha) {
                i = 8;
            }
            String toHex = Integer.toHexString(val);
            while (toHex.length() < i) {
                toHex = "0".concat(toHex);
            }
            return toHex;
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public AbstractConfigListEntry<?> transformIntoConfigEntry() {
            ColorEntry entry = new ColorEntry((class_2561)class_2561.method_43471((String)this.getTranslationKey()), ((Integer)this.get()).intValue(), (class_2561)class_2561.method_43471((String)this.getTranslationResetKey()), () -> (Integer)this.heldValue.defaultValue, this::setValue, this.tooltip, this.restartRequired.restartRequiredOn(EnvType.CLIENT));
            if (this.hasAlpha) {
                entry.withAlpha();
            } else {
                entry.withoutAlpha();
            }
            return entry;
        }

        @Override
        public <S> CompletableFuture<Suggestions> buildSuggestions(CommandContext<S> commandContext, SuggestionsBuilder builder) {
            return Suggestions.empty();
        }

        @Override
        public <S> void verifySuggestionsArePresent(CommandContext<S> commandContext, StringReader reader) throws CommandSyntaxException {
            String hex = reader.readString();
            AtlasConfig.stripHexStarter(hex);
            int result = (int)Long.parseLong(hex, 16);
            if (hex.length() > 8) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().createWithContext((ImmutableStringReader)reader, (Object)result);
            }
            if (!this.hasAlpha && hex.length() > 6) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().createWithContext((ImmutableStringReader)reader, (Object)result);
            }
        }

        @Override
        public <S> Integer parse(StringReader reader, S source, CommandContext<S> commandContext) throws CommandSyntaxException {
            String hex = reader.readString();
            AtlasConfig.stripHexStarter(hex);
            int result = (int)Long.parseLong(hex, 16);
            if (hex.length() > 8) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().createWithContext((ImmutableStringReader)reader, (Object)result);
            }
            if (!this.hasAlpha && hex.length() > 6) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().createWithContext((ImmutableStringReader)reader, (Object)result);
            }
            this.parsedValue = result;
            return result;
        }
    }

    public static class IntegerHolder
    extends ConfigHolder<Integer> {
        public final boolean isSlider;

        private IntegerHolder(ConfigValue<Integer> value, boolean isSlider) {
            super(value, value.possibleValues == null ? Codec.INT : (value.isRange ? class_5699.method_48766((int)((Integer[])value.possibleValues)[0], (int)((Integer[])value.possibleValues)[1]) : Codec.INT.validate(integer -> Arrays.asList((Integer[])value.possibleValues).contains(integer) ? DataResult.success((Object)integer) : DataResult.error(() -> "Expected an integer within the following: " + Arrays.toString(value.possibleValues) + "\nFound: " + integer))), class_9135.field_48550.method_56439(buf -> buf));
            this.isSlider = isSlider;
        }

        @Override
        public boolean isNotValid(Integer newValue) {
            if (this.heldValue.possibleValues == null) {
                return super.isNotValid(newValue);
            }
            boolean inRange = this.heldValue.isRange && newValue >= ((Integer[])this.heldValue.possibleValues)[0] && newValue <= ((Integer[])this.heldValue.possibleValues)[1];
            return super.isNotValid(newValue) && !inRange;
        }

        @Override
        public class_2561 getValueAsComponent() {
            return class_2561.method_43470((String)String.valueOf(this.get()));
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public AbstractConfigListEntry<?> transformIntoConfigEntry() {
            if (!this.heldValue.isRange || !this.isSlider) {
                return new IntegerListEntry((class_2561)class_2561.method_43471((String)this.getTranslationKey()), (Integer)this.get(), (class_2561)class_2561.method_43471((String)this.getTranslationResetKey()), () -> (Integer)this.heldValue.defaultValue, this::setValue, this.tooltip, this.restartRequired.restartRequiredOn(EnvType.CLIENT));
            }
            return new IntegerSliderEntry((class_2561)class_2561.method_43471((String)this.getTranslationKey()), ((Integer[])this.heldValue.possibleValues)[0].intValue(), ((Integer[])this.heldValue.possibleValues)[1].intValue(), ((Integer)this.get()).intValue(), (class_2561)class_2561.method_43471((String)this.getTranslationResetKey()), () -> (Integer)this.heldValue.defaultValue, this::setValue, this.tooltip, this.restartRequired.restartRequiredOn(EnvType.CLIENT));
        }

        @Override
        public <S> CompletableFuture<Suggestions> buildSuggestions(CommandContext<S> commandContext, SuggestionsBuilder builder) {
            if (this.heldValue.possibleValues != null && !this.heldValue.isRange) {
                for (Integer i : (Integer[])this.heldValue.possibleValues) {
                    if (!i.toString().startsWith(builder.getRemainingLowerCase())) continue;
                    builder.suggest(i.toString());
                }
                return builder.buildFuture();
            }
            return Suggestions.empty();
        }

        @Override
        public <S> void verifySuggestionsArePresent(CommandContext<S> commandContext, StringReader reader) throws CommandSyntaxException {
            int start = reader.getCursor();
            int result = reader.readInt();
            if (this.heldValue.possibleValues != null) {
                if (this.heldValue.isRange) {
                    if (result < ((Integer[])this.heldValue.possibleValues)[0]) {
                        reader.setCursor(start);
                        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooLow().createWithContext((ImmutableStringReader)reader, (Object)result, (Object)((Integer[])this.heldValue.possibleValues)[0]);
                    }
                    if (result > ((Integer[])this.heldValue.possibleValues)[1]) {
                        reader.setCursor(start);
                        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooHigh().createWithContext((ImmutableStringReader)reader, (Object)result, (Object)((Integer[])this.heldValue.possibleValues)[1]);
                    }
                } else if (Arrays.stream((Integer[])this.heldValue.possibleValues).noneMatch(integer -> integer == result)) {
                    reader.setCursor(start);
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().createWithContext((ImmutableStringReader)reader, (Object)result);
                }
            }
        }

        @Override
        public <S> Integer parse(StringReader reader, S source, CommandContext<S> commandContext) throws CommandSyntaxException {
            int start = reader.getCursor();
            int result = reader.readInt();
            if (this.heldValue.possibleValues != null) {
                if (this.heldValue.isRange) {
                    if (result < ((Integer[])this.heldValue.possibleValues)[0]) {
                        reader.setCursor(start);
                        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooLow().createWithContext((ImmutableStringReader)reader, (Object)result, (Object)((Integer[])this.heldValue.possibleValues)[0]);
                    }
                    if (result > ((Integer[])this.heldValue.possibleValues)[1]) {
                        reader.setCursor(start);
                        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooHigh().createWithContext((ImmutableStringReader)reader, (Object)result, (Object)((Integer[])this.heldValue.possibleValues)[1]);
                    }
                } else if (Arrays.stream((Integer[])this.heldValue.possibleValues).noneMatch(integer -> integer == result)) {
                    reader.setCursor(start);
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().createWithContext((ImmutableStringReader)reader, (Object)result);
                }
            }
            this.parsedValue = result;
            return result;
        }
    }

    public static class DoubleHolder
    extends ConfigHolder<Double> {
        private DoubleHolder(ConfigValue<Double> value) {
            super(value, value.possibleValues == null ? Codec.DOUBLE : (value.isRange ? Codecs.doubleRange(((Double[])value.possibleValues)[0], ((Double[])value.possibleValues)[1]) : Codec.DOUBLE.validate(d -> Arrays.asList((Double[])value.possibleValues).contains(d) ? DataResult.success((Object)d) : DataResult.error(() -> "Expected an double within the following: " + Arrays.toString(value.possibleValues) + "\nFound: " + d))), class_9135.field_48553.method_56439(buf -> buf));
        }

        @Override
        public boolean isNotValid(Double newValue) {
            if (this.heldValue.possibleValues == null) {
                return super.isNotValid(newValue);
            }
            boolean inRange = this.heldValue.isRange && newValue >= ((Double[])this.heldValue.possibleValues)[0] && newValue <= ((Double[])this.heldValue.possibleValues)[1];
            return super.isNotValid(newValue) && !inRange;
        }

        @Override
        public class_2561 getValueAsComponent() {
            return class_2561.method_43470((String)String.valueOf(this.get()));
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public AbstractConfigListEntry<?> transformIntoConfigEntry() {
            return new DoubleListEntry((class_2561)class_2561.method_43471((String)this.getTranslationKey()), (Double)this.get(), (class_2561)class_2561.method_43471((String)this.getTranslationResetKey()), () -> (Double)this.heldValue.defaultValue, this::setValue, this.tooltip, this.restartRequired.restartRequiredOn(EnvType.CLIENT));
        }

        @Override
        public <S> CompletableFuture<Suggestions> buildSuggestions(CommandContext<S> commandContext, SuggestionsBuilder builder) {
            if (this.heldValue.possibleValues != null && !this.heldValue.isRange) {
                for (Double d : (Double[])this.heldValue.possibleValues) {
                    if (!d.toString().startsWith(builder.getRemainingLowerCase())) continue;
                    builder.suggest(d.toString());
                }
                return builder.buildFuture();
            }
            return Suggestions.empty();
        }

        @Override
        public <S> void verifySuggestionsArePresent(CommandContext<S> commandContext, StringReader reader) throws CommandSyntaxException {
            int start = reader.getCursor();
            double result = reader.readDouble();
            if (this.heldValue.possibleValues != null) {
                if (this.heldValue.isRange) {
                    if (result < ((Double[])this.heldValue.possibleValues)[0]) {
                        reader.setCursor(start);
                        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.doubleTooLow().createWithContext((ImmutableStringReader)reader, (Object)result, (Object)((Double[])this.heldValue.possibleValues)[0]);
                    }
                    if (result > ((Double[])this.heldValue.possibleValues)[1]) {
                        reader.setCursor(start);
                        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.doubleTooHigh().createWithContext((ImmutableStringReader)reader, (Object)result, (Object)((Double[])this.heldValue.possibleValues)[1]);
                    }
                } else if (Arrays.stream((Double[])this.heldValue.possibleValues).noneMatch(integer -> integer == result)) {
                    reader.setCursor(start);
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidDouble().createWithContext((ImmutableStringReader)reader, (Object)result);
                }
            }
        }

        @Override
        public <S> Double parse(StringReader reader, S source, CommandContext<S> commandContext) throws CommandSyntaxException {
            int start = reader.getCursor();
            double result = reader.readDouble();
            if (this.heldValue.possibleValues != null) {
                if (this.heldValue.isRange) {
                    if (result < ((Double[])this.heldValue.possibleValues)[0]) {
                        reader.setCursor(start);
                        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.doubleTooLow().createWithContext((ImmutableStringReader)reader, (Object)result, (Object)((Double[])this.heldValue.possibleValues)[0]);
                    }
                    if (result > ((Double[])this.heldValue.possibleValues)[1]) {
                        reader.setCursor(start);
                        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.doubleTooHigh().createWithContext((ImmutableStringReader)reader, (Object)result, (Object)((Double[])this.heldValue.possibleValues)[1]);
                    }
                } else if (Arrays.stream((Double[])this.heldValue.possibleValues).noneMatch(integer -> integer == result)) {
                    reader.setCursor(start);
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidDouble().createWithContext((ImmutableStringReader)reader, (Object)result);
                }
            }
            this.parsedValue = result;
            return result;
        }
    }

    public static enum RestartRequiredMode {
        NO_RESTART(env -> false),
        RESTART_CLIENT(env -> env == EnvType.CLIENT),
        RESTART_BOTH(env -> true);

        public final Predicate<EnvType> forEnvironment;

        private RestartRequiredMode(Predicate<EnvType> predicate) {
            this.forEnvironment = predicate;
        }

        public boolean restartRequiredOn(EnvType envType) {
            return this.forEnvironment.test(envType);
        }
    }
}

