/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Consumer;
import net.atlas.atlascore.command.ConfigCommand;
import net.atlas.atlascore.config.AtlasConfig;
import net.atlas.atlascore.config.AtlasCoreConfig;
import net.atlas.atlascore.config.ContextBasedConfig;
import net.atlas.atlascore.util.Context;
import net.atlas.atlascore.util.ModRepresentation;
import net.atlas.atlascore.util.NetworkingUtilities;
import net.atlas.atlascore.util.PrefixLogger;
import net.atlas.atlascore.util.ServerModsRetrievedEvent;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.network.event.RegisterConfigurationTasksEvent;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;

@Mod(value="atlas_core")
@EventBusSubscriber(modid="atlas_core")
public class AtlasCore {
    public static final String MOD_ID = "atlas_core";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final PrefixLogger LOGGER = new PrefixLogger(LogManager.getLogger((String)"Atlas Core"));
    public static AtlasCoreConfig CONFIG;
    public static ResourceLocation modDetectionNetworkChannel;

    public AtlasCore(ModContainer container) {
        CONFIG = new AtlasCoreConfig();
        PayloadTypeRegistry.playS2C().register(AtlasConfigPacket.TYPE, AtlasConfigPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(ClientInformPacket.TYPE, ClientInformPacket.CODEC);
        PayloadTypeRegistry.configurationC2S().register(ServerboundClientModPacket.TYPE, ServerboundClientModPacket.CODEC);
        PayloadTypeRegistry.configurationS2C().register(ClientboundModListRetrievalPacket.TYPE, ClientboundModListRetrievalPacket.CODEC);
        ServerPlayConnectionEvents.JOIN.register(modDetectionNetworkChannel, (handler, sender, server) -> {
            for (AtlasConfig atlasConfig2 : AtlasConfig.configs.values().stream().filter(atlasConfig -> atlasConfig.configSide.isCommon()).toList()) {
                if (atlasConfig2 instanceof ContextBasedConfig) {
                    ContextBasedConfig contextBasedConfig = (ContextBasedConfig)atlasConfig2;
                    atlasConfig2 = contextBasedConfig.getConfig(Context.builder().applyInformationFromEntity((Entity)handler.player).build());
                }
                ServerPlayNetworking.send((ServerPlayer)handler.player, (CustomPacketPayload)new AtlasConfigPacket(false, atlasConfig2));
            }
            LOGGER.info("Config packets sent to client.");
        });
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register(modDetectionNetworkChannel, (player, origin, destination) -> {
            for (ContextBasedConfig contextBasedConfig : AtlasConfig.configs.values().stream().filter(atlasConfig -> atlasConfig.configSide.isCommon() && atlasConfig instanceof ContextBasedConfig).map(config -> ((ContextBasedConfig)config).getConfig(Context.builder().applyInformationFromLevel((Level)destination).build())).toList()) {
                ServerPlayNetworking.send((ServerPlayer)player, (CustomPacketPayload)new AtlasConfigPacket(false, contextBasedConfig));
            }
        });
        ServerConfigurationNetworking.registerGlobalReceiver(ServerboundClientModPacket.TYPE, (payload, context) -> {
            ((ServerModsRetrievedEvent.RetrieveMods)ServerModsRetrievedEvent.RETRIEVAL.invoker()).onModsReceived(context.networkHandler(), context.responseSender(), payload.modRepresentations());
            context.networkHandler().finishCurrentTask(ClientModRetrievalTask.TYPE);
        });
        ServerPlayNetworking.registerGlobalReceiver(ClientInformPacket.TYPE, (packet, context) -> packet.config().handleConfigInformation((ClientInformPacket)packet, context.player(), context.responseSender()));
        ServerModsRetrievedEvent.RETRIEVAL.register((handler, sender, mods) -> {
            if (((Boolean)AtlasCore.CONFIG.listClientModsOnJoin.get()).booleanValue()) {
                String[] list = new String[]{"Client mods: \n"};
                mods.stream().sorted(Comparator.comparing(ModRepresentation::modID)).forEach(modRepresentation -> modRepresentation.list(string -> {
                    list[0] = list[0] + string + "\n";
                }, ModRepresentation::modID, "\t\u00bb | "));
                LOGGER.info(list[0].substring(0, list[0].length() - 1));
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> ConfigCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher));
    }

    @SubscribeEvent
    static void onRegisterConfigurationTasks(RegisterConfigurationTasksEvent event) {
        if (ServerConfigurationNetworking.canSend((ServerConfigurationPacketListenerImpl)((ServerConfigurationPacketListenerImpl)event.getListener()), ClientboundModListRetrievalPacket.TYPE)) {
            event.register((ConfigurationTask)new ClientModRetrievalTask());
        }
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    static {
        modDetectionNetworkChannel = AtlasCore.id("networking");
    }

    public record AtlasConfigPacket(boolean forCommand, AtlasConfig config) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<AtlasConfigPacket> TYPE = new CustomPacketPayload.Type(AtlasCore.id("atlas_config"));
        public static final StreamCodec<RegistryFriendlyByteBuf, AtlasConfigPacket> CODEC = CustomPacketPayload.codec(AtlasConfigPacket::write, AtlasConfigPacket::new);

        public AtlasConfigPacket(RegistryFriendlyByteBuf buf) {
            this(buf.readBoolean(), AtlasConfig.staticLoadFromNetwork(buf));
        }

        public void write(RegistryFriendlyByteBuf buf) {
            buf.writeBoolean(this.forCommand);
            buf.writeResourceLocation(this.config.name);
            this.config.saveToNetwork(buf);
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record ClientInformPacket(AtlasConfig config) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ClientInformPacket> TYPE = new CustomPacketPayload.Type(AtlasCore.id("c2s_inform_config"));
        public static final StreamCodec<RegistryFriendlyByteBuf, ClientInformPacket> CODEC = CustomPacketPayload.codec(ClientInformPacket::write, ClientInformPacket::new);

        public ClientInformPacket(RegistryFriendlyByteBuf buf) {
            this(AtlasConfig.staticReadClientConfigInformation(buf));
        }

        public void write(RegistryFriendlyByteBuf buf) {
            buf.writeResourceLocation(this.config.name);
            this.config.saveToNetwork(buf);
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record ServerboundClientModPacket(Collection<ModRepresentation> modRepresentations) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ServerboundClientModPacket> TYPE = new CustomPacketPayload.Type(AtlasCore.id("client_mods"));
        public static final StreamCodec<FriendlyByteBuf, ServerboundClientModPacket> CODEC = CustomPacketPayload.codec(ServerboundClientModPacket::write, ServerboundClientModPacket::new);

        public ServerboundClientModPacket(FriendlyByteBuf buf) {
            this(NetworkingUtilities.modsFromNetwork(buf));
        }

        public void write(FriendlyByteBuf buf) {
            NetworkingUtilities.modsToNetwork(buf, this.modRepresentations);
        }

        @NotNull
        public CustomPacketPayload.Type<?> type() {
            return TYPE;
        }
    }

    public record ClientboundModListRetrievalPacket() implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ClientboundModListRetrievalPacket> TYPE = new CustomPacketPayload.Type(AtlasCore.id("client_mods_retrieval"));
        public static final StreamCodec<FriendlyByteBuf, ClientboundModListRetrievalPacket> CODEC = CustomPacketPayload.codec(ClientboundModListRetrievalPacket::write, ClientboundModListRetrievalPacket::new);

        public ClientboundModListRetrievalPacket(FriendlyByteBuf buf) {
            this();
        }

        public void write(FriendlyByteBuf buf) {
        }

        @NotNull
        public CustomPacketPayload.Type<?> type() {
            return TYPE;
        }
    }

    public record ClientModRetrievalTask() implements ConfigurationTask
    {
        public static final ConfigurationTask.Type TYPE = new ConfigurationTask.Type(AtlasCore.id("client_mods_retrieval").toString());

        public void start(Consumer<Packet<?>> sender) {
            sender.accept(ServerConfigurationNetworking.createS2CPacket((CustomPacketPayload)new ClientboundModListRetrievalPacket()));
        }

        @NotNull
        public ConfigurationTask.Type type() {
            return TYPE;
        }
    }
}

