/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.client;

import net.atlas.atlascore.AtlasCore;
import net.atlas.atlascore.client.ScreenBuilder;
import net.atlas.atlascore.config.AtlasConfig;
import net.atlas.atlascore.config.AtlasConfigScreen;
import net.atlas.atlascore.util.ModRepresentation;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@Mod(value="atlas_core", dist={Dist.CLIENT})
@EventBusSubscriber(modid="atlas_core", value={Dist.CLIENT})
public class AtlasCoreClient {
    public AtlasCoreClient(ModContainer container) {
        ClientPlayNetworking.registerGlobalReceiver(AtlasCore.AtlasConfigPacket.TYPE, AtlasConfig::handleExtraSyncStatic);
        ClientConfigurationNetworking.registerGlobalReceiver(AtlasCore.ClientboundModListRetrievalPacket.TYPE, (packet, sender) -> sender.responseSender().sendPacket(ClientPlayNetworking.createC2SPacket((CustomPacketPayload)new AtlasCore.ServerboundClientModPacket(ModRepresentation.mapFromModContainers(FabricLoader.getInstance().getAllMods())))));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> AtlasConfig.configs.forEach((resourceLocation, atlasConfig) -> atlasConfig.reload()));
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(modContainer, screen) -> new AtlasConfigScreen(screen, Minecraft.getInstance().options, (Component)Component.translatable((String)"title.atlas_config.name"))));
    }

    @SubscribeEvent
    static void onClientSetup(FMLClientSetupEvent event) {
        for (ModContainer modContainer : ModList.get().getSortedMods()) {
            if (!AtlasConfig.menus.containsKey(modContainer.getModId())) continue;
            AtlasConfig config = AtlasConfig.menus.get(modContainer.getModId());
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(container, screen) -> ScreenBuilder.buildAtlasConfig(screen, config)));
        }
    }
}

