/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.client;

import java.io.IOException;
import java.util.List;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import net.atlas.atlascore.AtlasCore;
import net.atlas.atlascore.config.AtlasConfig;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public final class ScreenBuilder {
    private ScreenBuilder() {
    }

    public static Screen buildAtlasConfig(Screen prevScreen, AtlasConfig config) {
        List<AtlasConfig.ConfigHolder<?>> uncategorised;
        Screen special = config.createScreen(prevScreen);
        if (special != null) {
            return special;
        }
        ConfigBuilder builder = ConfigBuilder.create().setTitle((Component)Component.translatable((String)("text.config." + config.name.getPath() + ".title"))).transparentBackground().setSavingRunnable(() -> {
            try {
                config.saveConfig();
            }
            catch (IOException e) {
                AtlasCore.LOGGER.error("Failed to save " + String.valueOf(config.name) + " config file!");
                e.printStackTrace();
            }
        });
        if (prevScreen != null) {
            builder.setParentScreen(prevScreen);
        }
        if (!config.categories.isEmpty()) {
            for (AtlasConfig.Category category : config.categories) {
                ConfigCategory configCategory = builder.getOrCreateCategory((Component)Component.translatable((String)category.translationKey()));
                for (AbstractConfigListEntry<?> entry : category.membersAsCloth()) {
                    configCategory.addEntry(entry);
                }
            }
        }
        if (!(uncategorised = config.getUncategorisedHolders()).isEmpty()) {
            ConfigCategory configCategory = builder.getOrCreateCategory((Component)Component.translatable((String)"text.config.misc_category"));
            uncategorised.stream().map(holder -> {
                AbstractConfigListEntry<?> entry = holder.transformIntoConfigEntry();
                entry.setEditable(!holder.serverManaged);
                return entry;
            }).forEach(arg_0 -> ((ConfigCategory)configCategory).addEntry(arg_0));
        }
        return builder.build();
    }
}

