/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import net.atlas.atlascore.AtlasCore;
import net.atlas.atlascore.command.argument.AtlasConfigArgument;
import net.atlas.atlascore.command.argument.ConfigHolderArgument;
import net.atlas.atlascore.config.AtlasConfig;
import net.atlas.atlascore.config.ConfigHolderLike;
import net.atlas.atlascore.config.ExtendedHolder;
import net.atlas.atlascore.util.ComponentUtils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ConfigCommand {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"atlas_config").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82127_((String)"reload").executes(ConfigCommand::reloadAll))).then(Commands.m_82127_((String)"read").executes(ConfigCommand::readAll))).then(Commands.m_82127_((String)"reset").executes(ConfigCommand::resetAll))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"config", (ArgumentType)AtlasConfigArgument.context()).suggests((commandContext, suggestionsBuilder) -> AtlasConfigArgument.suggestions(commandContext, suggestionsBuilder, false)).then(Commands.m_82127_((String)"reload").executes(context -> ConfigCommand.reload((CommandContext<CommandSourceStack>)context, AtlasConfigArgument.getConfig(context, "config", false))))).then(Commands.m_82127_((String)"read").executes(context -> ConfigCommand.readConfig((CommandContext<CommandSourceStack>)context, AtlasConfigArgument.getConfig(context, "config", false))))).then(Commands.m_82127_((String)"reset").executes(context -> ConfigCommand.resetConfig((CommandContext<CommandSourceStack>)context, AtlasConfigArgument.getConfig(context, "config", false))))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"holder", (ArgumentType)ConfigHolderArgument.configHolderArgument()).suggests((commandContext, suggestionsBuilder) -> ConfigHolderArgument.suggestions(commandContext, suggestionsBuilder, "config")).then(Commands.m_82127_((String)"retrieve").executes(context -> ConfigCommand.readConfigHolder((CommandContext<CommandSourceStack>)context, AtlasConfigArgument.getConfig(context, "config", false), ConfigHolderArgument.getConfigHolder(context, "holder", "config"))))).then(Commands.m_82127_((String)"edit").then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).suggests((commandContext, suggestionsBuilder) -> ConfigHolderArgument.ConfigValueArgument.suggestions(commandContext, suggestionsBuilder, "holder", "config")).executes(context -> {
            ConfigHolderLike<?> configHolder = ConfigHolderArgument.getConfigHolder(context, "holder", "config");
            ConfigHolderArgument.ConfigValueArgument.readArgument(context, "value", configHolder);
            return ConfigCommand.updateConfigValue((CommandContext<CommandSourceStack>)context, AtlasConfigArgument.getConfig(context, "config", false), configHolder);
        })))).then(Commands.m_82127_((String)"reset").executes(context -> ConfigCommand.resetConfigValue((CommandContext<CommandSourceStack>)context, AtlasConfigArgument.getConfig(context, "config", false), ConfigHolderArgument.getConfigHolder(context, "holder", "config")))))));
    }

    private static int readAll(CommandContext<CommandSourceStack> context) {
        for (AtlasConfig config : AtlasConfig.configs.values()) {
            ConfigCommand.readConfig(context, config);
        }
        return 1;
    }

    private static int readConfig(CommandContext<CommandSourceStack> context, AtlasConfig config) {
        ConfigCommand.createConfigInformation(config, arg_0 -> ((CommandSourceStack)((CommandSourceStack)context.getSource())).m_243053_(arg_0));
        return 1;
    }

    private static int readConfigHolder(CommandContext<CommandSourceStack> context, AtlasConfig config, ConfigHolderLike<?> configHolder) {
        ((CommandSourceStack)context.getSource()).m_243053_((Component)ComponentUtils.separatorLine(config.getFormattedName().m_6881_(), true));
        if (configHolder instanceof ExtendedHolder) {
            ExtendedHolder extendedHolder = (ExtendedHolder)((Object)configHolder);
            ((CommandSourceStack)context.getSource()).m_243053_((Component)ComponentUtils.separatorLine(Component.m_237115_((String)configHolder.getAsHolder().getTranslationKey())));
            extendedHolder.fulfilListing(component -> ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)"  \u00bb ").m_7220_(component)));
        } else if (!(configHolder instanceof AtlasConfig.ConfigHolder)) {
            ((CommandSourceStack)context.getSource()).m_243053_((Component)ComponentUtils.separatorLine(Component.m_237115_((String)configHolder.getAsHolder().getTranslationKey())));
            ((ExtendedHolder)((Object)configHolder.getAsHolder())).listInner(configHolder.getName(), component -> ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)"  \u00bb ").m_7220_(component)));
        } else {
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237113_((String)"  \u00bb ").m_7220_((Component)Component.m_237115_((String)configHolder.getAsHolder().getTranslationKey())).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_(configHolder.getAsHolder().getValueAsComponent()));
        }
        ((CommandSourceStack)context.getSource()).m_243053_((Component)ComponentUtils.separatorLine(null));
        return 1;
    }

    private static int resetAll(CommandContext<CommandSourceStack> context) {
        for (AtlasConfig config : AtlasConfig.configs.values()) {
            ConfigCommand.resetConfig(context, config);
        }
        return 1;
    }

    private static int resetConfig(CommandContext<CommandSourceStack> context, AtlasConfig config) {
        config.reset();
        for (ServerPlayer player : ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_()) {
            if (!ServerPlayNetworking.canSend((ServerPlayer)player, AtlasCore.AtlasConfigPacket.TYPE)) continue;
            FriendlyByteBuf buf = PacketByteBufs.create();
            new AtlasCore.AtlasConfigPacket(true, config).write(buf);
            player.f_8906_.m_9829_(ServerPlayNetworking.createS2CPacket((ResourceLocation)AtlasCore.AtlasConfigPacket.TYPE.getId(), (FriendlyByteBuf)buf));
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> ComponentUtils.separatorLine(config.getFormattedName().m_6881_(), true), true);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"  \u00bb ").m_7220_((Component)Component.m_264642_((String)"text.config.reset_config", (String)"The values for config %s were reset successfully, please note some changes may still not take effect without a restart.", (Object[])new Object[]{config.getFormattedName()})), true);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> ComponentUtils.separatorLine(null), true);
        return 1;
    }

    private static <T> int resetConfigValue(CommandContext<CommandSourceStack> context, AtlasConfig config, ConfigHolderLike<T> configHolder) {
        configHolder.resetValue();
        try {
            config.saveConfig();
        }
        catch (IOException e) {
            return 0;
        }
        for (ServerPlayer player : ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_()) {
            if (!ServerPlayNetworking.canSend((ServerPlayer)player, AtlasCore.AtlasConfigPacket.TYPE)) continue;
            FriendlyByteBuf buf = PacketByteBufs.create();
            new AtlasCore.AtlasConfigPacket(true, config).write(buf);
            player.f_8906_.m_9829_(ServerPlayNetworking.createS2CPacket((ResourceLocation)AtlasCore.AtlasConfigPacket.TYPE.getId(), (FriendlyByteBuf)buf));
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> ComponentUtils.separatorLine(config.getFormattedName().m_6881_(), true), true);
        if (!(configHolder instanceof AtlasConfig.ConfigHolder)) {
            if (configHolder.getAsHolder().restartRequired.restartRequiredOn(FMLEnvironment.dist)) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"  \u00bb ").m_7220_((Component)Component.m_264642_((String)"text.config.holder_requires_restart", (String)"The value for %s has been saved as %s successfully, however changes will not take effect without a restart.", (Object[])new Object[]{((ExtendedHolder)((Object)configHolder.getAsHolder())).getInnerTranslation(configHolder.getName()), ((ExtendedHolder)((Object)configHolder.getAsHolder())).getInnerValue(configHolder.getName())})), true);
            } else {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"  \u00bb ").m_7220_((Component)Component.m_264642_((String)"text.config.reset_holder", (String)"The value for config holder %s was reset successfully.", (Object[])new Object[]{((ExtendedHolder)((Object)configHolder.getAsHolder())).getInnerTranslation(configHolder.getName())})), true);
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> ComponentUtils.separatorLine(null), true);
            return 1;
        }
        if (configHolder.getAsHolder().restartRequired.restartRequiredOn(FMLEnvironment.dist)) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"  \u00bb ").m_7220_((Component)Component.m_264642_((String)"text.config.holder_requires_restart", (String)"The value for %s has been saved as %s successfully, however changes will not take effect without a restart.", (Object[])new Object[]{Component.m_237115_((String)configHolder.getAsHolder().getTranslationKey()), configHolder.getAsHolder().getValueAsComponent()})), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"  \u00bb ").m_7220_((Component)Component.m_264642_((String)"text.config.reset_holder", (String)"The value for config holder %s was reset successfully.", (Object[])new Object[]{Component.m_237115_((String)configHolder.getAsHolder().getTranslationKey())})), true);
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> ComponentUtils.separatorLine(null), true);
        return 1;
    }

    private static <T> int updateConfigValue(CommandContext<CommandSourceStack> context, AtlasConfig config, ConfigHolderLike<T> configHolder) {
        if (configHolder instanceof ExtendedHolder) {
            ExtendedHolder extendedHolder = (ExtendedHolder)((Object)configHolder);
            if (extendedHolder.getUnsetInners().isEmpty()) {
                return extendedHolder.postUpdate((CommandSourceStack)context.getSource());
            }
            int ret = 1;
            for (ConfigHolderLike<?> inner : extendedHolder.getUnsetInners()) {
                ret &= ConfigCommand.updateConfigValue(context, config, inner);
            }
            return ret;
        }
        configHolder.setToParsedValue();
        try {
            config.saveConfig();
        }
        catch (IOException e) {
            return 0;
        }
        for (ServerPlayer player : ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_()) {
            if (!ServerPlayNetworking.canSend((ServerPlayer)player, AtlasCore.AtlasConfigPacket.TYPE)) continue;
            FriendlyByteBuf buf = PacketByteBufs.create();
            new AtlasCore.AtlasConfigPacket(true, config).write(buf);
            player.f_8906_.m_9829_(ServerPlayNetworking.createS2CPacket((ResourceLocation)AtlasCore.AtlasConfigPacket.TYPE.getId(), (FriendlyByteBuf)buf));
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> ComponentUtils.separatorLine(config.getFormattedName().m_6881_(), true), true);
        if (!(configHolder instanceof AtlasConfig.ConfigHolder)) {
            if (configHolder.getAsHolder().restartRequired.restartRequiredOn(FMLEnvironment.dist)) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"  \u00bb ").m_7220_((Component)Component.m_264642_((String)"text.config.holder_requires_restart", (String)"The value for %s has been saved as %s successfully, however changes will not take effect without a restart.", (Object[])new Object[]{((ExtendedHolder)((Object)configHolder.getAsHolder())).getInnerTranslation(configHolder.getName()), ((ExtendedHolder)((Object)configHolder.getAsHolder())).getInnerValue(configHolder.getName())})), true);
            } else {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"  \u00bb ").m_7220_((Component)Component.m_264642_((String)"text.config.update_holder", (String)"The value for config holder %s was set to %s successfully.", (Object[])new Object[]{((ExtendedHolder)((Object)configHolder.getAsHolder())).getInnerTranslation(configHolder.getName()), ((ExtendedHolder)((Object)configHolder.getAsHolder())).getInnerValue(configHolder.getName())})), true);
            }
        } else if (configHolder.getAsHolder().restartRequired.restartRequiredOn(FMLEnvironment.dist)) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"  \u00bb ").m_7220_((Component)Component.m_264642_((String)"text.config.holder_requires_restart", (String)"The value for %s has been saved as %s successfully, however changes will not take effect without a restart.", (Object[])new Object[]{Component.m_237115_((String)configHolder.getAsHolder().getTranslationKey()), configHolder.getAsHolder().getValueAsComponent()})), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"  \u00bb ").m_7220_((Component)Component.m_264642_((String)"text.config.update_holder", (String)"The value for config holder %s was set to %s successfully.", (Object[])new Object[]{Component.m_237115_((String)configHolder.getAsHolder().getTranslationKey()), configHolder.getAsHolder().getValueAsComponent()})), true);
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> ComponentUtils.separatorLine(null), true);
        return 1;
    }

    private static void createConfigInformation(AtlasConfig config, Consumer<Component> sender) {
        List<AtlasConfig.ConfigHolder<?>> uncategorised;
        sender.accept((Component)ComponentUtils.separatorLine(config.getFormattedName().m_6881_(), true));
        if (!config.categories.isEmpty()) {
            for (AtlasConfig.Category category : config.categories) {
                sender.accept((Component)ComponentUtils.separatorLine(Component.m_237115_((String)category.translationKey())));
                for (AtlasConfig.ConfigHolder<?> configHolder : category.members()) {
                    if (configHolder instanceof ExtendedHolder) {
                        ExtendedHolder extendedHolder = (ExtendedHolder)((Object)configHolder);
                        sender.accept((Component)ComponentUtils.separatorLine(configHolder.getValueAsComponent().m_6881_()));
                        extendedHolder.fulfilListing(component -> sender.accept((Component)Component.m_237113_((String)"  \u00bb ").m_7220_(component)));
                        sender.accept((Component)ComponentUtils.separatorLine(null));
                        continue;
                    }
                    sender.accept((Component)Component.m_237113_((String)"  \u00bb ").m_7220_((Component)Component.m_237115_((String)configHolder.getTranslationKey())).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_(configHolder.getValueAsComponent()));
                }
            }
        }
        if (!(uncategorised = config.getUncategorisedHolders()).isEmpty()) {
            if (!config.categories.isEmpty()) {
                sender.accept((Component)ComponentUtils.separatorLine(Component.m_237115_((String)"text.config.misc_category")));
            }
            for (AtlasConfig.ConfigHolder<?> configHolder : config.getUncategorisedHolders()) {
                if (configHolder instanceof ExtendedHolder) {
                    ExtendedHolder extendedHolder = (ExtendedHolder)((Object)configHolder);
                    sender.accept((Component)ComponentUtils.separatorLine(configHolder.getValueAsComponent().m_6881_()));
                    extendedHolder.fulfilListing(component -> sender.accept((Component)Component.m_237113_((String)"  \u00bb ").m_7220_(component)));
                    sender.accept((Component)ComponentUtils.separatorLine(null));
                    continue;
                }
                sender.accept((Component)Component.m_237113_((String)"  \u00bb ").m_7220_((Component)Component.m_237115_((String)configHolder.getTranslationKey())).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_(configHolder.getValueAsComponent()));
            }
        }
        sender.accept((Component)ComponentUtils.separatorLine(null));
    }

    private static int reloadAll(CommandContext<CommandSourceStack> context) {
        for (AtlasConfig config : AtlasConfig.configs.values()) {
            config.reload();
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.config.reload_all.success"), true);
        return 1;
    }

    private static int reload(CommandContext<CommandSourceStack> context, AtlasConfig config) {
        config.reload();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.config.reload.success"), true);
        return 1;
    }
}

