/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.config;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListEntry;
import net.atlas.atlascore.AtlasCore;
import net.atlas.atlascore.backport.StreamCodec;
import net.atlas.atlascore.config.AtlasConfig;
import net.atlas.atlascore.util.ConfigRepresentable;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class AtlasCoreConfig
extends AtlasConfig {
    public AtlasConfig.ObjectHolder<TestClass> testObject;
    public AtlasConfig.EnumHolder<TestEnum> testEnum;
    public AtlasConfig.StringHolder testString;
    public AtlasConfig.BooleanHolder testBool;
    public AtlasConfig.IntegerHolder testInt;
    public AtlasConfig.DoubleHolder testDouble;
    public AtlasConfig.ColorHolder configNameDisplayColour;
    public AtlasConfig.ColorHolder grayFormattingColour;
    public AtlasConfig.BooleanHolder listClientModsOnJoin;
    private AtlasConfig.Category test;
    private AtlasConfig.Category formatting;
    private AtlasConfig.Category debug;

    public AtlasCoreConfig() {
        super(AtlasCore.id("atlas-core-config"));
    }

    @Override
    public void defineConfigHolders() {
        this.testObject = this.createObject("testObject", new TestClass(this.testObject, "bar", true, 3, 7.0), TestClass.class, TestClass.STREAM_CODEC);
        this.testObject.tieToCategory(this.test);
        this.testEnum = this.createEnum("testEnum", TestEnum.FOO, TestEnum.class, TestEnum.values(), e -> Component.m_237115_((String)("text.config.atlas-core-config.option.testEnum." + e.name().toLowerCase(Locale.ROOT))));
        this.testEnum.tieToCategory(this.test);
        this.testString = this.createString("testString", "foo");
        this.testString.tieToCategory(this.test);
        this.testBool = this.createBoolean("testBool", true);
        this.testBool.tieToCategory(this.test);
        this.testInt = this.createInRestrictedValues("testInt", (Integer)1, 1, 3, 5, 7, 9);
        this.testInt.tieToCategory(this.test);
        this.testDouble = this.createDoubleUnbound("testDouble", 0.0);
        this.testDouble.tieToCategory(this.test);
        this.configNameDisplayColour = this.createColor("configNameDisplayColour", 57343, false);
        this.configNameDisplayColour.tieToCategory(this.formatting);
        this.grayFormattingColour = this.createColor("grayFormattingColour", 12502994, false);
        this.grayFormattingColour.tieToCategory(this.formatting);
        this.listClientModsOnJoin = this.createBoolean("listClientModsOnJoin", false);
        this.listClientModsOnJoin.tieToCategory(this.debug);
    }

    @Override
    @NotNull
    public List<AtlasConfig.Category> createCategories() {
        List<AtlasConfig.Category> categoryList = super.createCategories();
        this.test = new AtlasConfig.Category(this, "test_options", new ArrayList());
        this.formatting = new AtlasConfig.Category(this, "text_formatting", new ArrayList());
        this.debug = new AtlasConfig.Category(this, "debug_options", new ArrayList());
        categoryList.add(this.formatting);
        categoryList.add(this.debug);
        categoryList.add(this.test);
        return categoryList;
    }

    @Override
    public Component getFormattedName() {
        return Component.m_264568_((String)("text.config." + this.name.m_135815_() + ".title"), (String)"Atlas Core").m_130948_(Style.f_131099_.m_178520_(((Integer)this.configNameDisplayColour.get()).intValue()));
    }

    @Override
    public void resetExtraHolders() {
    }

    @Override
    public <T> void alertChange(AtlasConfig.ConfigValue<T> tConfigValue, T newValue) {
    }

    @Override
    public <T> void alertClientValue(AtlasConfig.ConfigValue<T> tConfigValue, T serverValue, T clientValue) {
    }

    @Override
    protected void loadExtra(JsonObject jsonObject) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleExtraSync(AtlasCore.AtlasConfigPacket packet, LocalPlayer player, PacketSender responseSender) {
    }

    @Override
    public void handleConfigInformation(AtlasCore.ClientInformPacket packet, ServerPlayer player, PacketSender sender) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Screen createScreen(Screen prevScreen) {
        return null;
    }

    public static class TestClass
    implements ConfigRepresentable<TestClass> {
        public static final StreamCodec<FriendlyByteBuf, TestClass> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, TestClass>(){

            @Override
            public void encode(FriendlyByteBuf FriendlyByteBuf2, TestClass testClass) {
                FriendlyByteBuf2.m_130085_(testClass.owner.heldValue.owner().name);
                FriendlyByteBuf2.m_130070_(testClass.owner.heldValue.name());
                FriendlyByteBuf2.m_130070_(testClass.innerString);
                FriendlyByteBuf2.writeBoolean(testClass.innerBool.booleanValue());
                FriendlyByteBuf2.m_130130_(testClass.innerInt.intValue());
                FriendlyByteBuf2.writeDouble(testClass.innerDouble.doubleValue());
            }

            @Override
            @NotNull
            public TestClass decode(FriendlyByteBuf FriendlyByteBuf2) {
                AtlasConfig config = AtlasConfig.configs.get(FriendlyByteBuf2.m_130281_());
                return new TestClass(config.valueNameToConfigHolderMap.get(FriendlyByteBuf2.m_130277_()), FriendlyByteBuf2.m_130277_(), FriendlyByteBuf2.readBoolean(), FriendlyByteBuf2.m_130242_(), FriendlyByteBuf2.readDouble());
            }
        };
        public AtlasConfig.ConfigHolder<TestClass> owner;
        public String innerString;
        public Boolean innerBool;
        public Integer innerInt;
        public Double innerDouble;
        public static final Map<String, Field> fields = (Map)Util.m_137469_(new HashMap(), hashMap -> {
            try {
                hashMap.put("innerString", TestClass.class.getDeclaredField("innerString"));
                hashMap.put("innerBool", TestClass.class.getDeclaredField("innerBool"));
                hashMap.put("innerInt", TestClass.class.getDeclaredField("innerInt"));
                hashMap.put("innerDouble", TestClass.class.getDeclaredField("innerDouble"));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        });
        public static final BiFunction<TestClass, String, Component> convertFieldToComponent = (testClass, string) -> {
            try {
                return Component.m_237115_((String)(testClass.owner.getTranslationKey() + "." + string)).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237113_((String)String.valueOf(testClass.fieldRepresentingHolder((String)string).get(testClass))));
            }
            catch (IllegalAccessException illegalAccessException) {
                return Component.m_237115_((String)(testClass.owner.getTranslationKey() + "." + string));
            }
        };
        public static final BiFunction<TestClass, String, Component> convertFieldToNameComponent = (testClass, string) -> Component.m_237115_((String)(testClass.owner.getTranslationKey() + "." + string));
        public static final BiFunction<TestClass, String, Component> convertFieldToValueComponent = (testClass, string) -> {
            try {
                return Component.m_237113_((String)String.valueOf(testClass.fieldRepresentingHolder((String)string).get(testClass)));
            }
            catch (IllegalAccessException illegalAccessException) {
                return Component.m_237115_((String)(testClass.owner.getTranslationKey() + "." + string));
            }
        };
        public Supplier<Component> resetTranslation = null;

        public String innerString() {
            return this.innerString;
        }

        public Boolean innerBool() {
            return this.innerBool;
        }

        public Integer innerInt() {
            return this.innerInt;
        }

        public Double innerDouble() {
            return this.innerDouble;
        }

        public TestClass(AtlasConfig.ConfigHolder<TestClass> owner, String innerString, Boolean innerBool, Integer innerInt, Double innerDouble) {
            this.owner = owner;
            this.innerString = innerString;
            this.innerBool = innerBool;
            this.innerInt = innerInt;
            this.innerDouble = innerDouble;
        }

        @Override
        public Codec<TestClass> getCodec(AtlasConfig.ConfigHolder<TestClass> owner) {
            return RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("innerString", (Object)"bar").forGetter(TestClass::innerString), (App)Codec.BOOL.optionalFieldOf("innerBool", (Object)true).forGetter(TestClass::innerBool), (App)Codec.INT.optionalFieldOf("innerInt", (Object)3).forGetter(TestClass::innerInt), (App)Codec.DOUBLE.optionalFieldOf("innerDouble", (Object)7.0).forGetter(TestClass::innerDouble)).apply((Applicative)instance, (innerString, innerBool, innerInt, innerDouble) -> new TestClass(owner, (String)innerString, (Boolean)innerBool, (Integer)innerInt, (Double)innerDouble)));
        }

        @Override
        public void setOwnerHolder(AtlasConfig.ConfigHolder<TestClass> configHolder) {
            this.owner = configHolder;
        }

        @Override
        public List<String> fields() {
            return fields.keySet().stream().toList();
        }

        @Override
        public Component getFieldValue(String name) {
            return convertFieldToValueComponent.apply(this, name);
        }

        @Override
        public Component getFieldName(String name) {
            return convertFieldToNameComponent.apply(this, name);
        }

        @Override
        public void listField(String name, Consumer<Component> input) {
            input.accept(convertFieldToComponent.apply(this, name));
        }

        @Override
        public void listFields(Consumer<Component> input) {
            fields.keySet().forEach(string -> input.accept(convertFieldToComponent.apply(this, (String)string)));
        }

        @Override
        public Field fieldRepresentingHolder(String name) {
            return fields.get(name);
        }

        @Override
        public ArgumentType<?> argumentTypeRepresentingHolder(String name) {
            try {
                Object object = fields.get(name).get(this);
                if (object instanceof String) {
                    return StringArgumentType.greedyString();
                }
                if (object instanceof Boolean) {
                    return BoolArgumentType.bool();
                }
                if (object instanceof Integer) {
                    return IntegerArgumentType.integer();
                }
                if (object instanceof Double) {
                    return DoubleArgumentType.doubleArg();
                }
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public List<AbstractConfigListEntry<?>> transformIntoConfigEntries() {
            if (this.resetTranslation == null) {
                this.resetTranslation = () -> Component.m_237115_((String)this.owner.getTranslationResetKey());
            }
            ArrayList entries = new ArrayList();
            entries.add((AbstractConfigListEntry<?>)new StringListEntry(convertFieldToNameComponent.apply(this, "innerString"), this.innerString, this.resetTranslation.get(), () -> "bar", string -> {
                this.innerString = string;
            }, Optional::empty, false));
            entries.add((AbstractConfigListEntry<?>)new BooleanListEntry(convertFieldToNameComponent.apply(this, "innerBool"), this.innerBool.booleanValue(), this.resetTranslation.get(), () -> true, bool -> {
                this.innerBool = bool;
            }, Optional::empty, false));
            entries.add((AbstractConfigListEntry<?>)new IntegerListEntry(convertFieldToNameComponent.apply(this, "innerInt"), this.innerInt, this.resetTranslation.get(), () -> 3, integer -> {
                this.innerInt = integer;
            }, Optional::empty, false));
            entries.add((AbstractConfigListEntry<?>)new DoubleListEntry(convertFieldToNameComponent.apply(this, "innerDouble"), this.innerDouble, this.resetTranslation.get(), () -> 7.0, aDouble -> {
                this.innerDouble = aDouble;
            }, Optional::empty, false));
            return entries;
        }
    }

    public static enum TestEnum {
        FOO,
        BAR;

    }
}

