/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Collection;
import java.util.Comparator;
import net.atlas.atlascore.command.ConfigCommand;
import net.atlas.atlascore.config.AtlasConfig;
import net.atlas.atlascore.config.AtlasCoreConfig;
import net.atlas.atlascore.config.ContextBasedConfig;
import net.atlas.atlascore.util.Context;
import net.atlas.atlascore.util.ModRepresentation;
import net.atlas.atlascore.util.NetworkingUtilities;
import net.atlas.atlascore.util.PrefixLogger;
import net.atlas.atlascore.util.ServerModsRetrievedEvent;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;

public class AtlasCore
implements ModInitializer {
    public static final String MOD_ID = "atlas-core";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final PrefixLogger LOGGER = new PrefixLogger(LogManager.getLogger((String)"Atlas Core"));
    public static AtlasCoreConfig CONFIG;
    public static class_2960 modDetectionNetworkChannel;

    public void onInitialize() {
        CONFIG = new AtlasCoreConfig();
        ServerPlayConnectionEvents.JOIN.register(modDetectionNetworkChannel, (handler, sender, server) -> {
            for (AtlasConfig atlasConfig2 : AtlasConfig.configs.values().stream().filter(atlasConfig -> atlasConfig.configSide.isCommon()).toList()) {
                if (atlasConfig2 instanceof ContextBasedConfig) {
                    ContextBasedConfig contextBasedConfig = (ContextBasedConfig)atlasConfig2;
                    atlasConfig2 = contextBasedConfig.getConfig(Context.builder().applyInformationFromEntity((class_1297)handler.field_14140).build());
                }
                ServerPlayNetworking.send((class_3222)handler.field_14140, (FabricPacket)new AtlasConfigPacket(false, atlasConfig2));
            }
            LOGGER.info("Config packets sent to client.");
        });
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register(modDetectionNetworkChannel, (player, origin, destination) -> {
            for (ContextBasedConfig contextBasedConfig : AtlasConfig.configs.values().stream().filter(atlasConfig -> atlasConfig.configSide.isCommon() && atlasConfig instanceof ContextBasedConfig).map(config -> ((ContextBasedConfig)config).getConfig(Context.builder().applyInformationFromLevel((class_1937)destination).build())).toList()) {
                ServerPlayNetworking.send((class_3222)player, (FabricPacket)new AtlasConfigPacket(false, contextBasedConfig));
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(ServerboundClientModPacket.TYPE, (payload, player, responseSender) -> ((ServerModsRetrievedEvent.RetrieveMods)ServerModsRetrievedEvent.RETRIEVAL.invoker()).onModsReceived(player.field_13987, responseSender, payload.modRepresentations()));
        ServerPlayNetworking.registerGlobalReceiver(ClientInformPacket.TYPE, (packet, player, responseSender) -> packet.config().handleConfigInformation((ClientInformPacket)packet, player, responseSender));
        ServerModsRetrievedEvent.RETRIEVAL.register((handler, sender, mods) -> {
            if (((Boolean)AtlasCore.CONFIG.listClientModsOnJoin.get()).booleanValue()) {
                String[] list = new String[]{"Client mods: \n"};
                mods.stream().sorted(Comparator.comparing(ModRepresentation::modID)).forEach(modRepresentation -> modRepresentation.list(string -> {
                    list[0] = list[0] + string + "\n";
                }, ModRepresentation::modID, "\t\u00bb | "));
                LOGGER.info(list[0].substring(0, list[0].length() - 1));
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> ConfigCommand.register((CommandDispatcher<class_2168>)dispatcher));
    }

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    static {
        modDetectionNetworkChannel = AtlasCore.id("networking");
    }

    public record ServerboundClientModPacket(Collection<ModRepresentation> modRepresentations) implements FabricPacket
    {
        public static final PacketType<ServerboundClientModPacket> TYPE = PacketType.create((class_2960)AtlasCore.id("client_mods"), ServerboundClientModPacket::new);

        public ServerboundClientModPacket(class_2540 buf) {
            this(NetworkingUtilities.modsFromNetwork(buf));
        }

        public void write(class_2540 buf) {
            NetworkingUtilities.modsToNetwork(buf, this.modRepresentations);
        }

        @NotNull
        public PacketType<?> getType() {
            return TYPE;
        }
    }

    public record ClientInformPacket(AtlasConfig config) implements FabricPacket
    {
        public static final PacketType<ClientInformPacket> TYPE = PacketType.create((class_2960)AtlasCore.id("c2s_inform_config"), ClientInformPacket::new);

        public ClientInformPacket(class_2540 buf) {
            this(AtlasConfig.staticReadClientConfigInformation(buf));
        }

        public void write(class_2540 buf) {
            buf.method_10812(this.config.name);
            this.config.saveToNetwork(buf);
        }

        @NotNull
        public PacketType<? extends FabricPacket> getType() {
            return TYPE;
        }
    }

    public record AtlasConfigPacket(boolean forCommand, AtlasConfig config) implements FabricPacket
    {
        public static final PacketType<AtlasConfigPacket> TYPE = PacketType.create((class_2960)AtlasCore.id("atlas_config"), AtlasConfigPacket::new);

        public AtlasConfigPacket(class_2540 buf) {
            this(buf.readBoolean(), AtlasConfig.staticLoadFromNetwork(buf));
        }

        public void write(class_2540 buf) {
            buf.writeBoolean(this.forCommand);
            buf.method_10812(this.config.name);
            this.config.saveToNetwork(buf);
        }

        @NotNull
        public PacketType<? extends FabricPacket> getType() {
            return TYPE;
        }
    }

    public record ClientboundModListRetrievalPacket() implements FabricPacket
    {
        public static final PacketType<ClientboundModListRetrievalPacket> TYPE = PacketType.create((class_2960)AtlasCore.id("client_mods_retrieval"), ClientboundModListRetrievalPacket::new);

        public ClientboundModListRetrievalPacket(class_2540 buf) {
            this();
        }

        public void write(class_2540 buf) {
        }

        @NotNull
        public PacketType<?> getType() {
            return TYPE;
        }
    }
}

