/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import net.atlas.atlascore.backport.StreamCodec;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.class_2540;

public record ModRepresentation(String name, String modID, Collection<ModRepresentation> provided, Version version) {
    public static final Version UNKNOWN;
    public static final StreamCodec<class_2540, ModRepresentation> CODEC;

    public static ModRepresentation readFromBuf(class_2540 buf) {
        Version version;
        String name = buf.method_19772();
        String modID = buf.method_19772();
        int providedSize = buf.method_10816();
        ArrayList<ModRepresentation> provided = new ArrayList<ModRepresentation>();
        for (int i = 0; i < providedSize; ++i) {
            provided.add(ModRepresentation.readFromBuf(buf));
        }
        try {
            version = Version.parse((String)buf.method_19772());
        }
        catch (VersionParsingException e) {
            version = UNKNOWN;
        }
        return new ModRepresentation(name, modID, Collections.unmodifiableList(provided), version);
    }

    public static void writeToBuf(class_2540 buf, ModRepresentation modRepresentation) {
        buf.method_10814(modRepresentation.name());
        buf.method_10814(modRepresentation.modID());
        buf.method_10804(modRepresentation.provided().size());
        for (ModRepresentation str : modRepresentation.provided()) {
            ModRepresentation.writeToBuf(buf, str);
        }
        buf.method_10814(modRepresentation.version().getFriendlyString());
    }

    public static Collection<ModRepresentation> mapFromModContainers(Collection<ModContainer> mods) {
        return mods.stream().map(modContainer -> {
            if (modContainer.getContainedMods().isEmpty()) {
                return new ModRepresentation(modContainer.getMetadata().getName(), modContainer.getMetadata().getId(), Collections.emptyList(), modContainer.getMetadata().getVersion());
            }
            return new ModRepresentation(modContainer.getMetadata().getName(), modContainer.getMetadata().getId(), ModRepresentation.mapFromModContainers(modContainer.getContainedMods()), modContainer.getMetadata().getVersion());
        }).toList();
    }

    public void list(Consumer<String> stringConsumer, Function<ModRepresentation, String> name, String prefix) {
        stringConsumer.accept(prefix + name.apply(this) + ": " + String.valueOf(this.version()));
        if (!this.provided.isEmpty()) {
            this.provided.stream().sorted(Comparator.comparing(name)).forEach(modRepresentation -> modRepresentation.list(string -> stringConsumer.accept("  " + string), name, prefix));
        }
    }

    static {
        try {
            UNKNOWN = Version.parse((String)"1.0.0-UNKNOWN");
        }
        catch (VersionParsingException e) {
            throw new RuntimeException(e);
        }
        CODEC = StreamCodec.of(ModRepresentation::writeToBuf, ModRepresentation::readFromBuf);
    }
}

