/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.util;

import org.apache.logging.log4j.Logger;

public class PrefixLogger {
    private static final String LOG_FORMAT = "[{}] {}";
    private final Logger logger;
    private final String prefix;

    public PrefixLogger(Logger logger) {
        this.logger = logger;
        this.prefix = logger.getName();
    }

    public void info(String message) {
        this.logger.info(LOG_FORMAT, (Object)this.prefix, (Object)message);
    }

    public void error(String message) {
        this.logger.error(LOG_FORMAT, (Object)this.prefix, (Object)message);
    }

    public void error(String message, Throwable throwable) {
        this.logger.error(LOG_FORMAT, (Object)this.prefix, (Object)message, (Object)throwable);
    }

    public void warn(String message) {
        this.logger.warn(LOG_FORMAT, (Object)this.prefix, (Object)message);
    }

    public Logger unwrap() {
        return this.logger;
    }
}

