/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Consumer;
import net.atlas.atlascore.command.ConfigCommand;
import net.atlas.atlascore.config.AtlasConfig;
import net.atlas.atlascore.config.AtlasCoreConfig;
import net.atlas.atlascore.config.ContextBasedConfig;
import net.atlas.atlascore.init.ArgumentInit;
import net.atlas.atlascore.util.Context;
import net.atlas.atlascore.util.ModRepresentation;
import net.atlas.atlascore.util.NetworkingUtilities;
import net.atlas.atlascore.util.PrefixLogger;
import net.atlas.atlascore.util.ServerModsRetrievedEvent;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6857;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;

public class AtlasCore
implements ModInitializer {
    public static final String MOD_ID = "atlas-core";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final PrefixLogger LOGGER = new PrefixLogger(LogManager.getLogger((String)"Atlas Core"));
    public static AtlasCoreConfig CONFIG;
    public static class_2960 modDetectionNetworkChannel;

    public void onInitialize() {
        CONFIG = new AtlasCoreConfig();
        PayloadTypeRegistry.playS2C().register(AtlasConfigPacket.TYPE, AtlasConfigPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(ClientInformPacket.TYPE, ClientInformPacket.CODEC);
        PayloadTypeRegistry.configurationC2S().register(ServerboundClientModPacket.TYPE, ServerboundClientModPacket.CODEC);
        PayloadTypeRegistry.configurationS2C().register(ClientboundModListRetrievalPacket.TYPE, ClientboundModListRetrievalPacket.CODEC);
        ServerPlayConnectionEvents.JOIN.register(modDetectionNetworkChannel, (handler, sender, server) -> {
            for (AtlasConfig atlasConfig2 : AtlasConfig.configs.values().stream().filter(atlasConfig -> !atlasConfig.configSide.isCommon()).toList()) {
                if (atlasConfig2 instanceof ContextBasedConfig) {
                    ContextBasedConfig contextBasedConfig = (ContextBasedConfig)atlasConfig2;
                    atlasConfig2 = contextBasedConfig.getConfig(Context.builder().applyInformationFromEntity((class_1297)handler.field_14140).build());
                }
                ServerPlayNetworking.send((class_3222)handler.field_14140, (class_8710)new AtlasConfigPacket(false, atlasConfig2));
            }
            LOGGER.info("Config packets sent to client.");
        });
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register(modDetectionNetworkChannel, (player, origin, destination) -> {
            for (ContextBasedConfig contextBasedConfig : AtlasConfig.configs.values().stream().filter(atlasConfig -> !atlasConfig.configSide.isCommon() && atlasConfig instanceof ContextBasedConfig).map(config -> ((ContextBasedConfig)config).getConfig(Context.builder().applyInformationFromLevel((class_1937)destination).build())).toList()) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new AtlasConfigPacket(false, contextBasedConfig));
            }
        });
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, ClientboundModListRetrievalPacket.TYPE)) {
                handler.addTask((class_8605)new ClientModRetrievalTask());
            }
        });
        ServerConfigurationNetworking.registerGlobalReceiver(ServerboundClientModPacket.TYPE, (payload, context) -> {
            ((ServerModsRetrievedEvent.RetrieveMods)ServerModsRetrievedEvent.RETRIEVAL.invoker()).onModsReceived((class_6857)context.networkHandler(), context.responseSender(), payload.modRepresentations());
            context.networkHandler().completeTask(ClientModRetrievalTask.TYPE);
        });
        ServerPlayNetworking.registerGlobalReceiver(ClientInformPacket.TYPE, (packet, context) -> packet.config().handleConfigInformation((ClientInformPacket)packet, context.player(), context.responseSender()));
        ArgumentInit.registerArguments();
        ServerModsRetrievedEvent.RETRIEVAL.register((handler, sender, mods) -> {
            if (((Boolean)AtlasCore.CONFIG.listClientModsOnJoin.get()).booleanValue()) {
                String[] list = new String[]{"Client mods: \n"};
                mods.stream().sorted(Comparator.comparing(ModRepresentation::modID)).forEach(modRepresentation -> modRepresentation.list(string -> {
                    list[0] = list[0] + string + "\n";
                }, ModRepresentation::modID, "\t\u00bb | "));
                LOGGER.info(list[0].substring(0, list[0].length() - 1));
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> ConfigCommand.register((CommandDispatcher<class_2168>)dispatcher));
    }

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    static {
        modDetectionNetworkChannel = AtlasCore.id("networking");
    }

    public record AtlasConfigPacket(boolean forCommand, AtlasConfig config) implements class_8710
    {
        public static final class_8710.class_9154<AtlasConfigPacket> TYPE = new class_8710.class_9154(AtlasCore.id("atlas_config"));
        public static final class_9139<class_9129, AtlasConfigPacket> CODEC = class_8710.method_56484(AtlasConfigPacket::write, AtlasConfigPacket::new);

        public AtlasConfigPacket(class_9129 buf) {
            this(buf.readBoolean(), AtlasConfig.staticLoadFromNetwork(buf));
        }

        public void write(class_9129 buf) {
            buf.method_52964(this.forCommand);
            buf.method_10812(this.config.name);
            this.config.saveToNetwork(buf);
        }

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record ClientInformPacket(AtlasConfig config) implements class_8710
    {
        public static final class_8710.class_9154<ClientInformPacket> TYPE = new class_8710.class_9154(AtlasCore.id("c2s_inform_config"));
        public static final class_9139<class_9129, ClientInformPacket> CODEC = class_8710.method_56484(ClientInformPacket::write, ClientInformPacket::new);

        public ClientInformPacket(class_9129 buf) {
            this(AtlasConfig.staticReadClientConfigInformation(buf));
        }

        public void write(class_9129 buf) {
            buf.method_10812(this.config.name);
            this.config.saveToNetwork(buf);
        }

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record ServerboundClientModPacket(Collection<ModRepresentation> modRepresentations) implements class_8710
    {
        public static final class_8710.class_9154<ServerboundClientModPacket> TYPE = new class_8710.class_9154(AtlasCore.id("client_mods"));
        public static final class_9139<class_2540, ServerboundClientModPacket> CODEC = class_8710.method_56484(ServerboundClientModPacket::write, ServerboundClientModPacket::new);

        public ServerboundClientModPacket(class_2540 buf) {
            this(NetworkingUtilities.modsFromNetwork(buf));
        }

        public void write(class_2540 buf) {
            NetworkingUtilities.modsToNetwork(buf, this.modRepresentations);
        }

        @NotNull
        public class_8710.class_9154<?> method_56479() {
            return TYPE;
        }
    }

    public record ClientboundModListRetrievalPacket() implements class_8710
    {
        public static final class_8710.class_9154<ClientboundModListRetrievalPacket> TYPE = new class_8710.class_9154(AtlasCore.id("client_mods_retrieval"));
        public static final class_9139<class_2540, ClientboundModListRetrievalPacket> CODEC = class_8710.method_56484(ClientboundModListRetrievalPacket::write, ClientboundModListRetrievalPacket::new);

        public ClientboundModListRetrievalPacket(class_2540 buf) {
            this();
        }

        public void write(class_2540 buf) {
        }

        @NotNull
        public class_8710.class_9154<?> method_56479() {
            return TYPE;
        }
    }

    public record ClientModRetrievalTask() implements class_8605
    {
        public static final class_8605.class_8606 TYPE = new class_8605.class_8606(AtlasCore.id("client_mods_retrieval").toString());

        public void method_52376(Consumer<class_2596<?>> sender) {
            sender.accept(ServerConfigurationNetworking.createS2CPacket((class_8710)new ClientboundModListRetrievalPacket()));
        }

        @NotNull
        public class_8605.class_8606 method_52375() {
            return TYPE;
        }
    }
}

