/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.command.argument;

import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.atlas.atlascore.command.argument.OptsArgument;
import net.atlas.atlascore.extensions.CommandContextExtensions;

public record Argument<T>(String name, T data, Class<T> clazz) {
    public static <S> Arguments argumentMap(CommandContext<S> context, String[] trueArguments) {
        ArrayList arguments = new ArrayList();
        for (String argument : trueArguments) {
            if (!((CommandContextExtensions)context).hasArgument(argument)) continue;
            Argument<?> arg = OptsArgument.getArgument(context, argument);
            arguments.add(arg);
        }
        return new Arguments(arguments);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Argument)) {
            return false;
        }
        Argument argument = (Argument)o;
        return Objects.equals(this.name, argument.name) && Objects.equals(this.data, argument.data) && Objects.equals(this.clazz, argument.clazz);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.data, this.clazz);
    }

    public record Arguments(List<Argument<?>> arguments) {
        private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER = new HashMap();

        public Argument<?> get(String name) {
            return this.arguments.stream().filter(argument -> argument.name.hashCode() == name.hashCode()).findFirst().orElse(null);
        }

        public <V> V getArgument(String name, Class<V> clazz) {
            Argument<?> argument = this.get(name);
            if (argument == null) {
                throw new IllegalArgumentException("No such argument '" + name + "' exists on this command");
            }
            if (!PRIMITIVE_TO_WRAPPER.getOrDefault(clazz, clazz).isAssignableFrom(argument.clazz)) {
                throw new IllegalArgumentException("The class obtained for an argument must match the class of the argument!\nFound: " + clazz.getSimpleName() + "\nExpected: " + argument.clazz.getSimpleName());
            }
            return (V)argument.data;
        }

        public <V> V getArgumentOrDefault(String name, V defaultVal) {
            Class<?> clazz = defaultVal.getClass();
            Argument<?> argument = this.get(name);
            if (argument == null) {
                return defaultVal;
            }
            if (!PRIMITIVE_TO_WRAPPER.getOrDefault(clazz, clazz).isAssignableFrom(argument.clazz)) {
                throw new IllegalArgumentException("The class obtained for an argument must match the class of the argument!\nFound: " + clazz.getSimpleName() + "\nExpected: " + argument.clazz.getSimpleName());
            }
            return (V)argument.data;
        }

        public <V> V getArgumentOrElseGet(String name, Class<V> clazz, Supplier<V> defaultVal) {
            Argument<?> argument = this.get(name);
            if (argument == null) {
                return defaultVal.get();
            }
            if (!PRIMITIVE_TO_WRAPPER.getOrDefault(clazz, clazz).isAssignableFrom(argument.clazz)) {
                throw new IllegalArgumentException("The class obtained for an argument must match the class of the argument!\nFound: " + clazz.getSimpleName() + "\nExpected: " + argument.clazz.getSimpleName());
            }
            return (V)argument.data;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Arguments)) {
                return false;
            }
            Arguments other = (Arguments)o;
            return Objects.equals(this.arguments, other.arguments);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.arguments);
        }

        static {
            PRIMITIVE_TO_WRAPPER.put(Boolean.TYPE, Boolean.class);
            PRIMITIVE_TO_WRAPPER.put(Byte.TYPE, Byte.class);
            PRIMITIVE_TO_WRAPPER.put(Short.TYPE, Short.class);
            PRIMITIVE_TO_WRAPPER.put(Character.TYPE, Character.class);
            PRIMITIVE_TO_WRAPPER.put(Integer.TYPE, Integer.class);
            PRIMITIVE_TO_WRAPPER.put(Long.TYPE, Long.class);
            PRIMITIVE_TO_WRAPPER.put(Float.TYPE, Float.class);
            PRIMITIVE_TO_WRAPPER.put(Double.TYPE, Double.class);
        }
    }
}

