/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.command.argument;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.atlas.atlascore.command.OptsArgumentUtils;
import net.atlas.atlascore.command.argument.Argument;
import net.atlas.atlascore.command.argument.ExtendedArgumentType;
import net.atlas.atlascore.extensions.CommandContextExtensions;
import net.atlas.atlascore.util.MapUtils;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import net.minecraft.class_7923;

public record OptsArgument(Map<String, ArgumentType<?>> arguments) implements ExtendedArgumentType<Argument<?>>
{
    public static final DynamicCommandExceptionType ERROR_INVALID_ARGUMENT = new DynamicCommandExceptionType(object -> class_2561.method_54159((String)"arguments.chosen.argument.invalid", (Object[])new Object[]{object}));

    public OptsArgument(String[] names, ArgumentType<?>[] types) {
        this(MapUtils.buildHashMapFromAlignedArrays(names, types));
    }

    public static OptsArgument namesAndArgumentTypes(String[] names, ArgumentType<?>[] types) {
        return new OptsArgument(names, types);
    }

    public static OptsArgument fromSortedArray(Object ... namesAndTypes) {
        if (namesAndTypes.length % 2 == 1) {
            throw new IllegalStateException("Arguments must have both a name and a type!");
        }
        String[] names = new String[namesAndTypes.length / 2];
        ArgumentType[] types = new ArgumentType[namesAndTypes.length / 2];
        for (int index = 0; index < namesAndTypes.length; index += 2) {
            int finalIndex = index / 2;
            if (namesAndTypes[index + 1] == null) continue;
            names[finalIndex] = (String)namesAndTypes[index];
            types[finalIndex] = (ArgumentType)namesAndTypes[index + 1];
        }
        return new OptsArgument(names, types);
    }

    public static OptsArgument fromMap(Map<String, ArgumentType<?>> arguments) {
        ArrayList toRemove = new ArrayList();
        arguments.forEach((string, type) -> {
            if (type == null) {
                toRemove.add(string);
            }
        });
        toRemove.forEach(arguments::remove);
        return new OptsArgument(arguments);
    }

    public static Argument<?> getArgument(CommandContext<?> context, String name) {
        return (Argument)context.getArgument(name, Argument.class);
    }

    private static String readArgumentName(StringReader stringReader) {
        int i = stringReader.getCursor();
        while (stringReader.canRead() && stringReader.peek() != '=' && !Character.isWhitespace(stringReader.peek())) {
            stringReader.skip();
        }
        return stringReader.getString().substring(i, stringReader.getCursor());
    }

    @Override
    public <S> Argument<?> parse(StringReader stringReader, CommandContext<S> commandContext) throws CommandSyntaxException {
        int cursor = stringReader.getCursor();
        String argumentName = OptsArgument.readArgumentName(stringReader);
        List<String> argumentNames = this.arguments.keySet().stream().filter(string -> {
            AtomicBoolean ret = new AtomicBoolean(true);
            ((CommandContextExtensions)commandContext).getArguments(Argument.class).forEach(arg -> ret.set(ret.get() & !arg.name().equals(string)));
            return ret.get();
        }).toList();
        if (!argumentNames.contains(argumentName)) {
            stringReader.setCursor(cursor);
            throw ERROR_INVALID_ARGUMENT.createWithContext((ImmutableStringReader)stringReader, (Object)argumentName);
        }
        stringReader.expect('=');
        ArgumentType<?> type = this.arguments.get(argumentName);
        return this.buildArgument(stringReader, commandContext, type, argumentName);
    }

    private <S, T> Argument<T> buildArgument(StringReader stringReader, CommandContext<S> commandContext, ArgumentType<T> type, String argumentName) throws CommandSyntaxException {
        Object object;
        if (type instanceof ExtendedArgumentType) {
            ExtendedArgumentType extendedArgumentType = (ExtendedArgumentType)type;
            object = extendedArgumentType.parse(stringReader, commandContext.getSource(), commandContext);
        } else {
            object = type.parse(stringReader);
        }
        Object result = object;
        return new Argument<Object>(argumentName, result, result.getClass());
    }

    public Argument<?> parse(StringReader reader) throws CommandSyntaxException {
        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().create();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        SuggestionsVisitor visitor = new SuggestionsVisitor();
        List<String> argumentNames = this.arguments.keySet().stream().filter(string -> {
            AtomicBoolean ret = new AtomicBoolean(true);
            ((CommandContextExtensions)context).getArguments(Argument.class).forEach(arg -> ret.set(ret.get() & !arg.name().equals(string)));
            return ret.get();
        }).toList();
        visitor.visitSuggestions(suggestionsBuilder -> class_2172.method_9265((Iterable)argumentNames, (SuggestionsBuilder)builder));
        try {
            this.suggestArgument(visitor, context, reader, argumentNames);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return visitor.resolveSuggestions(builder, reader);
    }

    private <S> void suggestArgument(SuggestionsVisitor visitor, CommandContext<S> context, StringReader reader, List<String> argumentNames) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String argumentName = OptsArgument.readArgumentName(reader);
        if (!argumentNames.contains(argumentName)) {
            reader.setCursor(cursor);
            throw ERROR_INVALID_ARGUMENT.createWithContext((ImmutableStringReader)reader, (Object)argumentName);
        }
        visitor.visitSuggestions(this::suggestSetValue);
        reader.expect('=');
        visitor.visitSuggestions(builder -> this.arguments.get(argumentName).listSuggestions(context, builder));
    }

    private CompletableFuture<Suggestions> suggestSetValue(SuggestionsBuilder suggestionsBuilder) {
        if (suggestionsBuilder.getRemaining().isEmpty()) {
            suggestionsBuilder.suggest(String.valueOf('='));
        }
        return suggestionsBuilder.buildFuture();
    }

    static class SuggestionsVisitor {
        private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions = OptsArgumentUtils.SUGGEST_NOTHING;

        SuggestionsVisitor() {
        }

        public void visitSuggestions(Function<SuggestionsBuilder, CompletableFuture<Suggestions>> function) {
            this.suggestions = function;
        }

        public CompletableFuture<Suggestions> resolveSuggestions(SuggestionsBuilder suggestionsBuilder, StringReader stringReader) {
            return this.suggestions.apply(suggestionsBuilder.createOffset(stringReader.getCursor()));
        }
    }

    public static class Info
    implements class_2314<OptsArgument, Template> {
        public void serializeToNetwork(Template template, class_2540 friendlyByteBuf) {
            friendlyByteBuf.method_34063(template.argumentInfos, class_2540::method_10814, (byteBuf, argument) -> {
                byteBuf.method_10804(class_7923.field_41192.method_10206((Object)argument.method_41728()));
                argument.method_41728().method_10007(argument, byteBuf);
            });
        }

        public void serializeToJson(Template template, JsonObject jsonObject) {
            JsonArray entries = new JsonArray();
            template.argumentInfos.forEach((argument, argTemplate) -> {
                if (argTemplate == null) {
                    return;
                }
                JsonObject entry = new JsonObject();
                entry.addProperty("name", argument);
                JsonObject jsonObject1 = new JsonObject();
                jsonObject1.addProperty("parser", class_7923.field_41192.method_10221((Object)argTemplate.method_41728()).toString());
                JsonObject jsonObject2 = new JsonObject();
                argTemplate.method_41728().method_10006(argTemplate, jsonObject2);
                if (!jsonObject2.isEmpty()) {
                    jsonObject1.add("properties", (JsonElement)jsonObject2);
                }
                entry.add("argument_template", (JsonElement)jsonObject1);
                entries.add((JsonElement)entry);
            });
            jsonObject.add("configArgument", (JsonElement)entries);
        }

        public Template deserializeFromNetwork(class_2540 friendlyByteBuf) {
            return new Template(friendlyByteBuf);
        }

        public Template unpack(OptsArgument argumentType) {
            return new Template(argumentType.arguments);
        }

        public final class Template
        implements class_2314.class_7217<OptsArgument> {
            private final Map<String, class_2314.class_7217<?>> argumentInfos;

            public Template(Map<String, ArgumentType<?>> arguments) {
                this.argumentInfos = Maps.transformValues(arguments, class_2316::method_41985);
            }

            public Template(class_2540 friendlyByteBuf) {
                this.argumentInfos = friendlyByteBuf.method_34067(class_2540::method_19772, byteBuf -> {
                    class_2314 argumentTypeInfo = (class_2314)class_7923.field_41192.method_10200(byteBuf.method_10816());
                    if (argumentTypeInfo != null) {
                        return argumentTypeInfo.method_10005(byteBuf);
                    }
                    return null;
                });
            }

            public OptsArgument instantiate(class_7157 commandBuildContext) {
                return OptsArgument.fromMap(Maps.transformValues(this.argumentInfos, info -> {
                    if (info == null) {
                        return null;
                    }
                    return info.method_41730(commandBuildContext);
                }));
            }

            public class_2314<OptsArgument, ?> method_41728() {
                return Info.this;
            }
        }
    }
}

