/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury;

import com.mojang.logging.LogUtils;
import com.yablon.furnitury.Config;
import com.yablon.furnitury.ModCreativeTabs;
import com.yablon.furnitury.block.DisplayCaseRenderer;
import com.yablon.furnitury.block.DoubleShelfRenderer;
import com.yablon.furnitury.block.ModBlocks;
import com.yablon.furnitury.block.ShelfRenderer;
import com.yablon.furnitury.block.entity.ModBlockEntities;
import com.yablon.furnitury.data_gen.ModDataGenerators;
import com.yablon.furnitury.entity.ModEntities;
import com.yablon.furnitury.entity.SitEntityRenderer;
import com.yablon.furnitury.item.ModItems;
import com.yablon.furnitury.recipe.MyRecipeSerializers;
import com.yablon.furnitury.recipe.MyRecipeTypes;
import com.yablon.furnitury.screen.BoxScreen;
import com.yablon.furnitury.screen.CabinetScreen;
import com.yablon.furnitury.screen.DisplayCaseScreen;
import com.yablon.furnitury.screen.DoubleShelfScreen;
import com.yablon.furnitury.screen.DresserScreen;
import com.yablon.furnitury.screen.FridgeScreen;
import com.yablon.furnitury.screen.FurnitureWorkbenchScreen;
import com.yablon.furnitury.screen.KitchenFurnaceScreen;
import com.yablon.furnitury.screen.MicrowaveScreen;
import com.yablon.furnitury.screen.ModMenuTypes;
import com.yablon.furnitury.screen.ShelfScreen;
import com.yablon.furnitury.screen.TrashcanScreen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="furnitury")
public class FurnituryMod {
    public static final String MOD_ID = "furnitury";
    private static final Logger LOGGER = LogUtils.getLogger();

    public FurnituryMod(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        ModItems.register(modEventBus);
        modEventBus.addListener(ModDataGenerators::gatherData);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        MyRecipeTypes.RECIPE_TYPES.register(modEventBus);
        MyRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        ModCreativeTabs.register(modEventBus);
        ModEntities.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        if (Config.logDirtBlock) {
            LOGGER.info("DIRT BLOCK >> {}", (Object)BuiltInRegistries.BLOCK.getKey((Object)Blocks.DIRT));
        }
        LOGGER.info(Config.magicNumberIntroduction + Config.magicNumber);
        Config.items.forEach(item -> LOGGER.info("ITEM >> {}", (Object)item.toString()));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
        RecipeManager recipeManager = event.getServer().getRecipeManager();
        List recipes = recipeManager.getAllRecipesFor(MyRecipeTypes.FURNITURE_WORKBENCH.get());
        List kitchenFurnaceRecipes = recipeManager.getAllRecipesFor(MyRecipeTypes.KITCHEN_FURNACE.get());
    }

    @EventBusSubscriber(modid="furnitury", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
            event.enqueueWork(() -> EntityRenderers.register(ModEntities.SIT_ENTITY.get(), SitEntityRenderer::new));
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.OAK_SAPLING_POT.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SPRUCE_SAPLING_POT.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.BIRCH_SAPLING_POT.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.ACACIA_SAPLING_POT.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.JUNGLE_SAPLING_POT.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.DARK_OAK_SAPLING_POT.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CHERRY_SAPLING_POT.get()), (RenderType)RenderType.cutout());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.OAK_DISPLAY_CASE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.ACACIA_DISPLAY_CASE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.BIRCH_DISPLAY_CASE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CHERRY_DISPLAY_CASE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CRIMSON_DISPLAY_CASE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.DARK_OAK_DISPLAY_CASE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.JUNGLE_DISPLAY_CASE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.MANGROVE_DISPLAY_CASE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SPRUCE_DISPLAY_CASE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WARPED_DISPLAY_CASE.get()), (RenderType)RenderType.translucent());
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.SHELF_BLOCK_ENTITY.get(), ShelfRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.DISPLAY_CASE_BLOCK_ENTITY.get(), DisplayCaseRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.DOUBLE_SHELF_BLOCK_ENTITY.get(), DoubleShelfRenderer::new);
        }

        @SubscribeEvent
        public static void clientLoad(RegisterMenuScreensEvent event) {
            event.register((MenuType)ModMenuTypes.FURNITURE_WORKBENCH_MENU.get(), FurnitureWorkbenchScreen::new);
            event.register((MenuType)ModMenuTypes.BOX_MENU.get(), BoxScreen::new);
            event.register((MenuType)ModMenuTypes.DRESSER_MENU.get(), DresserScreen::new);
            event.register((MenuType)ModMenuTypes.SHELF_MENU.get(), ShelfScreen::new);
            event.register((MenuType)ModMenuTypes.DISPLAY_CASE_MENU.get(), DisplayCaseScreen::new);
            event.register((MenuType)ModMenuTypes.CABINET_MENU.get(), CabinetScreen::new);
            event.register((MenuType)ModMenuTypes.TRASHCAN_MENU.get(), TrashcanScreen::new);
            event.register((MenuType)ModMenuTypes.DOUBLE_SHELF_MENU.get(), DoubleShelfScreen::new);
            event.register((MenuType)ModMenuTypes.KITCHEN_FURNACE_MENU.get(), KitchenFurnaceScreen::new);
            event.register((MenuType)ModMenuTypes.MICROWAVE_MENU.get(), MicrowaveScreen::new);
            event.register((MenuType)ModMenuTypes.FRIDGE_MENU.get(), FridgeScreen::new);
        }
    }
}

