/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury.block;

import com.mojang.serialization.MapCodec;
import com.yablon.furnitury.block.FridgeBlock;
import com.yablon.furnitury.block.entity.FridgeBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class FreezerBlock
extends HorizontalDirectionalBlock {
    private final Block fridgeBlock;

    public FreezerBlock(BlockBehaviour.Properties properties, Block fridgeBlock) {
        super(properties);
        this.fridgeBlock = fridgeBlock;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        Direction facing = context.getHorizontalDirection().getOpposite();
        BlockPos abovePos = clickedPos.above();
        if (level.getBlockState(abovePos).isAir()) {
            level.setBlock(abovePos, (BlockState)this.fridgeBlock.defaultBlockState().setValue((Property)FACING, (Comparable)facing), 3);
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing);
        }
        return null;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPos abovePos;
        BlockState aboveState;
        if (!level.isClientSide && !state.is(newState.getBlock()) && (aboveState = level.getBlockState(abovePos = pos.above())).getBlock() instanceof FridgeBlock) {
            BlockEntity blockEntity = level.getBlockEntity(abovePos);
            if (blockEntity instanceof FridgeBlockEntity) {
                FridgeBlockEntity fridgeEntity = (FridgeBlockEntity)blockEntity;
                fridgeEntity.drops();
            }
            level.destroyBlock(abovePos, true);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }
}

