/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury.block;

import com.mojang.serialization.MapCodec;
import com.yablon.furnitury.entity.ModEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SofaBlock
extends HorizontalDirectionalBlock {
    public static final BooleanProperty LEFT_ARM = BooleanProperty.create((String)"left_arm");
    public static final BooleanProperty RIGHT_ARM = BooleanProperty.create((String)"right_arm");
    private final VoxelShape defaultShape;
    private final VoxelShape leftArmShape;
    private final VoxelShape rightArmShape;
    private final VoxelShape noArmsShape;

    public SofaBlock(BlockBehaviour.Properties properties, VoxelShape defaultShape) {
        super(properties);
        this.defaultShape = defaultShape;
        this.leftArmShape = defaultShape;
        this.rightArmShape = defaultShape;
        this.noArmsShape = defaultShape;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LEFT_ARM, (Comparable)Boolean.valueOf(false))).setValue((Property)RIGHT_ARM, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.isClientSide()) {
            Entity entity = null;
            List entities = level.getEntities((EntityTypeTest)ModEntities.SIT_ENTITY.get(), new AABB(pos), chair -> true);
            entity = entities.isEmpty() ? ModEntities.SIT_ENTITY.get().spawn((ServerLevel)level, pos, MobSpawnType.TRIGGERED) : (Entity)entities.get(0);
            player.startRiding(entity);
        }
        return InteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LEFT_ARM, RIGHT_ARM});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        boolean hasNeighbors = false;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.relative(direction);
            BlockState neighborState = world.getBlockState(neighborPos);
            if (!(neighborState.getBlock() instanceof SofaBlock)) continue;
            hasNeighbors = true;
            break;
        }
        if (!hasNeighbors) {
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)LEFT_ARM, (Comparable)Boolean.valueOf(true))).setValue((Property)RIGHT_ARM, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)LEFT_ARM, (Comparable)Boolean.valueOf(this.shouldHaveLeftArm(world, pos)))).setValue((Property)RIGHT_ARM, (Comparable)Boolean.valueOf(this.shouldHaveRightArm(world, pos)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean hasLeftArm = (Boolean)state.getValue((Property)LEFT_ARM);
        boolean hasRightArm = (Boolean)state.getValue((Property)RIGHT_ARM);
        if (hasLeftArm && hasRightArm) {
            return this.defaultShape;
        }
        if (hasLeftArm) {
            return this.leftArmShape;
        }
        if (hasRightArm) {
            return this.rightArmShape;
        }
        return this.noArmsShape;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, world, pos, oldState, isMoving);
        this.updateConnections(world, pos, state);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, world, pos, newState, isMoving);
        this.updateConnections(world, pos, null);
    }

    private void updateConnections(Level world, BlockPos pos, BlockState currentState) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.relative(direction);
            BlockState neighborState = world.getBlockState(neighborPos);
            if (!(neighborState.getBlock() instanceof SofaBlock)) continue;
            boolean leftArm = this.shouldHaveLeftArm(world, neighborPos);
            boolean rightArm = this.shouldHaveRightArm(world, neighborPos);
            world.setBlock(neighborPos, (BlockState)((BlockState)neighborState.setValue((Property)LEFT_ARM, (Comparable)Boolean.valueOf(leftArm))).setValue((Property)RIGHT_ARM, (Comparable)Boolean.valueOf(rightArm)), 3);
        }
    }

    private boolean shouldHaveLeftArm(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if (!(state.getBlock() instanceof SofaBlock)) {
            return true;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        Direction leftDirection = facing.getClockWise();
        BlockPos neighborPos = pos.relative(leftDirection);
        BlockState neighborState = world.getBlockState(neighborPos);
        if (neighborState.getBlock() instanceof SofaBlock) {
            Direction neighborFacing = (Direction)neighborState.getValue((Property)FACING);
            return neighborFacing != facing;
        }
        return true;
    }

    private boolean shouldHaveRightArm(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if (!(state.getBlock() instanceof SofaBlock)) {
            return true;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        Direction rightDirection = facing.getCounterClockWise();
        BlockPos neighborPos = pos.relative(rightDirection);
        BlockState neighborState = world.getBlockState(neighborPos);
        if (neighborState.getBlock() instanceof SofaBlock) {
            Direction neighborFacing = (Direction)neighborState.getValue((Property)FACING);
            return neighborFacing != facing;
        }
        return true;
    }
}

