/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury.block.entity;

import com.yablon.furnitury.block.entity.ModBlockEntities;
import com.yablon.furnitury.screen.ShelfMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class DisplayCaseBlockEntity
extends BlockEntity
implements MenuProvider,
WorldlyContainer {
    private final ItemStackHandler itemHandler = new ItemStackHandler(1);
    private static final float[] ITEM_RENDER_POSITION = new float[]{0.5f, 0.4f, 0.75f};

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 1);
        }
    }

    public DisplayCaseBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.DISPLAY_CASE_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public void onLoad() {
        super.onLoad();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public Component getDisplayName() {
        return Component.literal((String)"Display Case");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new ShelfMenu(pContainerId, pPlayerInventory, this, (ContainerData)new SimpleContainerData(2));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("inventory")) {
            this.itemHandler.deserializeNBT(registries, tag.getCompound("inventory"));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        super.saveAdditional(tag, registries);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public int[] getSlotsForFace(Direction direction) {
        return new int[0];
    }

    public boolean canPlaceItemThroughFace(int i, ItemStack itemStack, @Nullable Direction direction) {
        return false;
    }

    public boolean canTakeItemThroughFace(int i, ItemStack itemStack, Direction direction) {
        return false;
    }

    public int getContainerSize() {
        return this.itemHandler.getSlots();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int i) {
        return this.itemHandler.getStackInSlot(i);
    }

    public ItemStack removeItem(int index, int count) {
        return this.itemHandler.extractItem(index, count, false);
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = this.itemHandler.getStackInSlot(index);
        this.itemHandler.setStackInSlot(index, ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        this.itemHandler.setStackInSlot(index, stack);
    }

    public boolean stillValid(Player player) {
        if (this.level == null) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public void clearContent() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public float[] getRenderPosition(Direction direction) {
        float[] position = ITEM_RENDER_POSITION;
        switch (direction) {
            case NORTH: {
                return new float[]{position[0], position[1], position[2]};
            }
            case SOUTH: {
                return new float[]{1.0f - position[0], position[1], 1.0f - position[2]};
            }
            case WEST: {
                return new float[]{position[2], position[1], 1.0f - position[0]};
            }
            case EAST: {
                return new float[]{1.0f - position[2], position[1], position[0]};
            }
        }
        return position;
    }
}

