/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury.block.entity;

import com.yablon.furnitury.block.entity.ModBlockEntities;
import com.yablon.furnitury.recipe.FurnitureWorkbenchInput;
import com.yablon.furnitury.recipe.FurnitureWorkbenchRecipe;
import com.yablon.furnitury.recipe.MyRecipeTypes;
import com.yablon.furnitury.screen.FurnitureWorkbenchMenu;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class FurnitureWorkbenchBlockEntity
extends BlockEntity
implements MenuProvider,
WorldlyContainer {
    private int lastOutputCount = 0;
    private boolean isCraftingValid = false;
    private boolean isUpdating = false;
    private final ItemStackHandler itemHandler = new ItemStackHandler(11){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onContentsChanged(int slot) {
            if (FurnitureWorkbenchBlockEntity.this.isUpdating) {
                return;
            }
            try {
                FurnitureWorkbenchBlockEntity.this.isUpdating = true;
                if (slot < 10) {
                    FurnitureWorkbenchBlockEntity.this.processRecipe();
                } else if (slot == 10) {
                    ItemStack outputSlot = this.getStackInSlot(10);
                    int currentOutputCount = outputSlot.getCount();
                    if (FurnitureWorkbenchBlockEntity.this.isCraftingValid && currentOutputCount < FurnitureWorkbenchBlockEntity.this.lastOutputCount && FurnitureWorkbenchBlockEntity.this.lastOutputCount > 0) {
                        FurnitureWorkbenchBlockEntity.this.consumeResources();
                        FurnitureWorkbenchBlockEntity.this.processRecipe();
                    }
                    FurnitureWorkbenchBlockEntity.this.lastOutputCount = currentOutputCount;
                }
                FurnitureWorkbenchBlockEntity.this.setChanged();
            }
            finally {
                FurnitureWorkbenchBlockEntity.this.isUpdating = false;
            }
        }
    };

    public FurnitureWorkbenchBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.FURNITURE_WORKBENCH_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public void onLoad() {
        super.onLoad();
    }

    public void drops() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)stack);
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
        this.itemHandler.setStackInSlot(10, ItemStack.EMPTY);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.furnitury.furniture_workbench");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new FurnitureWorkbenchMenu(pContainerId, pPlayerInventory, this, (ContainerData)new SimpleContainerData(2));
    }

    public void consumeResources() {
        if (!this.isCraftingValid) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            stack.shrink(1);
            if (!stack.isEmpty()) continue;
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
        ItemStack inputSlot = this.itemHandler.getStackInSlot(9);
        if (!inputSlot.isEmpty()) {
            inputSlot.shrink(1);
            if (inputSlot.isEmpty()) {
                this.itemHandler.setStackInSlot(9, ItemStack.EMPTY);
            }
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("inventory")) {
            this.itemHandler.deserializeNBT(registries, tag.getCompound("inventory"));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        super.saveAdditional(tag, registries);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, T blockEntity) {
        if (!level.isClientSide && blockEntity instanceof FurnitureWorkbenchBlockEntity) {
            FurnitureWorkbenchBlockEntity storageCrafterBlockEntity = (FurnitureWorkbenchBlockEntity)blockEntity;
            storageCrafterBlockEntity.processRecipe();
        }
    }

    public void processRecipe() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        RecipeManager recipeManager = this.level.getRecipeManager();
        ArrayList<ItemStack> gridItems = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            gridItems.add(this.itemHandler.getStackInSlot(i));
        }
        ItemStack inputItem = this.itemHandler.getStackInSlot(9);
        FurnitureWorkbenchInput recipeInput = new FurnitureWorkbenchInput(inputItem, gridItems);
        Optional recipeHolderOptional = recipeManager.getRecipeFor(MyRecipeTypes.FURNITURE_WORKBENCH.get(), (RecipeInput)recipeInput, this.level);
        ItemStack currentOutput = this.itemHandler.getStackInSlot(10);
        if (recipeHolderOptional.isPresent()) {
            FurnitureWorkbenchRecipe recipe = (FurnitureWorkbenchRecipe)((RecipeHolder)recipeHolderOptional.get()).value();
            ItemStack result = recipe.getResult().copy();
            if (currentOutput.isEmpty() || ItemStack.isSameItem((ItemStack)currentOutput, (ItemStack)result) && currentOutput.getCount() < result.getMaxStackSize()) {
                if (currentOutput.isEmpty() && this.lastOutputCount > 0) {
                    this.lastOutputCount = 0;
                    return;
                }
                this.itemHandler.setStackInSlot(10, result.copy());
                this.lastOutputCount = result.getCount();
                this.isCraftingValid = true;
            }
        } else {
            if (!currentOutput.isEmpty()) {
                this.itemHandler.setStackInSlot(10, ItemStack.EMPTY);
            }
            this.isCraftingValid = false;
        }
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public int[] getSlotsForFace(Direction direction) {
        return new int[0];
    }

    public boolean canPlaceItemThroughFace(int i, ItemStack itemStack, @Nullable Direction direction) {
        return false;
    }

    public boolean canTakeItemThroughFace(int i, ItemStack itemStack, Direction direction) {
        return false;
    }

    public int getContainerSize() {
        return this.itemHandler.getSlots();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public ItemStack removeItem(int index, int count) {
        return this.itemHandler.extractItem(index, count, false);
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = this.itemHandler.getStackInSlot(index);
        this.itemHandler.setStackInSlot(index, ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        this.itemHandler.setStackInSlot(index, stack);
    }

    public boolean stillValid(Player player) {
        if (this.level == null) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public void clearContent() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
    }
}

