/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury.block.entity;

import com.yablon.furnitury.block.entity.ModBlockEntities;
import com.yablon.furnitury.recipe.KitchenFurnaceInput;
import com.yablon.furnitury.recipe.KitchenFurnaceRecipe;
import com.yablon.furnitury.recipe.MyRecipeTypes;
import com.yablon.furnitury.screen.KitchenFurnaceMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class KitchenFurnaceBlockEntity
extends BlockEntity
implements MenuProvider,
WorldlyContainer {
    private final ItemStackHandler itemHandler = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            KitchenFurnaceBlockEntity.this.setChanged();
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private final SimpleContainerData data;
    private final int[] progress = new int[3];
    private final int maxProgress = 100;

    public KitchenFurnaceBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.KITCHEN_FURNACE_BLOCK_ENTITY.get(), pPos, pBlockState);
        this.data = new SimpleContainerData(6){

            public int get(int index) {
                if (index < 3) {
                    return KitchenFurnaceBlockEntity.this.progress[index];
                }
                if (index < 6) {
                    return 100;
                }
                return 0;
            }

            public void set(int index, int value) {
                if (index < 3) {
                    KitchenFurnaceBlockEntity.this.progress[index] = value;
                }
            }

            public int getCount() {
                return 6;
            }
        };
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.deco_storage.storage_extractor");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new KitchenFurnaceMenu(pContainerId, pPlayerInventory, this, (ContainerData)this.data);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        CompoundTag progressTag = tag.getCompound("kitchen_furnace.progress");
        for (int i = 0; i < 3; ++i) {
            this.progress[i] = progressTag.getInt("progress" + i);
        }
        this.itemHandler.deserializeNBT(registries, tag.getCompound("inventory"));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag progressTag = new CompoundTag();
        for (int i = 0; i < 3; ++i) {
            progressTag.putInt("progress" + i, this.progress[i]);
        }
        tag.put("kitchen_furnace.progress", (Tag)progressTag);
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        super.saveAdditional(tag, registries);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.isClientSide) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            if (this.hasRecipe(i)) {
                int n = i;
                this.progress[n] = this.progress[n] + 1;
                if (this.progress[i] < 100) continue;
                this.craftItem(i);
                this.progress[i] = 0;
                continue;
            }
            this.progress[i] = 0;
        }
        KitchenFurnaceBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
    }

    private void craftItem(int index) {
        Optional<KitchenFurnaceRecipe> recipe = this.getCurrentRecipe(index);
        if (recipe.isEmpty()) {
            return;
        }
        ItemStack result = recipe.get().getFirstOutput();
        int inputSlot = index;
        int outputSlot = 3 + index;
        this.itemHandler.extractItem(inputSlot, 1, false);
        this.itemHandler.setStackInSlot(outputSlot, new ItemStack((ItemLike)result.getItem(), this.itemHandler.getStackInSlot(outputSlot).getCount() + result.getCount()));
    }

    private boolean hasRecipe(int index) {
        Optional<KitchenFurnaceRecipe> recipe = this.getCurrentRecipe(index);
        if (recipe.isEmpty()) {
            return false;
        }
        int outputSlot = 3 + index;
        ItemStack result = recipe.get().getFirstOutput();
        return this.canInsertAmountIntoOutputSlot(outputSlot, result.getCount()) && this.canInsertItemIntoOutputSlot(outputSlot, result.getItem());
    }

    private boolean canInsertItemIntoOutputSlot(int slot, Item item) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        return stack.isEmpty() || stack.getItem() == item;
    }

    private boolean canInsertAmountIntoOutputSlot(int slot, int count) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        if (stack.isEmpty()) {
            return count <= 64;
        }
        boolean result = stack.getCount() + count <= stack.getMaxStackSize();
        return result;
    }

    private Optional<KitchenFurnaceRecipe> getCurrentRecipe(int index) {
        if (this.level == null) {
            return Optional.empty();
        }
        ItemStack inputStack = this.itemHandler.getStackInSlot(index);
        KitchenFurnaceInput input = new KitchenFurnaceInput(inputStack);
        Optional recipeHolder = this.level.getRecipeManager().getRecipeFor(MyRecipeTypes.KITCHEN_FURNACE.get(), (RecipeInput)input, this.level);
        return recipeHolder.map(RecipeHolder::value);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public int[] getSlotsForFace(Direction direction) {
        return new int[0];
    }

    public boolean canPlaceItemThroughFace(int i, ItemStack itemStack, @Nullable Direction direction) {
        return false;
    }

    public boolean canTakeItemThroughFace(int i, ItemStack itemStack, Direction direction) {
        return false;
    }

    public int getContainerSize() {
        return this.itemHandler.getSlots();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public ItemStack removeItem(int index, int count) {
        return this.itemHandler.extractItem(index, count, false);
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = this.itemHandler.getStackInSlot(index);
        this.itemHandler.setStackInSlot(index, ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        this.itemHandler.setStackInSlot(index, stack);
    }

    public boolean stillValid(Player player) {
        if (this.level == null) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public void clearContent() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public int getProgress(int index) {
        return index >= 0 && index < this.progress.length ? this.progress[index] : 0;
    }
}

