/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury.block.entity;

import com.yablon.furnitury.block.entity.ModBlockEntities;
import com.yablon.furnitury.recipe.MicrowaveInput;
import com.yablon.furnitury.recipe.MicrowaveRecipe;
import com.yablon.furnitury.recipe.MyRecipeTypes;
import com.yablon.furnitury.screen.MicrowaveMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class MicrowaveBlockEntity
extends BlockEntity
implements MenuProvider,
WorldlyContainer {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            MicrowaveBlockEntity.this.setChanged();
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private final SimpleContainerData data = new SimpleContainerData(2);
    private int progress = 0;
    private int maxProgress = 78;

    public MicrowaveBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.MICROWAVE_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.furnitury.microwave");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new MicrowaveMenu(pContainerId, pPlayerInventory, this, (ContainerData)this.data);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("inventory")) {
            this.itemHandler.deserializeNBT(registries, tag.getCompound("inventory"));
        }
        this.progress = tag.getInt("storage_extractor.progress");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putInt("storage_extractor.progress", this.progress);
        super.saveAdditional(tag, registries);
    }

    public int getProgress() {
        return this.progress;
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.isClientSide) {
            return;
        }
        if (this.hasRecipe()) {
            this.increaseCraftingProgress();
            this.data.set(0, this.progress);
            this.setChanged();
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.data.set(0, this.progress);
        this.setChanged();
    }

    private void craftItem() {
        Optional<RecipeHolder<MicrowaveRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return;
        }
        ItemStack firstResult = ((MicrowaveRecipe)recipe.get().value()).getFirstOutput();
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)firstResult.getItem(), this.itemHandler.getStackInSlot(1).getCount() + firstResult.getCount()));
        ++this.progress;
        if (this.progress >= this.maxProgress) {
            this.resetProgress();
        }
        this.data.set(0, this.progress);
        this.setChanged();
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<MicrowaveRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack firstResult = ((MicrowaveRecipe)recipe.get().value()).getFirstOutput();
        boolean canInsertFirst = this.canInsertAmountIntoOutputSlot(1, firstResult.getCount()) && this.canInsertItemIntoOutputSlot(1, firstResult.getItem());
        return canInsertFirst;
    }

    private boolean canInsertItemIntoOutputSlot(int slot, Item item) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        return stack.isEmpty() || stack.getItem() == item;
    }

    private boolean canInsertAmountIntoOutputSlot(int slot, int count) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        if (stack.isEmpty()) {
            return count <= 64;
        }
        boolean result = stack.getCount() + count <= stack.getMaxStackSize();
        return result;
    }

    private Optional<RecipeHolder<MicrowaveRecipe>> getCurrentRecipe() {
        if (this.level == null) {
            return Optional.empty();
        }
        RecipeManager recipeManager = this.level.getRecipeManager();
        SimpleContainer inventory = new SimpleContainer(1);
        inventory.setItem(0, this.itemHandler.getStackInSlot(0));
        Optional recipe = recipeManager.getRecipeFor(MyRecipeTypes.MICROWAVE.get(), (RecipeInput)new MicrowaveInput(this.itemHandler.getStackInSlot(0)), this.level);
        return recipe;
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
        this.data.set(0, this.progress);
        this.setChanged();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public int[] getSlotsForFace(Direction direction) {
        return new int[0];
    }

    public boolean canPlaceItemThroughFace(int i, ItemStack itemStack, @Nullable Direction direction) {
        return false;
    }

    public boolean canTakeItemThroughFace(int i, ItemStack itemStack, Direction direction) {
        return false;
    }

    public int getContainerSize() {
        return this.itemHandler.getSlots();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public ItemStack removeItem(int index, int count) {
        return this.itemHandler.extractItem(index, count, false);
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = this.itemHandler.getStackInSlot(index);
        this.itemHandler.setStackInSlot(index, ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        this.itemHandler.setStackInSlot(index, stack);
    }

    public boolean stillValid(Player player) {
        if (this.level == null) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public void clearContent() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
    }
}

