/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury.integration.jei;

import com.yablon.furnitury.integration.jei.FurnitureWorkbenchRecipeCategory;
import com.yablon.furnitury.integration.jei.KitchenFurnaceRecipeCategory;
import com.yablon.furnitury.integration.jei.MicrowaveRecipeCategory;
import com.yablon.furnitury.recipe.FurnitureWorkbenchRecipe;
import com.yablon.furnitury.recipe.KitchenFurnaceRecipe;
import com.yablon.furnitury.recipe.MicrowaveRecipe;
import com.yablon.furnitury.recipe.MyRecipeTypes;
import com.yablon.furnitury.screen.FurnitureWorkbenchScreen;
import com.yablon.furnitury.screen.KitchenFurnaceScreen;
import com.yablon.furnitury.screen.MicrowaveScreen;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.fml.ModList;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.parse((String)"furnitury:furniture_workbench");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (!this.isJEILoaded()) {
            return;
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new FurnitureWorkbenchRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new KitchenFurnaceRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new MicrowaveRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (!this.isJEILoaded()) {
            return;
        }
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        List recipeHolders = recipeManager.getAllRecipesFor(MyRecipeTypes.FURNITURE_WORKBENCH.get());
        List kitchenFurnaceRecipeHolders = recipeManager.getAllRecipesFor(MyRecipeTypes.KITCHEN_FURNACE.get());
        List microwaveRecipeHolders = recipeManager.getAllRecipesFor(MyRecipeTypes.MICROWAVE.get());
        List<FurnitureWorkbenchRecipe> recipes = recipeHolders.stream().map(RecipeHolder::value).toList();
        List<KitchenFurnaceRecipe> kitchenFurnaceRecipes = kitchenFurnaceRecipeHolders.stream().map(RecipeHolder::value).toList();
        List<MicrowaveRecipe> microwaveRecipes = microwaveRecipeHolders.stream().map(RecipeHolder::value).toList();
        registration.addRecipes(FurnitureWorkbenchRecipeCategory.FURNITURE_WORKBENCH_RECIPE_TYPE, recipes);
        registration.addRecipes(KitchenFurnaceRecipeCategory.KITCHEN_FURNACE_RECIPE_TYPE, kitchenFurnaceRecipes);
        registration.addRecipes(MicrowaveRecipeCategory.MICROWAVE_RECIPE_TYPE, microwaveRecipes);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (!this.isJEILoaded()) {
            return;
        }
        registration.addRecipeClickArea(FurnitureWorkbenchScreen.class, 120, 30, 20, 30, new RecipeType[]{FurnitureWorkbenchRecipeCategory.FURNITURE_WORKBENCH_RECIPE_TYPE});
        registration.addRecipeClickArea(KitchenFurnaceScreen.class, 70, 30, 20, 30, new RecipeType[]{KitchenFurnaceRecipeCategory.KITCHEN_FURNACE_RECIPE_TYPE});
        registration.addRecipeClickArea(MicrowaveScreen.class, 70, 30, 20, 30, new RecipeType[]{MicrowaveRecipeCategory.MICROWAVE_RECIPE_TYPE});
    }

    private boolean isJEILoaded() {
        return ModList.get().isLoaded("jei");
    }
}

