/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class WrenchItem
extends Item {
    public WrenchItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.furnitury.wrench.tooltip"));
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null || !player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        for (Property property : state.getProperties()) {
            if (!(property instanceof DirectionProperty)) continue;
            DirectionProperty facingProperty = (DirectionProperty)property;
            Direction currentFacing = (Direction)state.getValue((Property)facingProperty);
            Direction newFacing = this.rotateClockwise(currentFacing);
            if (!level.isClientSide) {
                level.setBlock(pos, (BlockState)state.setValue((Property)facingProperty, (Comparable)newFacing), 2);
                ((ServerLevel)level).sendBlockUpdated(pos, state, level.getBlockState(pos), 3);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private Direction rotateClockwise(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> Direction.EAST;
            case Direction.EAST -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.WEST;
            case Direction.WEST -> Direction.NORTH;
            default -> direction;
        };
    }
}

