/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury.recipe;

import com.yablon.furnitury.recipe.FurnitureWorkbenchInput;
import com.yablon.furnitury.recipe.MyRecipeSerializers;
import com.yablon.furnitury.recipe.MyRecipeTypes;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class FurnitureWorkbenchRecipe
implements Recipe<FurnitureWorkbenchInput> {
    private final ItemStack singleInput;
    private final List<Ingredient> gridPattern;
    private final ItemStack result;

    public FurnitureWorkbenchRecipe(ItemStack singleInput, List<Ingredient> gridPattern, ItemStack result) {
        this.singleInput = singleInput;
        this.gridPattern = gridPattern;
        this.result = result;
    }

    public boolean matches(FurnitureWorkbenchInput input, Level level) {
        List<ItemStack> gridItems = input.getGridItems();
        for (int i = 0; i < this.gridPattern.size(); ++i) {
            Ingredient ingredient = this.gridPattern.get(i);
            ItemStack stack = gridItems.get(i);
            if (ingredient == Ingredient.EMPTY && !stack.isEmpty()) {
                return false;
            }
            if (ingredient.test(stack)) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(FurnitureWorkbenchInput input, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public ItemStack getSingleInput() {
        return this.singleInput;
    }

    public List<Ingredient> getGridPattern() {
        return this.gridPattern;
    }

    public ItemStack getResult() {
        return this.result.copy();
    }

    public RecipeType<?> getType() {
        return MyRecipeTypes.FURNITURE_WORKBENCH.get();
    }

    public RecipeSerializer<?> getSerializer() {
        return MyRecipeSerializers.STORAGE_CRAFTER.get();
    }
}

