/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury.recipe;

import com.yablon.furnitury.recipe.MicrowaveInput;
import com.yablon.furnitury.recipe.MyRecipeSerializers;
import com.yablon.furnitury.recipe.MyRecipeTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class MicrowaveRecipe
implements Recipe<MicrowaveInput> {
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack firstOutput;

    public MicrowaveRecipe(NonNullList<Ingredient> ingredients, ItemStack firstOutput) {
        this.ingredients = ingredients;
        this.firstOutput = firstOutput;
    }

    public boolean matches(MicrowaveInput input, Level pLevel) {
        if (pLevel.isClientSide()) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(input.getInputItem());
    }

    public ItemStack assemble(MicrowaveInput input, HolderLookup.Provider provider) {
        return this.firstOutput.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.firstOutput.copy();
    }

    public ItemStack getFirstOutput() {
        return this.firstOutput;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public RecipeSerializer<?> getSerializer() {
        return MyRecipeSerializers.MICROWAVE.get();
    }

    public RecipeType<?> getType() {
        return MyRecipeTypes.MICROWAVE.get();
    }
}

