/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yablon.furnitury.recipe.MicrowaveRecipe;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class MicrowaveRecipeSerializer
implements RecipeSerializer<MicrowaveRecipe> {
    public static final MapCodec<MicrowaveRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.listOf().xmap(NonNullList::copyOf, Function.identity()).fieldOf("ingredients").forGetter(MicrowaveRecipe::getIngredients), (App)ItemStack.CODEC.fieldOf("first_output").forGetter(MicrowaveRecipe::getFirstOutput)).apply((Applicative)instance, (ingredients, firstOutput) -> new MicrowaveRecipe((NonNullList<Ingredient>)ingredients, (ItemStack)firstOutput)));
    private static final StreamCodec<RegistryFriendlyByteBuf, Float> FLOAT_STREAM_CODEC = StreamCodec.of((buffer, value) -> buffer.writeFloat(value.floatValue()), FriendlyByteBuf::readFloat);
    public static final StreamCodec<RegistryFriendlyByteBuf, MicrowaveRecipe> STREAM_CODEC = StreamCodec.composite(MicrowaveRecipeSerializer.createNonNullListStreamCodec(Ingredient.CONTENTS_STREAM_CODEC), MicrowaveRecipe::getIngredients, (StreamCodec)ItemStack.STREAM_CODEC, MicrowaveRecipe::getFirstOutput, MicrowaveRecipe::new);

    private static <T> StreamCodec<RegistryFriendlyByteBuf, NonNullList<T>> createNonNullListStreamCodec(StreamCodec<RegistryFriendlyByteBuf, T> elementCodec) {
        return StreamCodec.of((buffer, list) -> {
            buffer.writeVarInt(list.size());
            for (Object element : list) {
                elementCodec.encode(buffer, element);
            }
        }, buffer -> {
            int size = buffer.readVarInt();
            NonNullList list = NonNullList.create();
            for (int i = 0; i < size; ++i) {
                list.add(elementCodec.decode(buffer));
            }
            return list;
        });
    }

    public MapCodec<MicrowaveRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, MicrowaveRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

