/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury.screen;

import com.yablon.furnitury.block.entity.FurnitureWorkbenchBlockEntity;
import com.yablon.furnitury.screen.ModMenuTypes;
import com.yablon.furnitury.screen.OutputSlot;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class FurnitureWorkbenchMenu
extends AbstractContainerMenu {
    public final FurnitureWorkbenchBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private final ItemStackHandler internal;
    public final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();

    public FurnitureWorkbenchMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()), (ContainerData)new SimpleContainerData(2));
    }

    public FurnitureWorkbenchMenu(int pContainerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.FURNITURE_WORKBENCH_MENU.get(), pContainerId);
        FurnitureWorkbenchMenu.checkContainerSize((Container)inv, (int)11);
        this.blockEntity = (FurnitureWorkbenchBlockEntity)entity;
        this.level = inv.player.level();
        this.data = data;
        if (entity instanceof FurnitureWorkbenchBlockEntity) {
            FurnitureWorkbenchBlockEntity storageCrafterBlockEntity = (FurnitureWorkbenchBlockEntity)entity;
            this.internal = storageCrafterBlockEntity.getItemHandler();
        } else {
            this.internal = new ItemStackHandler(11);
        }
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        int startX = 58;
        int startY = 17;
        int slotSizePlus2 = 18;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int slotIndex = col + row * 3;
                SlotItemHandler slot = new SlotItemHandler((IItemHandler)this.internal, slotIndex, startX + col * slotSizePlus2, startY + row * slotSizePlus2);
                this.customSlots.put(slotIndex, this.addSlot((Slot)slot));
            }
        }
        SlotItemHandler inputSlot = new SlotItemHandler((IItemHandler)this.internal, 9, startX - slotSizePlus2 - 29, startY + slotSizePlus2);
        this.customSlots.put(9, this.addSlot((Slot)inputSlot));
        OutputSlot outputSlot = new OutputSlot((IItemHandler)this.internal, 10, startX + 3 * slotSizePlus2 + 34, startY + slotSizePlus2){

            public void onTake(Player player, ItemStack stack) {
                super.onTake(player, stack);
                FurnitureWorkbenchMenu.this.onSlotChanged(10, 1, 0);
            }
        };
        this.customSlots.put(10, this.addSlot((Slot)outputSlot));
        this.addDataSlots(data);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressArrowSize = 26;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index == 10) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, true)) {
                return ItemStack.EMPTY;
            }
            sourceSlot.set(ItemStack.EMPTY);
            this.blockEntity.consumeResources();
            this.blockEntity.getLevel().scheduleTick(this.blockEntity.getBlockPos(), this.blockEntity.getBlockState().getBlock(), 1);
        } else if (index < 36 ? !this.moveItemStackTo(sourceStack, 36, this.slots.size(), false) : !this.moveItemStackTo(sourceStack, 0, 36, false)) {
            return ItemStack.EMPTY;
        }
        if (sourceStack.isEmpty()) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(player, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player pPlayer) {
        return FurnitureWorkbenchMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)pPlayer, (Block)this.level.getBlockState(this.blockEntity.getBlockPos()).getBlock());
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    private void onSlotChanged(int slotId, int ctype, int meta) {
    }
}

