/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury.block.entity;

import com.yablon.furnitury.block.entity.ModBlockEntities;
import com.yablon.furnitury.item.ModItems;
import com.yablon.furnitury.screen.TrashcanMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrashcanBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(3);
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int SECOND_OUTPUT_SLOT = 2;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> TrashcanBlockEntity.this.progress;
                case 1 -> TrashcanBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    TrashcanBlockEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    TrashcanBlockEntity.this.maxProgress = pValue;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 78;

    public TrashcanBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.TRASHCAN_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.furnitury.trashcan");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new TrashcanMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("trashcan.progress", this.progress);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("trashcan.progress");
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (this.canCraft()) {
            this.increaseCraftingProgress();
            TrashcanBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private boolean canCraft() {
        return !this.itemHandler.getStackInSlot(0).m_41619_() && this.canInsertAmountIntoOutputSlot(1, 1) && this.canInsertItemIntoOutputSlot(1, (Item)ModItems.TRASH.get()) && this.canInsertAmountIntoOutputSlot(2, 1) && this.canInsertItemIntoOutputSlot(2, (Item)ModItems.TRASH_PIECE.get());
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)ModItems.TRASH.get(), this.itemHandler.getStackInSlot(1).m_41613_() + 1));
        if (Math.random() < (double)0.1f) {
            this.itemHandler.setStackInSlot(2, new ItemStack((ItemLike)ModItems.TRASH_PIECE.get(), this.itemHandler.getStackInSlot(2).m_41613_() + 1));
        }
    }

    private boolean canInsertItemIntoOutputSlot(int slot, Item item) {
        return this.itemHandler.getStackInSlot(slot).m_41619_() || this.itemHandler.getStackInSlot(slot).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int slot, int count) {
        return this.itemHandler.getStackInSlot(slot).m_41613_() + count <= this.itemHandler.getStackInSlot(slot).m_41741_();
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }
}

