/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.oie.fabric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.litetex.oie.OIE;
import net.litetex.oie.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricOIE
implements ModInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(FabricOIE.class);
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public void onInitialize() {
        Config config = this.loadConfig();
        OIE.setInstance(new OIE(config));
        LOG.debug("Initialized");
    }

    private Path configFilePath() {
        return FabricLoader.getInstance().getConfigDir().resolve("oie.json");
    }

    private Config loadConfig() {
        Path configFilePath = this.configFilePath();
        if (Files.exists(configFilePath, new LinkOption[0])) {
            try {
                return (Config)this.gson.fromJson(Files.readString(configFilePath), Config.class);
            }
            catch (Exception ex) {
                LOG.warn("Failed to read config file", (Throwable)ex);
            }
        }
        Config defaultConfig = Config.createDefault();
        this.saveConfig(defaultConfig);
        return defaultConfig;
    }

    private void saveConfig(Config config) {
        try {
            Files.writeString(this.configFilePath(), (CharSequence)this.gson.toJson((Object)config), new OpenOption[0]);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Failed to save config", ioe);
        }
    }
}

