/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.oie.metric.provider;

import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.function.Consumer;
import net.litetex.oie.OIE;
import net.litetex.oie.metric.provider.MetricSampler;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.function.TriFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetricSampler<M extends ObservableMeasurement>
implements MetricSampler {
    protected final boolean isDebug;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String name;
    protected final TriFunction<Meter, String, Consumer<M>, AutoCloseable> buildWithCallback;
    protected AutoCloseable observable;
    protected MinecraftServer server;

    protected AbstractMetricSampler(String name, TriFunction<Meter, String, Consumer<M>, AutoCloseable> buildWithCallback) {
        this.isDebug = this.logger.isDebugEnabled();
        this.name = name;
        this.buildWithCallback = buildWithCallback;
    }

    protected static AutoCloseable doubleGauge(Meter meter, String name, Consumer<ObservableDoubleMeasurement> c) {
        return meter.gaugeBuilder(AbstractMetricSampler.buildMetricName(name)).buildWithCallback(c);
    }

    protected static AutoCloseable longGauge(Meter meter, String name, Consumer<ObservableLongMeasurement> c) {
        return meter.gaugeBuilder(AbstractMetricSampler.buildMetricName(name)).ofLongs().buildWithCallback(c);
    }

    protected static AutoCloseable longCounter(Meter meter, String name, Consumer<ObservableLongMeasurement> c) {
        return meter.counterBuilder(AbstractMetricSampler.buildMetricName(name)).buildWithCallback(c);
    }

    protected static String buildMetricName(String name) {
        return OIE.instance().config().getMetrics().getPrefix() + name;
    }

    protected OIE oie() {
        return OIE.instance();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void register(Meter meter, MinecraftServer server) {
        if (this.observable != null) {
            this.logger.warn("Already registered {}, skipping", (Object)this.getClass().getSimpleName());
            return;
        }
        this.observable = (AutoCloseable)this.buildWithCallback.apply((Object)meter, (Object)this.name, this::doSample);
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSample(M measurement) {
        long startNanos = this.isDebug ? System.nanoTime() : 0L;
        try {
            this.sample(measurement);
        }
        catch (Exception ex) {
            this.logger.warn("Failed to sample {}", (Object)this.name, (Object)ex);
        }
        finally {
            if (this.isDebug) {
                this.logger.debug("Finished sampling {}, took {}ns", (Object)this.name, (Object)(System.nanoTime() - startNanos));
            }
        }
    }

    protected abstract void sample(M var1);

    @Override
    public void close() {
        if (this.observable != null) {
            try {
                this.observable.close();
            }
            catch (Exception ex) {
                this.logger.warn("Failed to close observable", (Throwable)ex);
            }
            this.observable = null;
        }
    }
}

