/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.oie.metric.provider;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.litetex.oie.metric.measurement.TypedObservableDoubleMeasurement;
import net.litetex.oie.metric.measurement.TypedObservableLongMeasurement;
import net.litetex.oie.metric.measurement.TypedObservableMeasurement;
import net.litetex.oie.metric.provider.AbstractMetricSampler;
import org.apache.commons.lang3.function.TriFunction;

public abstract class CachedMetricSampler<T extends Number, M extends TypedObservableMeasurement<T>>
extends AbstractMetricSampler<M> {
    protected Map<Attributes, T> cachedSamples = new HashMap<Attributes, T>();
    protected boolean attributeAlwaysNull;

    protected CachedMetricSampler(String name, TriFunction<Meter, String, Consumer<M>, AutoCloseable> buildWithCallback) {
        super(name, buildWithCallback);
    }

    protected static AutoCloseable typedDoubleGauge(Meter meter, String name, Consumer<TypedObservableDoubleMeasurement> c) {
        return meter.gaugeBuilder(CachedMetricSampler.buildMetricName(name)).buildWithCallback(m -> c.accept(new TypedObservableDoubleMeasurement((ObservableDoubleMeasurement)m)));
    }

    protected static AutoCloseable typedLongGauge(Meter meter, String name, Consumer<TypedObservableLongMeasurement> c) {
        return meter.gaugeBuilder(CachedMetricSampler.buildMetricName(name)).ofLongs().buildWithCallback(m -> c.accept(new TypedObservableLongMeasurement((ObservableLongMeasurement)m)));
    }

    protected static AutoCloseable typedLongCounter(Meter meter, String name, Consumer<TypedObservableLongMeasurement> c) {
        return meter.counterBuilder(CachedMetricSampler.buildMetricName(name)).buildWithCallback(m -> c.accept(new TypedObservableLongMeasurement((ObservableLongMeasurement)m)));
    }

    protected abstract boolean shouldSample();

    @Override
    protected void sample(M measurement) {
        if (!this.shouldSample()) {
            this.cachedSamples.forEach((attr, val) -> this.record(measurement, (T)val, (Attributes)attr));
            return;
        }
        Map<Attributes, T> samples = this.getSamples();
        samples.forEach((attr, val) -> this.record(measurement, (T)val, (Attributes)attr));
        this.onSampled(samples, measurement);
    }

    protected void onSampled(Map<Attributes, T> samples, M measurement) {
        this.cachedSamples = samples;
    }

    protected void record(M measurement, T value, Attributes attr) {
        if (this.attributeAlwaysNull) {
            measurement.record(value);
            return;
        }
        measurement.record(value, attr);
    }

    protected abstract Map<Attributes, T> getSamples();

    @Override
    public void close() {
        super.close();
        this.cachedSamples = null;
    }
}

