/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.oie.metric.provider;

import io.opentelemetry.api.metrics.Meter;
import java.util.function.Consumer;
import net.litetex.oie.metric.ServerPausedSamplerCondition;
import net.litetex.oie.metric.measurement.TypedObservableMeasurement;
import net.litetex.oie.metric.provider.CachedMetricSampler;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.function.TriFunction;

public abstract class PausableMetricSampler<T extends Number, M extends TypedObservableMeasurement<T>>
extends CachedMetricSampler<T, M> {
    protected ServerPausedSamplerCondition serverPausedSamplerCondition;

    protected PausableMetricSampler(String name, TriFunction<Meter, String, Consumer<M>, AutoCloseable> buildWithCallback) {
        super(name, buildWithCallback);
    }

    @Override
    public void register(Meter meter, MinecraftServer server) {
        this.serverPausedSamplerCondition = this.oie().config().getMetrics().isFreezeWhenServerPaused() ? ServerPausedSamplerCondition.create(server) : null;
        super.register(meter, server);
    }

    @Override
    protected boolean shouldSample() {
        return this.serverPausedSamplerCondition == null || this.serverPausedSamplerCondition.shouldSample(this.server);
    }

    @Override
    public void close() {
        super.close();
        this.serverPausedSamplerCondition = null;
    }
}

