/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.oie.mixin;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongCounter;
import net.litetex.oie.OIE;
import net.litetex.oie.OIECustomMetricInitializer;
import net.litetex.oie.metric.CommonAttributeKeys;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2806;
import net.minecraft.class_2807;
import net.minecraft.class_5321;
import net.minecraft.class_6611;
import net.minecraft.class_6613;
import net.minecraft.class_9767;
import net.minecraft.class_9770;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_9770.class})
public abstract class ChunkGenerationStepMixin {
    @Unique
    private static final AttributeKey<String> STATUS = AttributeKey.stringKey((String)"status");
    @Unique
    private static final AttributeKey<Long> STATUS_INDEX = AttributeKey.longKey((String)"status_index");
    @Unique
    private static LongCounter timesCalled;
    @Unique
    private static LongCounter duration;
    @Shadow
    @Final
    class_2806 comp_2803;

    @Inject(method={"<init>(Lnet/minecraft/class_2806;Lnet/minecraft/class_9767;Lnet/minecraft/class_9767;ILnet/minecraft/class_2807;)V"}, at={@At(value="RETURN")})
    public void init(class_2806 chunkStatus, class_9767 generationDependencies, class_9767 generationDependencies2, int i, class_2807 generationTask, CallbackInfo ci) {
        OIECustomMetricInitializer.executeWhenReady(ChunkGenerationStepMixin.class, creator -> {
            timesCalled = creator.createLongCounter("chunk_generation_step_count");
            duration = creator.createLongCounter("chunk_generation_step_duration_ms");
        });
    }

    @Redirect(method={"method_60560(Lnet/minecraft/class_9312;Lnet/minecraft/class_9762;Lnet/minecraft/class_2791;)Ljava/util/concurrent/CompletableFuture;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_6611;method_38655(Lnet/minecraft/class_1923;Lnet/minecraft/class_5321;Ljava/lang/String;)Lnet/minecraft/class_6613;"))
    public class_6613 redirectFlightProfilerStartChunkGenerationProfiling(class_6611 profiler, class_1923 pos, class_5321<class_1937> worldRegistryKey, String id) {
        if (timesCalled == null && duration == null) {
            return profiler.method_38655(pos, worldRegistryKey, id);
        }
        Attributes attributes = Attributes.builder().put(CommonAttributeKeys.WORLD, (Object)OIE.instance().formatIdentifier(worldRegistryKey.method_29177())).put(STATUS, (Object)id).put(STATUS_INDEX, (Object)this.comp_2803.method_16559()).build();
        if (timesCalled != null) {
            timesCalled.add(1L, attributes);
        }
        class_6613 originalFinishable = profiler.method_38655(pos, worldRegistryKey, id);
        if (duration == null) {
            return originalFinishable;
        }
        long startMs = System.currentTimeMillis();
        return success -> {
            if (originalFinishable != null) {
                originalFinishable.finish(success);
            }
            duration.add(System.currentTimeMillis() - startMs, attributes);
        };
    }
}

