/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.oie;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.metrics.DoubleGauge;
import io.opentelemetry.api.metrics.DoubleGaugeBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.LongGauge;
import io.opentelemetry.api.metrics.LongGaugeBuilder;
import io.opentelemetry.api.metrics.Meter;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.litetex.oie.OIE;
import net.litetex.oie.config.MetricsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIEMetricsCreator {
    private static final Logger LOG = LoggerFactory.getLogger(OIEMetricsCreator.class);
    private final OIE oie;
    private final MetricsConfig metricsConfig;

    public OIEMetricsCreator(OIE oie) {
        this.oie = oie;
        this.metricsConfig = oie.config().getMetrics();
    }

    public Meter getMeter() {
        return GlobalOpenTelemetry.getMeter((String)this.oie.instrumentationName());
    }

    protected String createMetricName(String name) {
        return this.metricsConfig.getPrefix() + name;
    }

    public boolean isMetricActive(String name) {
        if (!this.metricsConfig.getEnabledOnly().isEmpty()) {
            return this.metricsConfig.getEnabledOnly().contains(name);
        }
        if (this.metricsConfig.getDisabled().contains(name)) {
            return false;
        }
        if (this.metricsConfig.getEnabledAdditionally().contains(name)) {
            return true;
        }
        return !MetricsConfig.DEFAULT_DISABLED.contains(name);
    }

    public <M, B> M createMetric(BiFunction<Meter, String, B> createBuilder, Function<B, M> build, String name, Consumer<B> customizeBuilder) {
        if (!this.isMetricActive(name)) {
            return null;
        }
        B builder = createBuilder.apply(this.getMeter(), this.createMetricName(name));
        if (customizeBuilder != null) {
            customizeBuilder.accept(builder);
        }
        M metric = build.apply(builder);
        LOG.debug("Built {} for {}", (Object)metric.getClass().getSimpleName(), (Object)name);
        return metric;
    }

    public LongCounter createLongCounter(String name) {
        return this.createLongCounter(name, null);
    }

    public LongCounter createLongCounter(String name, Consumer<LongCounterBuilder> customizeBuilder) {
        return this.createMetric(Meter::counterBuilder, LongCounterBuilder::build, name + this.metricsConfig.getCounterSuffix(), customizeBuilder);
    }

    public DoubleGauge createDoubleGauge(String name) {
        return this.createDoubleGauge(name, null);
    }

    public DoubleGauge createDoubleGauge(String name, Consumer<DoubleGaugeBuilder> customizeBuilder) {
        return this.createMetric(Meter::gaugeBuilder, DoubleGaugeBuilder::build, name, customizeBuilder);
    }

    public LongGauge createLongGauge(String name) {
        return this.createLongGauge(name, null);
    }

    public LongGauge createLongGauge(String name, Consumer<LongGaugeBuilder> customizeBuilder) {
        return this.createMetric((meter, gaugeName) -> meter.gaugeBuilder(gaugeName).ofLongs(), LongGaugeBuilder::build, name, customizeBuilder);
    }
}

