/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.oie.metric.provider.builtin.player_detail;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.authlib.GameProfile;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import java.util.Map;
import java.util.stream.Collectors;
import net.litetex.oie.metric.CommonAttributeKeys;
import net.litetex.oie.metric.measurement.TypedObservableLongMeasurement;
import net.litetex.oie.metric.provider.CachedMetricSampler;
import net.litetex.oie.metric.provider.PausableNullSettingMetricSampler;
import net.minecraft.class_1934;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class PlayersOnlineSampler
extends PausableNullSettingMetricSampler<Long, TypedObservableLongMeasurement> {
    private static final AttributeKey<String> GAME_MODE = AttributeKey.stringKey((String)"game_mode");
    protected BiMap<AttributeCacheKey, Attributes> playerAttributeCache = HashBiMap.create();

    public PlayersOnlineSampler() {
        super("players_online", (x$0, x$1, x$2) -> CachedMetricSampler.typedLongGauge(x$0, x$1, x$2), 0L);
    }

    @Override
    protected Map<Attributes, Long> getSamples() {
        return this.server.method_3760().method_14571().stream().collect(Collectors.toMap(player -> (Attributes)this.playerAttributeCache.computeIfAbsent((Object)new AttributeCacheKey((class_3222)player), key -> Attributes.builder().put(CommonAttributeKeys.NAME, (Object)key.profile().name()).put(CommonAttributeKeys.UUID, (Object)key.profile().id().toString()).put(CommonAttributeKeys.WORLD, (Object)this.oie().formatWorldName(key.world())).put(GAME_MODE, (Object)key.gameMode().name()).build()), player -> 1L));
    }

    @Override
    protected void handlePreviousRemoved(TypedObservableLongMeasurement measurement, Attributes attr) {
        super.handlePreviousRemoved(measurement, attr);
        this.playerAttributeCache.inverse().remove((Object)attr);
    }

    @Override
    public void close() {
        super.close();
        this.playerAttributeCache = null;
    }

    protected record AttributeCacheKey(GameProfile profile, class_3218 world, class_1934 gameMode) {
        public AttributeCacheKey(class_3222 player) {
            this(player.method_7334(), player.method_51469(), player.field_13974.method_14257());
        }
    }
}

