/*
 * Decompiled with CFR 0.152.
 */
package host.plas.worldlock.configs;

import gg.drak.thebase.objects.handling.derived.IModifierEventable;
import gg.drak.thebase.storage.resources.flat.simple.SimpleConfiguration;
import host.plas.worldlock.WorldLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentSkipListSet;

public class MyConfig
extends SimpleConfiguration {
    private static ConcurrentSkipListSet<String> loadedLockedWorlds;

    public MyConfig() {
        super("config.yml", (IModifierEventable)WorldLock.getInstance(), false);
    }

    public void init() {
        this.loadLockedWorlds();
    }

    public void loadLockedWorlds() {
        loadedLockedWorlds = this.getLockedWorlds();
    }

    public void reloadFromConfig() {
        this.loadLockedWorlds();
    }

    public void saveToConfig() {
        this.setLockedWorlds(MyConfig.getLoadedLockedWorlds());
    }

    public ConcurrentSkipListSet<String> getLockedWorlds() {
        this.reloadResource();
        return new ConcurrentSkipListSet<String>((Collection)this.getOrSetDefault("locked-worlds", new ArrayList()));
    }

    public void addLockedWorld(String world) {
        loadedLockedWorlds.add(world);
        this.saveToConfig();
    }

    public void removeLockedWorld(String world) {
        loadedLockedWorlds.remove(world);
        this.saveToConfig();
    }

    public boolean isLockedWorld(String world) {
        return MyConfig.getLoadedLockedWorlds().contains(world);
    }

    public void clearLockedWorlds() {
        loadedLockedWorlds.clear();
        this.saveToConfig();
    }

    public void setLockedWorlds(ConcurrentSkipListSet<String> lockedWorlds) {
        this.write("locked-worlds", new ArrayList<String>(lockedWorlds));
    }

    public static ConcurrentSkipListSet<String> getLoadedLockedWorlds() {
        return loadedLockedWorlds;
    }

    public static void setLoadedLockedWorlds(ConcurrentSkipListSet<String> loadedLockedWorlds) {
        MyConfig.loadedLockedWorlds = loadedLockedWorlds;
    }
}

