/*
 * Decompiled with CFR 0.152.
 */
package host.plas.worldlock.events;

import gg.drak.thebase.async.AsyncUtils;
import host.plas.bou.commands.Sender;
import host.plas.worldlock.WorldLock;
import host.plas.worldlock.events.NotificationTimer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class MainListener
implements Listener {
    public MainListener() {
        WorldLock.getInstance().logInfo("MainListener has been registered!");
    }

    @EventHandler
    public void onWorldEnter(PlayerMoveEvent event) {
        this.onOtherWorld(event);
    }

    @EventHandler
    public void onWorldEnter(PlayerPortalEvent event) {
        this.onOtherWorld((PlayerMoveEvent)event);
    }

    @EventHandler
    public void onWorldEnter(PlayerTeleportEvent event) {
        this.onOtherWorld((PlayerMoveEvent)event);
    }

    public void onOtherWorld(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Location from = event.getFrom();
        Location to = event.getTo();
        if (to == null) {
            return;
        }
        World fromWorld = from.getWorld();
        World toWorld = to.getWorld();
        boolean bypassPerm = player.hasPermission("worldlock.bypass." + toWorld.getName());
        if (fromWorld == null || toWorld == null) {
            return;
        }
        if (fromWorld != toWorld && WorldLock.getMyConfig().isLockedWorld(toWorld.getName())) {
            if (bypassPerm) {
                return;
            }
            event.setCancelled(true);
            if (!NotificationTimer.hasNotification(toWorld.getName(), player)) {
                Sender sender = new Sender((CommandSender)player);
                sender.sendMessage("&cThis world is locked!");
                NotificationTimer.addNotification(toWorld.getName(), player).ifPresentOrElse(p -> {}, () -> WorldLock.getInstance().logDebug("Failed to add notification timer for player " + player.getName() + " in world " + toWorld.getName() + "!"));
            }
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        AsyncUtils.executeAsync(() -> {
            Player player = event.getPlayer();
            Bukkit.getWorlds().forEach(world -> {
                boolean t = player.hasPermission("worldlock.bypass." + world.getName());
            });
        });
    }
}

