/*
 * Decompiled with CFR 0.152.
 */
package host.plas.worldlock.events;

import host.plas.bou.scheduling.BaseRunnable;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class NotificationTimer
extends BaseRunnable
implements Comparable<NotificationTimer> {
    private static ConcurrentSkipListSet<NotificationTimer> notifications = new ConcurrentSkipListSet();
    private String identifier;
    private Player player;

    public static Optional<NotificationTimer> addNotification(String identifier, Player player) {
        if (NotificationTimer.hasNotification(identifier, player)) {
            return Optional.empty();
        }
        NotificationTimer notificationTimer = new NotificationTimer(identifier, player);
        notifications.add(notificationTimer);
        return Optional.of(notificationTimer);
    }

    public static void removeNotification(String identifier, Player player) {
        if (!NotificationTimer.hasNotification(identifier, player)) {
            return;
        }
        NotificationTimer.getNotificationTimer(identifier, player).ifPresent(notification -> notifications.remove(notification));
    }

    public static Optional<NotificationTimer> getNotificationTimer(String identifier, Player player) {
        AtomicReference notificationTimer = new AtomicReference();
        notifications.forEach(notification -> {
            if (notification.getIdentifier().equals(identifier) && notification.getPlayer().getUniqueId().equals(player.getUniqueId())) {
                notificationTimer.set(notification);
            }
        });
        return Optional.ofNullable((NotificationTimer)notificationTimer.get());
    }

    public static boolean hasNotification(String identifier, Player player) {
        return NotificationTimer.getNotificationTimer(identifier, player).isPresent();
    }

    private NotificationTimer(String identifier, Player player) {
        super(100L, 1L);
        this.identifier = identifier;
        this.player = player;
    }

    public void run() {
        NotificationTimer.removeNotification(this.identifier, this.player);
        this.cancel();
    }

    @Override
    public int compareTo(@NotNull NotificationTimer o) {
        return this.getIdentifier().compareTo(o.getIdentifier());
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public static ConcurrentSkipListSet<NotificationTimer> getNotifications() {
        return notifications;
    }

    public static void setNotifications(ConcurrentSkipListSet<NotificationTimer> notifications) {
        NotificationTimer.notifications = notifications;
    }
}

