/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.block.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.svisvi.jigsawpp.block.entity.init.ModBlockEntities;
import net.svisvi.jigsawpp.block.lenin_bust.LeninBustBlock;

public class LeninBustBlockEntity
extends BeehiveBlockEntity {
    public static final String TAG_FLOWER_POS = "FlowerPos";
    public static final String MIN_OCCUPATION_TICKS = "MinOccupationTicks";
    public static final String ENTITY_DATA = "EntityData";
    public static final String TICKS_IN_HIVE = "TicksInHive";
    public static final String HAS_NECTAR = "HasNectar";
    public static final String BEES = "Bees";
    private static final List<String> IGNORED_BEE_TAGS = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "CannotEnterHiveTicks", "TicksSincePollination", "CropsGrownSincePollination", "HivePos", "Passengers", "Leash", "UUID");
    public static final int MAX_OCCUPANTS = 3;
    private static final int MIN_TICKS_BEFORE_REENTERING_HIVE = 400;
    private static final int MIN_OCCUPATION_TICKS_NECTAR = 2400;
    public static final int MIN_OCCUPATION_TICKS_NECTARLESS = 600;
    private final List<BeeData> stored = Lists.newArrayList();
    @Nullable
    private BlockPos savedFlowerPos;

    public LeninBustBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState);
    }

    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)ModBlockEntities.LENIN_BUST_BE.get();
    }

    public static int m_58752_(BlockState pState) {
        return (Integer)pState.m_61143_((Property)LeninBustBlock.HONEY_LEVEL);
    }

    public List<Entity> m_58759_(BlockState pState, BeehiveBlockEntity.BeeReleaseStatus pReleaseStatus) {
        ArrayList $$2 = Lists.newArrayList();
        this.stored.removeIf(p_272556_ -> LeninBustBlockEntity.releaseOccupant(this.f_58857_, this.f_58858_, pState, p_272556_, $$2, pReleaseStatus, this.savedFlowerPos));
        if (!$$2.isEmpty()) {
            super.m_6596_();
        }
        return $$2;
    }

    public static void m_155149_(Level pLevel, BlockPos pPos, BlockState pState, List<BeeData> pData, @Nullable BlockPos pSavedFlowerPos) {
        boolean $$5 = false;
        Iterator<BeeData> $$6 = pData.iterator();
        while ($$6.hasNext()) {
            BeeData $$7 = $$6.next();
            if ($$7.ticksInHive > $$7.minOccupationTicks) {
                BeehiveBlockEntity.BeeReleaseStatus $$8;
                BeehiveBlockEntity.BeeReleaseStatus beeReleaseStatus = $$8 = $$7.entityData.m_128471_(HAS_NECTAR) ? BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED : BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED;
                if (LeninBustBlockEntity.releaseOccupant(pLevel, pPos, pState, $$7, null, $$8, pSavedFlowerPos)) {
                    $$5 = true;
                    $$6.remove();
                }
            }
            ++$$7.ticksInHive;
        }
        if ($$5) {
            LeninBustBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, LeninBustBlockEntity pBeehive) {
        LeninBustBlockEntity.m_155149_(pLevel, pPos, pState, pBeehive.stored, pBeehive.savedFlowerPos);
        if (!pBeehive.stored.isEmpty() && pLevel.m_213780_().m_188500_() < 0.005) {
            double $$4 = (double)pPos.m_123341_() + 0.5;
            double $$5 = pPos.m_123342_();
            double $$6 = (double)pPos.m_123343_() + 0.5;
            pLevel.m_6263_((Player)null, $$4, $$5, $$6, SoundEvents.f_11698_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        DebugPackets.m_179510_((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (BeehiveBlockEntity)pBeehive);
    }

    public static boolean releaseOccupant(Level pLevel, BlockPos pPos, BlockState pState, BeeData pData, @Nullable List<Entity> pStoredInHives, BeehiveBlockEntity.BeeReleaseStatus pReleaseStatus, @Nullable BlockPos pSavedFlowerPos) {
        boolean $$10;
        if ((pLevel.m_46462_() || pLevel.m_46471_()) && pReleaseStatus != BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY) {
            return false;
        }
        CompoundTag $$7 = pData.entityData.m_6426_();
        LeninBustBlockEntity.m_155161_((CompoundTag)$$7);
        $$7.m_128365_("HivePos", (Tag)NbtUtils.m_129224_((BlockPos)pPos));
        $$7.m_128379_("NoGravity", true);
        Direction $$8 = (Direction)pState.m_61143_((Property)LeninBustBlock.FACING);
        BlockPos $$9 = pPos.m_121945_($$8);
        boolean bl = $$10 = !pLevel.m_8055_($$9).m_60812_((BlockGetter)pLevel, $$9).m_83281_();
        if ($$10 && pReleaseStatus != BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY) {
            return false;
        }
        Entity $$11 = EntityType.m_20645_((CompoundTag)$$7, (Level)pLevel, p_58740_ -> p_58740_);
        if ($$11 != null) {
            if (!$$11.m_6095_().m_204039_(EntityTypeTags.f_13122_)) {
                return false;
            }
            if ($$11 instanceof Bee) {
                Bee $$12 = (Bee)$$11;
                if (pSavedFlowerPos != null && !$$12.m_27852_() && pLevel.f_46441_.m_188501_() < 0.9f) {
                    $$12.m_27876_(pSavedFlowerPos);
                }
                if (pReleaseStatus == BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED) {
                    int $$13;
                    $$12.m_27864_();
                    if (pState.m_204338_(BlockTags.f_13072_, p_202037_ -> p_202037_.m_61138_((Property)LeninBustBlock.HONEY_LEVEL)) && ($$13 = LeninBustBlockEntity.m_58752_(pState)) < 5) {
                        int $$14;
                        int n = $$14 = pLevel.f_46441_.m_188503_(100) == 0 ? 2 : 1;
                        if ($$13 + $$14 > 5) {
                            --$$14;
                        }
                        pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)LeninBustBlock.HONEY_LEVEL, (Comparable)Integer.valueOf($$13 + $$14)));
                    }
                }
                LeninBustBlockEntity.m_58736_((int)pData.ticksInHive, (Bee)$$12);
                if (pStoredInHives != null) {
                    pStoredInHives.add((Entity)$$12);
                }
                float $$15 = $$11.m_20205_();
                double $$16 = $$10 ? 0.0 : 0.55 + (double)($$15 / 2.0f);
                double $$17 = (double)pPos.m_123341_() + 0.5 + $$16 * (double)$$8.m_122429_();
                double $$18 = (double)pPos.m_123342_() + 0.5 - (double)($$11.m_20206_() / 2.0f);
                double $$19 = (double)pPos.m_123343_() + 0.5 + $$16 * (double)$$8.m_122431_();
                $$11.m_7678_($$17, $$18, $$19, $$11.m_146908_(), $$11.m_146909_());
            }
            pLevel.m_5594_((Player)null, pPos, SoundEvents.f_11696_, SoundSource.BLOCKS, 1.0f, 1.0f);
            pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223719_((Entity)$$11, (BlockState)pLevel.m_8055_(pPos)));
            return pLevel.m_7967_($$11);
        }
        return false;
    }

    public void m_58741_(Entity pOccupant, boolean pHasNectar) {
        BlockState pState = this.m_58900_();
        this.m_58744_(pOccupant, pHasNectar, 0);
    }

    public void m_58744_(Entity pOccupant, boolean pHasNectar, int pTicksInHive) {
        if (this.stored.size() < 3) {
            pOccupant.m_8127_();
            pOccupant.m_20153_();
            CompoundTag $$3 = new CompoundTag();
            pOccupant.m_20223_($$3);
            this.m_155157_($$3, pTicksInHive, pHasNectar);
            if (this.f_58857_ != null) {
                Bee $$4;
                if (pOccupant instanceof Bee && ($$4 = (Bee)pOccupant).m_27852_() && (!this.m_58780_() || this.f_58857_.f_46441_.m_188499_())) {
                    this.savedFlowerPos = $$4.m_27851_();
                }
                BlockPos $$5 = this.m_58899_();
                this.f_58857_.m_6263_((Player)null, (double)$$5.m_123341_(), (double)$$5.m_123342_(), (double)$$5.m_123343_(), SoundEvents.f_11695_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.f_58857_.m_220407_(GameEvent.f_157792_, $$5, GameEvent.Context.m_223719_((Entity)pOccupant, (BlockState)this.m_58900_()));
            }
            pOccupant.m_146870_();
            super.m_6596_();
        }
    }

    public void m_155157_(CompoundTag pEntityData, int pTicksInHive, boolean pHasNectar) {
        this.stored.add(new BeeData(pEntityData, pTicksInHive, pHasNectar ? 2400 : 600));
    }

    private boolean m_58780_() {
        return this.savedFlowerPos != null;
    }

    private static class BeeData {
        final CompoundTag entityData;
        int ticksInHive;
        final int minOccupationTicks;

        BeeData(CompoundTag pEntityData, int pTicksInHive, int pMinOccupationTicks) {
            LeninBustBlockEntity.m_155161_((CompoundTag)pEntityData);
            this.entityData = pEntityData;
            this.ticksInHive = pTicksInHive;
            this.minOccupationTicks = pMinOccupationTicks;
        }
    }
}

