/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.block.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.block.entity.init.ModBlockEntities;
import net.svisvi.jigsawpp.block.factory_heater.FactoryHeatProducer;
import net.svisvi.jigsawpp.block.init.ModBlocks;
import net.svisvi.jigsawpp.block.purgen_factory.PurgenCatalystRecipeReader;
import net.svisvi.jigsawpp.block.purgen_factory.PurgenPiluleBuilder;
import net.svisvi.jigsawpp.client.screen.purgen_factory.PurgenFactoryMenu;
import net.svisvi.jigsawpp.effect.init.ModEffects;
import net.svisvi.jigsawpp.entity.emitters.PoopGasEmitterEntity;
import net.svisvi.jigsawpp.entity.emitters.PurgativeGasEmitterEntity;
import net.svisvi.jigsawpp.entity.init.ModEntities;
import net.svisvi.jigsawpp.entity.teapod.teapodSpider.TeapodSpider;
import net.svisvi.jigsawpp.gas.PurgativeGasClass;
import net.svisvi.jigsawpp.item.init.ModItems;
import net.svisvi.jigsawpp.item.pilule.AbstractPiluleItem;
import net.svisvi.jigsawpp.networking.ModMessages;
import net.svisvi.jigsawpp.networking.packet.FluidSyncS2CPacket;
import net.svisvi.jigsawpp.particles.ModParticleTypes;
import net.svisvi.jigsawpp.procedures.ut.DristExplosion;
import net.svisvi.jigsawpp.recipe.PurgenFactoryRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PurgenFactoryBlockEntity
extends BaseContainerBlockEntity
implements MenuProvider,
WorldlyContainer {
    private final ItemStackHandler itemHandler = new ItemStackHandler(8);
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private LazyOptional<IFluidHandler> lazyFluidHandler = LazyOptional.empty();
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 780;
    private int PROGRESS_ACCELERATOR = 5;
    public final FluidTank FLUID_TANK = new FluidTank(8000){

        protected void onContentsChanged() {
            PurgenFactoryBlockEntity.this.m_6596_();
            if (!PurgenFactoryBlockEntity.this.f_58857_.m_5776_()) {
                ModMessages.sendToClients(new FluidSyncS2CPacket(this.fluid, PurgenFactoryBlockEntity.this.f_58858_));
            }
        }

        public boolean isFluidValid(FluidStack stack) {
            return super.isFluidValid(stack);
        }
    };
    private static final int OUTPUT_SLOT = 6;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    public static final Map<String, Integer> badEvents = new HashMap<String, Integer>();
    public static final Map<Item, String> catalystEvents;

    public int partenSize() {
        int ret = 1;
        if (this.itemHandler.getStackInSlot(7) != ItemStack.f_41583_) {
            ret = this.itemHandler.getStackInSlot(7).m_41613_() + 1;
        }
        return ret;
    }

    public void setFluid(FluidStack stack) {
        this.FLUID_TANK.setFluid(stack);
    }

    public FluidStack getFluidStack() {
        return this.FLUID_TANK.getFluid();
    }

    public static void drainFluid(PurgenFactoryBlockEntity pEntity, int amount) {
    }

    public PurgenFactoryBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.PURGEN_FACTORY_BE.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> PurgenFactoryBlockEntity.this.progress;
                    case 1 -> PurgenFactoryBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        PurgenFactoryBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        PurgenFactoryBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 8;
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && side != null && cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (side == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        ModMessages.sendToClients(new FluidSyncS2CPacket(this.getFluidStack(), this.f_58858_));
        return new PurgenFactoryMenu(pContainerId, pPlayerInventory, (BlockEntity)this, this.data);
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return null;
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyFluidHandler = LazyOptional.of(() -> this.FLUID_TANK);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyFluidHandler.invalidate();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.jigsaw_pp.purgen_factory");
    }

    protected Component m_6820_() {
        return null;
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("purgen_factory.progress", this.progress);
        pTag.m_128365_("fluidTank", (Tag)this.FLUID_TANK.writeToNBT(new CompoundTag()));
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("purgen_factory.progress");
        Tag tag = pTag.m_128423_("fluidTank");
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.FLUID_TANK.readFromNBT(compoundTag);
        }
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        BlockPos belowPos = pPos.m_7495_();
        BlockState belowState = pLevel.m_8055_(belowPos);
        Block block = belowState.m_60734_();
        if (block instanceof FactoryHeatProducer) {
            float f;
            FactoryHeatProducer heater = (FactoryHeatProducer)block;
            float koeff = 1.0f;
            koeff = heater.getHeat(belowState, pLevel, belowPos);
            if (f > 0.0f) {
                PurgenFactoryBlockEntity.spawnHeatedIndicatedParticles(pLevel, pPos);
                if (this.canCraft()) {
                    PurgenFactoryBlockEntity.teapot_ticking((LevelAccessor)pLevel, pPos.m_123341_(), pPos.m_123342_(), pPos.m_123343_());
                    this.increaseCraftingProgress(koeff);
                    PurgenFactoryBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
                    if (this.hasProgressFinished()) {
                        if (this.craftItem(pLevel, pPos, pState)) {
                            PurgenFactoryBlockEntity.spawnFinishedParticles(pLevel, pPos);
                        }
                        this.resetProgress();
                    }
                } else {
                    this.resetProgress();
                }
            }
        }
    }

    public static void spawnHeatedIndicatedParticles(Level pLevel, BlockPos pPos) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)pLevel;
            _level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 1.2, (double)pPos.m_123343_() + 0.5, 5, 0.1, 0.2, 0.1, 0.0);
        }
    }

    public static void spawnFinishedParticles(Level pLevel, BlockPos pPos) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)pLevel;
            _level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 1.2, (double)pPos.m_123343_() + 0.5, 5, 0.1, 0.2, 0.1, 0.0);
        }
        pLevel.m_5594_(null, pPos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.brewing_stand.brew")), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static void spawnCancelFinishedParticles(Level pLevel, BlockPos pPos) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)pLevel;
            _level.m_8767_((ParticleOptions)ParticleTypes.f_123792_, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 1.2, (double)pPos.m_123343_() + 0.5, 5, 0.1, 0.2, 0.1, 0.0);
        }
        pLevel.m_5594_(null, pPos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.anvil.land")), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean craftItem(Level pLevel, BlockPos pPos, BlockState pState) {
        Optional<PurgenFactoryRecipe> recipe = this.getCurrentRecipe();
        ItemStack result = recipe.get().m_8043_(null);
        float malChance = recipe.get().getMalChance(null);
        ItemStack built_purgen = PurgenPiluleBuilder.build_main(recipe, this.itemHandler.getStackInSlot(2), this.itemHandler.getStackInSlot(3), this.itemHandler.getStackInSlot(4), this.f_58857_, pPos, pState);
        int pu_count = this.itemHandler.getStackInSlot(6).m_41613_() + built_purgen.m_41613_() * this.partenSize();
        if (this.itemHandler.getStackInSlot(6).m_41619_() || AbstractPiluleItem.comparePilules(built_purgen, this.itemHandler.getStackInSlot(6))) {
            this.itemHandler.extractItem(0, this.partenSize(), false);
            this.itemHandler.extractItem(1, this.partenSize(), false);
            this.itemHandler.extractItem(2, this.partenSize(), false);
            if (this.itemHandler.getStackInSlot(3) != ItemStack.f_41583_) {
                this.itemHandler.extractItem(3, this.partenSize(), false);
            }
            ItemStack catalyst_ = ItemStack.f_41583_;
            if (this.itemHandler.getStackInSlot(4) != ItemStack.f_41583_ && this.itemHandler.getStackInSlot(4).m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("jigsaw_pp:purgen_catalysts")))) {
                ItemStack catalyst = this.itemHandler.getStackInSlot(4).m_41777_();
                catalyst_ = catalyst.m_41777_();
                float mchmod = PurgenCatalystRecipeReader.getMalChanceK(PurgenCatalystRecipeReader.getCurrentRecipe(catalyst, pLevel).get());
                if ((double)malChance < 0.7 && mchmod >= 2.0f) {
                    mchmod *= 10.0f;
                }
                malChance *= mchmod > 0.0f ? mchmod : 1.0f;
                this.itemHandler.extractItem(4, 1, false);
                if (catalyst.m_41741_() == 1) {
                    System.out.println(PurgenCatalystRecipeReader.getOutput(PurgenCatalystRecipeReader.getCurrentRecipe(catalyst, pLevel).get()).toString());
                    this.itemHandler.setStackInSlot(4, PurgenCatalystRecipeReader.getOutput(PurgenCatalystRecipeReader.getCurrentRecipe(catalyst, pLevel).get()));
                }
            }
            this.itemHandler.extractItem(5, this.partenSize(), false);
            this.FLUID_TANK.drain(recipe.get().getFluidStack().getAmount() * this.partenSize(), IFluidHandler.FluidAction.EXECUTE);
            ItemStack retStack = built_purgen.m_255036_(pu_count);
            Random random = new Random();
            if (random.nextFloat() < malChance) {
                retStack = this.badEventHandler(pLevel, pPos, malChance, catalyst_, built_purgen, recipe);
            }
            this.itemHandler.setStackInSlot(6, retStack.m_255036_(pu_count));
            return true;
        }
        return false;
    }

    public static int sumMapValues(Map<String, Integer> map) {
        if (map == null || map.isEmpty()) {
            return 0;
        }
        int sum = 0;
        for (Integer value : map.values()) {
            sum += value.intValue();
        }
        return sum;
    }

    public static <K, V> K getKeyByIndex(LinkedHashMap<K, V> map, int index) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        if (index < 0 || index >= map.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of range");
        }
        ArrayList<K> keys = new ArrayList<K>(map.keySet());
        return (K)keys.get(index);
    }

    public ItemStack badEventHandler(Level world, BlockPos pPos, float malChance, ItemStack catalyst, ItemStack builtPurgen, Optional<PurgenFactoryRecipe> recipe) {
        ServerLevel _level;
        if (world instanceof ServerLevel && !(_level = (ServerLevel)world).m_5776_()) {
            String event = "";
            if (!catalyst.m_41619_() && catalystEvents.containsKey(catalyst.m_41720_())) {
                event = catalystEvents.get(catalyst.m_41720_());
            } else {
                int totalSum = PurgenFactoryBlockEntity.sumMapValues(badEvents);
                int random = world.f_46441_.m_188503_(totalSum);
                int cumulativeWeight = 0;
                for (Map.Entry<String, Integer> entry : badEvents.entrySet()) {
                    if (random >= (cumulativeWeight += entry.getValue().intValue())) continue;
                    event = entry.getKey();
                    break;
                }
            }
            switch (event) {
                case "poop_leak": {
                    DristExplosion.harmfulDristExplode(world, pPos, 6, Level.ExplosionInteraction.NONE, null);
                    break;
                }
                case "big_poop_leak": {
                    DristExplosion.harmfulDristExplode(world, pPos, 10, Level.ExplosionInteraction.NONE, null);
                    break;
                }
                case "teapodification": {
                    world.m_7731_(pPos, Blocks.f_50016_.m_49966_(), 3);
                    TeapodSpider entityToSpawn = new TeapodSpider((EntityType<? extends TeapodSpider>)((EntityType)ModEntities.TEAPOD_SPIDER.get()), (Level)_level);
                    _level.m_7967_((Entity)entityToSpawn);
                    _level.m_8767_((ParticleOptions)ParticleTypes.f_123803_, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), 20, 0.5, 0.5, 0.5, 0.0);
                    if (!_level.m_5776_()) {
                        _level.m_5594_(null, pPos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.enderman.death")), SoundSource.BLOCKS, 1.0f, 1.0f);
                        break;
                    }
                    _level.m_245747_(pPos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.enderman.death")), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    break;
                }
                case "teapotification": {
                    world.m_7731_(pPos, ((Block)ModBlocks.TEAPOT.get()).m_49966_(), 3);
                    _level.m_8767_((ParticleOptions)ParticleTypes.f_123803_, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), 20, 0.5, 0.5, 0.5, 0.0);
                    if (!_level.m_5776_()) {
                        _level.m_5594_(null, pPos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.piston.extend")), SoundSource.BLOCKS, 1.0f, 1.0f);
                        break;
                    }
                    _level.m_245747_(pPos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.piston.extend")), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    break;
                }
                case "explosion": {
                    _level.m_254849_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), 8.0f, Level.ExplosionInteraction.TNT);
                    ItemEntity eentityToSpawn = new ItemEntity((Level)_level, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), new ItemStack((ItemLike)ModBlocks.FACTORY_HEATER.get()));
                    eentityToSpawn.m_32010_(10);
                    _level.m_7967_((Entity)eentityToSpawn);
                    break;
                }
                case "poop_gas": {
                    PoopGasEmitterEntity emitter = new PoopGasEmitterEntity((Level)_level, pPos.m_123341_(), pPos.m_123342_(), (double)pPos.m_123343_(), 5.0f, 700);
                    _level.m_7967_((Entity)emitter);
                    break;
                }
                case "purgen_gas": {
                    List eflist = PotionUtils.m_43547_((ItemStack)builtPurgen);
                    eflist.add(new MobEffectInstance((MobEffect)ModEffects.PURGATIVE.get(), 200, 2));
                    PurgativeGasClass gassy = new PurgativeGasClass(eflist);
                    PurgativeGasEmitterEntity purgen_emitter = new PurgativeGasEmitterEntity((Level)_level, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), 5.0f, 700, gassy);
                    _level.m_7967_((Entity)purgen_emitter);
                    break;
                }
                default: {
                    System.out.println("Invalid purgen factory malfunction.");
                }
            }
            ItemStack ret = builtPurgen.m_41777_();
            Random rand = new Random();
            ret = PurgenPiluleBuilder.build_main(recipe, new ItemStack((ItemLike)ModItems.SWEET_BREAD.get()), new ItemStack((ItemLike)ModItems.SWEET_BREAD.get()), ItemStack.f_41583_, world, pPos, world.m_8055_(pPos));
            ret.m_41764_(builtPurgen.m_41613_());
            return ret;
        }
        return ItemStack.f_41583_;
    }

    public boolean canCraft() {
        if (!this.hasRecipe()) {
            return false;
        }
        return this.itemHandler.getStackInSlot(0).m_41613_() >= this.partenSize() && this.itemHandler.getStackInSlot(1).m_41613_() >= this.partenSize() && this.itemHandler.getStackInSlot(2).m_41613_() >= this.partenSize() && this.itemHandler.getStackInSlot(2).m_41720_().m_41472_() && (this.itemHandler.getStackInSlot(3).m_41613_() >= this.partenSize() && this.itemHandler.getStackInSlot(3).m_41720_().m_41472_() || this.itemHandler.getStackInSlot(3) == ItemStack.f_41583_) && this.itemHandler.getStackInSlot(5).m_41613_() >= this.partenSize() && this.itemHandler.getStackInSlot(5).m_41720_() == ModItems.EMPTY_PILULE.get();
    }

    private boolean hasRecipe() {
        Optional<PurgenFactoryRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = recipe.get().m_8043_(this.m_58904_().m_9598_());
        return this.canInsertAmountIntoOutputSlot(result.m_41613_() * this.partenSize()) && this.canInsertItemIntoOutputSlot(result.m_41720_());
    }

    private Optional<PurgenFactoryRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < 2; ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        FluidStack fstack = this.getFluidStack();
        return PurgenFactoryBlockEntity.getRecipeFor(PurgenFactoryRecipe.Type.INSTANCE, inventory, this.f_58857_, fstack);
    }

    public static <C extends Container, T extends Recipe<C>> Optional<PurgenFactoryRecipe> getRecipeFor(RecipeType<PurgenFactoryRecipe> pRecipeType, SimpleContainer pInventory, Level pLevel, FluidStack fstack) {
        return pLevel.m_7465_().m_44013_(pRecipeType).stream().filter(svo -> svo.match(pInventory, fstack, pLevel)).findFirst();
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(6).m_41619_() || this.itemHandler.getStackInSlot(6).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(6).m_41613_() + count <= this.itemHandler.getStackInSlot(6).m_41741_();
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress(float increaser) {
        this.progress += (int)((float)this.PROGRESS_ACCELERATOR * increaser);
    }

    public int[] m_7071_(Direction pSide) {
        int[] nArray;
        if (pSide == Direction.DOWN) {
            return new int[]{6};
        }
        if (pSide == Direction.UP) {
            int[] nArray2 = new int[2];
            nArray2[0] = 4;
            nArray = nArray2;
            nArray2[1] = 5;
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray3[2] = 2;
            nArray3[3] = 3;
            nArray = nArray3;
            nArray3[4] = 6;
        }
        return nArray;
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return this.m_7013_(pIndex, pItemStack) && IntStream.of(this.m_7071_(pDirection)).anyMatch(x -> x == pIndex);
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return pDirection != Direction.UP && pIndex == 6;
    }

    public int m_6643_() {
        return 8;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int pSlot) {
        return this.itemHandler.getStackInSlot(pSlot);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return this.itemHandler.extractItem(pSlot, pAmount, false);
    }

    public ItemStack m_8016_(int pSlot) {
        return this.itemHandler.extractItem(pSlot, 1, false);
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        ItemStack itemstack = this.itemHandler.getStackInSlot(pSlot);
        boolean flag = !pStack.m_41619_() && ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)pStack);
        this.itemHandler.setStackInSlot(pSlot, pStack);
        if (pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(Player pPlayer) {
        return Container.m_272074_((BlockEntity)this, (Player)pPlayer);
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        if (pIndex == 6) {
            return false;
        }
        if (pIndex == 4 && !pStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("jigsaw_pp:purgen_catalysts")))) {
            return false;
        }
        if (pIndex == 5 && pStack.m_41720_() != ModItems.EMPTY_PILULE.get()) {
            return false;
        }
        return pIndex != 7 || pStack.m_41720_() == ModItems.BATCH_SIZE_CARD.get();
    }

    public void m_6211_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public static void teapot_ticking(LevelAccessor world, double x, double y, double z) {
        Level _level;
        double xRadius = 0.0;
        double loop = 0.0;
        double zRadius = 0.0;
        double particleAmount = 0.0;
        if (world instanceof Level) {
            _level = (Level)world;
            if (!_level.m_5776_()) {
                _level.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jigsaw_pp:whistle")), SoundSource.BLOCKS, 0.1f, 1.0f);
            } else {
                _level.m_7785_(x, y, z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jigsaw_pp:whistle")), SoundSource.BLOCKS, 0.1f, 1.0f, false);
            }
        }
        if (world instanceof ServerLevel) {
            _level = (ServerLevel)world;
            _level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.POOP_BUBBLE.get()), x + 0.5, y + 0.5, z + 0.5, 5, 1.0, 1.0, 1.0, 0.5);
        }
        particleAmount = 64.0;
        xRadius = 0.5;
        zRadius = 0.5;
        for (loop = 0.0; loop < particleAmount; loop += 1.0) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + Math.cos(Math.PI * 2 / particleAmount * loop) * xRadius, y + 0.02 + 0.5, z + Math.sin(Math.PI * 2 / particleAmount * loop) * zRadius, 0.0, 0.01, 0.0);
        }
    }

    static {
        badEvents.put("poop_leak", 90);
        badEvents.put("big_poop_leak", 30);
        badEvents.put("teapodification", 3);
        badEvents.put("teapotification", 6);
        badEvents.put("poop_gas", 45);
        badEvents.put("purgen_gas", 31);
        badEvents.put("explosion", 1);
        catalystEvents = new HashMap<Item, String>();
        catalystEvents.put(Items.f_42403_, "explosion");
    }
}

