/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.block.kega;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.effect.RadiationEffect;
import net.svisvi.jigsawpp.effect.init.ModEffects;

public class KegaBlock
extends Block {
    public static final IntegerProperty ULTRA = IntegerProperty.m_61631_((String)"ultra", (int)0, (int)1);
    private static final float EXPLOSION_RADIUS = 100.0f;
    private static final int DELAY_TICKS = 490;

    public KegaBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_154663_).m_60913_(1.0f, 10.0f).m_60955_().m_60924_((bs, br, bp) -> false));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ULTRA, (Comparable)Integer.valueOf(0)));
    }

    private static void playSoundOnce(ServerLevel world, BlockPos pos, BlockState pState) {
        int n;
        Property property = pState.m_60734_().m_49965_().m_61081_("ultra");
        if (property instanceof IntegerProperty) {
            IntegerProperty _getip1 = (IntegerProperty)property;
            n = (Integer)pState.m_61143_((Property)_getip1);
        } else {
            n = -1;
        }
        if (n == 0) {
            ResourceLocation soundLocation = new ResourceLocation("jigsaw_pp:alpha_bomb");
            world.m_5594_(null, pos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation), SoundSource.NEUTRAL, 2.0f, 1.0f);
        }
    }

    private static void active(BlockPos pPos, BlockState pState, Level pLevel) {
        int n;
        Property property = pState.m_60734_().m_49965_().m_61081_("ultra");
        if (property instanceof IntegerProperty) {
            IntegerProperty _getip1 = (IntegerProperty)property;
            n = (Integer)pState.m_61143_((Property)_getip1);
        } else {
            n = -1;
        }
        if (n == 0) {
            IntegerProperty _integerProp;
            KegaBlock.playSoundOnce((ServerLevel)pLevel, pPos, pState);
            int _value = 1;
            BlockState _bs = pLevel.m_8055_(pPos);
            Property property2 = _bs.m_60734_().m_49965_().m_61081_("ultra");
            if (property2 instanceof IntegerProperty && (_integerProp = (IntegerProperty)property2).m_6908_().contains(_value)) {
                pLevel.m_7731_(pPos, (BlockState)_bs.m_61124_((Property)_integerProp, (Comparable)Integer.valueOf(_value)), 3);
            }
            pLevel.m_186460_(pPos, pState.m_60734_(), 490);
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        int n;
        Property property = state.m_60734_().m_49965_().m_61081_("ultra");
        if (property instanceof IntegerProperty) {
            IntegerProperty _getip1 = (IntegerProperty)property;
            n = (Integer)state.m_61143_((Property)_getip1);
        } else {
            n = -1;
        }
        if (n == 1) {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            world.m_254849_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 100.0f, Level.ExplosionInteraction.BLOCK);
            List entities = world.m_45933_(null, new AABB(pos).m_82400_(100.0));
            for (Entity entity : entities) {
                double distance = entity.m_20238_(Vec3.m_82512_((Vec3i)pos));
                if (!(distance <= 10000.0)) continue;
                RadiationEffect.addEffectLiquidWay(entity, new MobEffectInstance((MobEffect)ModEffects.RADIATION.get(), 14400));
            }
        }
    }

    public void m_5871_(ItemStack itemstack, BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)"\u00a77Really bad explosive, dev only 'cause it sucks ass"));
        super.m_5871_(itemstack, world, tooltip, flag);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ULTRA});
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return true;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List dropsOriginal = super.m_49635_(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    public void m_6861_(BlockState blockstate, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        ServerLevel serverLevel;
        super.m_6861_(blockstate, world, pos, neighborBlock, fromPos, moving);
        if (world instanceof ServerLevel && (serverLevel = (ServerLevel)world).m_276867_(pos)) {
            KegaBlock.active(pos, blockstate, (Level)serverLevel);
        }
    }
}

