/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.block.purgen_factory;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.svisvi.jigsawpp.block.purgen_factory.PurgenCatalystRecipeReader;
import net.svisvi.jigsawpp.config.ModServerConfigs;
import net.svisvi.jigsawpp.item.init.ModItems;
import net.svisvi.jigsawpp.item.pilule.AbstractPiluleItem;
import net.svisvi.jigsawpp.procedures.ut.RegistriesGoon;
import net.svisvi.jigsawpp.recipe.PurgenCatalystRecipe;
import net.svisvi.jigsawpp.recipe.PurgenFactoryRecipe;

public class PurgenPiluleBuilder {
    public static List<String> blacklist_effects = new ArrayList<String>((Collection)ModServerConfigs.PURGEN_EFFECTS_BLACK_LIST.get());
    public static List<Item> PILULE_PROGRESSION = new ArrayList<Item>();
    public static List<MobEffect> mediumEffects;

    public static ItemStack build_main(Optional<PurgenFactoryRecipe> o_recipe, ItemStack food1, ItemStack food2, ItemStack catalyst, Level level, BlockPos pos, BlockState state) {
        return PurgenPiluleBuilder.buildFromPurity_5(PurgenPiluleBuilder.buildFromCatalyst_2(PurgenPiluleBuilder.buildFromRandom_4(PurgenPiluleBuilder.buildFromWorld_3(PurgenPiluleBuilder.buildFromCatalyst_2(PurgenPiluleBuilder.buildFromFood_1(PurgenPiluleBuilder.buildFromRecipe_0(o_recipe), food1, food2), catalyst, level), level, pos)), catalyst, level));
    }

    public static ItemStack buildFromRecipe_0(Optional<PurgenFactoryRecipe> o_recipe) {
        PurgenFactoryRecipe recipe = o_recipe.get();
        ItemStack output_stack = recipe.m_8043_(null);
        AbstractPiluleItem.setDurationBuff(recipe.getAdditionalTime(null), output_stack);
        AbstractPiluleItem.setPurity(recipe.getPurity(null), output_stack);
        PotionUtils.m_43552_((ItemStack)output_stack, recipe.getEffects());
        return output_stack;
    }

    public static ItemStack buildFromFood_1(ItemStack purgen_stack, ItemStack food1, ItemStack food2) {
        int dur_buff = purgen_stack.m_41784_().m_128451_("duration_buff");
        int purity = purgen_stack.m_41784_().m_128451_("purity");
        ArrayList<MobEffectInstance> efs = new ArrayList<MobEffectInstance>();
        float multiplication = (float)food1.m_41720_().m_41473_().m_38744_() / 4.0f + (float)food1.m_41720_().m_41473_().m_38744_() / 2.0f * (food1.m_41720_().m_41473_().m_38745_() / 1.2f);
        multiplication = (float)((double)multiplication * 1.5);
        dur_buff += (int)multiplication / 2;
        purity = (int)((float)purity * (multiplication / 9.0f));
        if (food1.m_41720_().m_41473_().m_38749_() != null) {
            for (Pair pair : food1.m_41720_().m_41473_().m_38749_()) {
                efs.add((MobEffectInstance)pair.getFirst());
            }
        }
        if (food2 != ItemStack.f_41583_) {
            multiplication = (float)food2.m_41720_().m_41473_().m_38744_() / 4.0f + (float)food2.m_41720_().m_41473_().m_38744_() / 2.0f * food2.m_41720_().m_41473_().m_38745_() / 1.2f;
            multiplication = (float)((double)multiplication * 1.5);
            dur_buff += (int)multiplication / 2;
            purity = (int)((float)purity * (multiplication / 4.0f));
            purity = (int)((double)purity / 2.3);
            if (food1.m_41720_() == food2.m_41720_()) {
                purity /= 9;
            }
            if (food2.m_41720_().m_41473_().m_38749_() != null) {
                for (Pair pair : food2.m_41720_().m_41473_().m_38749_()) {
                    efs.add((MobEffectInstance)pair.getFirst());
                }
            }
        } else {
            purity = (int)((double)purity * 0.6);
        }
        AbstractPiluleItem.setDurationBuff(dur_buff, purgen_stack);
        AbstractPiluleItem.setPurity(purity / 2, purgen_stack);
        PotionUtils.m_43552_((ItemStack)purgen_stack, efs);
        return purgen_stack;
    }

    public static ItemStack buildFromCatalyst_2(ItemStack purgen_stack, ItemStack catalyst, Level level) {
        if (catalyst == ItemStack.f_41583_ || !catalyst.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("jigsaw_pp:purgen_catalysts")))) {
            return purgen_stack;
        }
        PurgenCatalystRecipe catalyst_recipe = PurgenCatalystRecipeReader.getCurrentRecipe(catalyst, level).get();
        if (catalyst_recipe == null) {
            return purgen_stack;
        }
        int dur_buff = purgen_stack.m_41784_().m_128451_("duration_buff");
        int purity = purgen_stack.m_41784_().m_128451_("purity");
        List<Object> efs = new ArrayList();
        dur_buff = (int)((float)dur_buff * catalyst_recipe.getAdditionalTimeK(null));
        purity = (int)((float)purity * catalyst_recipe.getPurityK(null));
        efs = catalyst_recipe.getEffects();
        AbstractPiluleItem.setDurationBuff(dur_buff, purgen_stack);
        AbstractPiluleItem.setPurity(purity, purgen_stack);
        if (efs != null) {
            PotionUtils.m_43552_((ItemStack)purgen_stack, efs);
        }
        return purgen_stack;
    }

    public static ItemStack buildFromWorld_3(ItemStack purgen_stack, Level level, BlockPos pos) {
        double koeff = 1.0;
        koeff = Math.abs(PurgenPiluleBuilder.dayTimeCalc(level) * (double)((16 - level.m_46803_(pos)) / 10) * PurgenPiluleBuilder.moonCalc(level) * PurgenPiluleBuilder.temperatureCalc(level, pos));
        int purity = purgen_stack.m_41784_().m_128451_("purity");
        purity = (int)((double)purity * koeff);
        AbstractPiluleItem.setPurity(purity, purgen_stack);
        return purgen_stack;
    }

    public static ItemStack buildFromRandom_4(ItemStack purgen_stack) {
        int purity = purgen_stack.m_41784_().m_128451_("purity");
        Random random = new Random();
        AbstractPiluleItem.setPurity((int)((float)(purity + random.nextInt(18)) + 14.0f * random.nextFloat(2.3f) + 1.8f), purgen_stack);
        return purgen_stack;
    }

    public static ItemStack buildFromPurity_5(ItemStack purgen_stack) {
        ItemStack retStack;
        Random random = new Random();
        int purity = purgen_stack.m_41784_().m_128451_("purity");
        if (purity == 0) {
            purity = 1;
        }
        List previous_list = PotionUtils.m_43571_((ItemStack)purgen_stack);
        if (purity > 100) {
            retStack = purgen_stack;
            AbstractPiluleItem.setPurity(100, retStack);
        }
        if (purity >= 65 && purity < 90) {
            retStack = new ItemStack((ItemLike)ModItems.ADVANCED_PURGEN_PILULE.get());
            AbstractPiluleItem.setPurity(purgen_stack.m_41784_().m_128451_("purity"), retStack);
            AbstractPiluleItem.setDurationBuff(purgen_stack.m_41784_().m_128451_("duration_buff") + (purity + 1) * (purity + 0) * random.nextInt(purity + 0) / 100, retStack);
            PotionUtils.m_43552_((ItemStack)retStack, PurgenPiluleBuilder.concatEffectsLists(PurgenPiluleBuilder.effectsFromPurity(purgen_stack.m_41784_().m_128451_("purity"), 200 + purgen_stack.m_41784_().m_128451_("duration_buff")), previous_list));
        } else if (purity >= 90) {
            retStack = new ItemStack((ItemLike)ModItems.CRYSTAL_PURGEN_PILULE.get());
            AbstractPiluleItem.setPurity(purgen_stack.m_41784_().m_128451_("purity"), retStack);
            AbstractPiluleItem.setDurationBuff(purgen_stack.m_41784_().m_128451_("duration_buff") + (purity + 1) * (purity + 0) * random.nextInt(purity + 0) / 100, retStack);
            PotionUtils.m_43552_((ItemStack)retStack, PurgenPiluleBuilder.concatEffectsLists(PurgenPiluleBuilder.effectsFromPurity(purgen_stack.m_41784_().m_128451_("purity"), 200 + purgen_stack.m_41784_().m_128451_("duration_buff")), previous_list));
        } else {
            retStack = purgen_stack;
            PotionUtils.m_43552_((ItemStack)retStack, PurgenPiluleBuilder.concatEffectsLists(PurgenPiluleBuilder.effectsFromPurity(purgen_stack.m_41784_().m_128451_("purity"), 200 + purgen_stack.m_41784_().m_128451_("duration_buff")), previous_list));
        }
        return retStack;
    }

    public static List<MobEffectInstance> concatEffectsLists(@Nullable List<MobEffectInstance> list1, @Nullable List<MobEffectInstance> list2) {
        if (list1.isEmpty() && list2.isEmpty()) {
            return new ArrayList<MobEffectInstance>();
        }
        if (list1.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list1;
        }
        return Stream.concat(list1.stream(), list2.stream()).collect(Collectors.toList());
    }

    public static double dayTimeCalc(Level level) {
        return Math.cbrt(level.m_8044_() % 9000L + 0L) * 2.0;
    }

    public static double moonCalc(Level level) {
        double q1 = 0.0;
        q1 = level.m_6106_().m_6534_() ? 4.0 : 3.0;
        return (double)level.m_6042_().m_63936_(level.m_8044_()) % q1 - ((double)level.m_6042_().m_63936_(level.m_8044_()) % q1 == 0.0 ? -1.0 : 0.5);
    }

    public static double temperatureCalc(Level level, BlockPos pos) {
        return Math.abs(((Biome)level.m_204166_(pos).m_203334_()).m_47554_() / 100.0f);
    }

    public static boolean isEffectForbidden(MobEffect effect) {
        String ef_name = RegistriesGoon.getEffectRegistryName(effect);
        return blacklist_effects.stream().anyMatch(ef_name::equals);
    }

    public static List<MobEffectInstance> effectsFromPurity(int purity, int duration) {
        ArrayList<MobEffectInstance> effects;
        block9: {
            Random random;
            ImmutableList all_effects;
            block11: {
                block10: {
                    block8: {
                        effects = new ArrayList<MobEffectInstance>();
                        all_effects = ImmutableList.copyOf((Collection)ForgeRegistries.MOB_EFFECTS.getValues());
                        random = new Random();
                        if (purity < 0 || purity >= 20) break block8;
                        int i = 0;
                        while ((double)i < Math.ceil((float)purity % 5.0f + 1.0f)) {
                            MobEffect ef = (MobEffect)all_effects.get(random.nextInt(all_effects.size()));
                            while (ef.m_19486_() || PurgenPiluleBuilder.isEffectForbidden(ef)) {
                                ef = (MobEffect)all_effects.get(random.nextInt(all_effects.size()));
                            }
                            MobEffectInstance mef = new MobEffectInstance(ef, PurgenPiluleBuilder.checkedNextInt(random, duration * 10, purity) * 3, random.nextInt(Math.abs((int)Math.ceil((21 - purity) / 4)) + 1));
                            effects.add(mef);
                            ++i;
                        }
                        break block9;
                    }
                    if (purity < 20 || purity >= 40) break block10;
                    int i = 0;
                    while ((double)i < Math.ceil((float)purity % 5.0f + 1.0f)) {
                        MobEffect ef = (MobEffect)all_effects.get(random.nextInt(all_effects.size()));
                        while (ef.m_19486_() || PurgenPiluleBuilder.isEffectForbidden(ef)) {
                            ef = (MobEffect)all_effects.get(random.nextInt(all_effects.size()));
                        }
                        MobEffectInstance mef = new MobEffectInstance(ef, PurgenPiluleBuilder.checkedNextInt(random, duration * 24, purity) * 3, random.nextInt(Math.abs((int)Math.ceil((40 - purity) / 5)) + 1));
                        effects.add(mef);
                        ++i;
                    }
                    break block9;
                }
                if (purity < 40 || purity >= 60) break block11;
                int i = 0;
                while ((double)i < Math.ceil((float)purity % 5.0f + 1.0f)) {
                    MobEffect ef = mediumEffects.get(random.nextInt(mediumEffects.size()));
                    while (PurgenPiluleBuilder.isEffectForbidden(ef)) {
                        ef = (MobEffect)all_effects.get(random.nextInt(all_effects.size()));
                    }
                    MobEffectInstance mef = new MobEffectInstance(ef, PurgenPiluleBuilder.checkedNextInt(random, duration * 24, purity) * 3, random.nextInt(Math.abs((int)Math.ceil((60 - purity) / 5)) + 1));
                    effects.add(mef);
                    ++i;
                }
                break block9;
            }
            if (purity >= 60 && purity < 80 || purity < 80 || purity > 100) break block9;
            int i = 0;
            while ((double)i < Math.ceil((float)purity % 5.0f + 1.0f)) {
                MobEffect ef = (MobEffect)all_effects.get(random.nextInt(all_effects.size()));
                while (!ef.m_19486_() || PurgenPiluleBuilder.isEffectForbidden(ef)) {
                    ef = (MobEffect)all_effects.get(random.nextInt(all_effects.size()));
                }
                MobEffectInstance mef = new MobEffectInstance(ef, PurgenPiluleBuilder.checkedNextInt(random, duration * 24, purity) * 3, random.nextInt(Math.abs((int)Math.ceil((101 - purity) / 4)) + 1));
                effects.add(mef);
                ++i;
            }
        }
        return effects;
    }

    public static int checkedNextInt(Random random, double n, int purity) {
        return random.nextInt((int)(Math.abs(n / (double)purity + 1.0) + 1.0));
    }

    static {
        PILULE_PROGRESSION.add((Item)ModItems.BASIC_PURGEN_PILULE.get());
        PILULE_PROGRESSION.add((Item)ModItems.ADVANCED_PURGEN_PILULE.get());
        PILULE_PROGRESSION.add((Item)ModItems.CRYSTAL_PURGEN_PILULE.get());
        mediumEffects = new ArrayList<MobEffect>();
        mediumEffects.add(MobEffects.f_19610_);
        mediumEffects.add(MobEffects.f_19604_);
        mediumEffects.add(MobEffects.f_216964_);
        mediumEffects.add(MobEffects.f_19599_);
        mediumEffects.add(MobEffects.f_19619_);
        mediumEffects.add(MobEffects.f_19612_);
        mediumEffects.add(MobEffects.f_19609_);
        mediumEffects.add(MobEffects.f_19597_);
        mediumEffects.add(MobEffects.f_19613_);
    }
}

