/*
 * Decompiled with CFR 0.152.
 */
package net.svisvi.jigsawpp.client.screen.purgen_factory;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.svisvi.jigsawpp.block.entity.PurgenFactoryBlockEntity;
import net.svisvi.jigsawpp.block.init.ModBlocks;
import net.svisvi.jigsawpp.client.screen.ModMenuTypes;
import net.svisvi.jigsawpp.item.init.ModItems;

public class PurgenFactoryMenu
extends AbstractContainerMenu {
    private final PurgenFactoryBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private FluidStack fluidStack;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 8;

    public PurgenFactoryMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(8));
    }

    public PurgenFactoryMenu(int pContainerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.PURGEN_FACTORY_MENU.get(), pContainerId);
        PurgenFactoryMenu.m_38869_((Container)inv, (int)8);
        this.blockEntity = (PurgenFactoryBlockEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.fluidStack = this.blockEntity.getFluidStack();
        this.addPlayerHotbar(inv);
        this.addPlayerInventory(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 0, 26, 6));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 1, 26, 24));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 2, 26, 42));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 3, 26, 60));
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)iItemHandler, 4, 134, 11){
                private final int slot = 4;
                {
                    this.slot = 4;
                }

                public boolean m_5857_(ItemStack itemstack) {
                    return itemstack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("jigsaw_pp:purgen_catalysts")));
                }
            });
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)iItemHandler, 5, 152, 29){
                private final int slot = 5;
                {
                    this.slot = 5;
                }

                public boolean m_5857_(ItemStack itemstack) {
                    return itemstack.m_41720_() == ModItems.EMPTY_PILULE.get();
                }
            });
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)iItemHandler, 6, 152, 60){
                private final int slot = 6;
                {
                    this.slot = 6;
                }

                public boolean m_5857_(ItemStack itemstack) {
                    return false;
                }
            });
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)iItemHandler, 7, 134, 60){
                private final int slot = 7;
                {
                    this.slot = 7;
                }

                public boolean m_5857_(ItemStack itemstack) {
                    return itemstack.m_41720_() == ModItems.BATCH_SIZE_CARD.get();
                }
            });
        });
        this.m_38884_(data);
    }

    public void setFluid(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public PurgenFactoryBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public boolean isCrafting() {
        return this.data.m_6413_(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        int progressArrowSize = 26;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public ItemStack m_7648_(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.f_38839_.get(pIndex);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (pIndex < 36) {
            if (sourceStack.m_41720_() == ModItems.EMPTY_PILULE.get() ? !this.m_38903_(sourceStack, 41, 42, false) : (sourceStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("jigsaw_pp:purgen_catalysts"))) ? !this.m_38903_(sourceStack, 40, 41, false) : (sourceStack.m_41720_() == ModItems.BATCH_SIZE_CARD.get() ? !this.m_38903_(sourceStack, 43, 44, false) : !this.m_38903_(sourceStack, 36, 44, false)))) {
                return ItemStack.f_41583_;
            }
        } else if (pIndex < 44) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player pPlayer) {
        return PurgenFactoryMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)((Block)ModBlocks.PURGEN_FACTORY.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

